/*
 * Decompiled with CFR 0.152.
 */
package print;

import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.RequestingUserName;
import oracle.forms.properties.ID;
import oracle.forms.ui.VBean;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.Orientation;
import org.apache.pdfbox.printing.PDFPageable;
import org.apache.pdfbox.printing.PDFPrintable;
import org.apache.pdfbox.printing.Scaling;

public class DirectPrintBean
extends VBean {
    protected static final ID DEFAULT_PRINTER = ID.registerProperty("DEFAULT_PRINTER");
    protected static final ID SET_PRINT_MATTER = ID.registerProperty("SET_PRINT_MATTER");
    protected static final ID SET_ORIENTATION = ID.registerProperty("SET_ORIENTATION");
    protected static final ID SET_ACROBAT_PATH = ID.registerProperty("SET_ACROBAT_PATH");
    protected static final ID SET_PAGE_WIDTH = ID.registerProperty("SET_PAGE_WIDTH");
    protected static final ID SET_PAGE_HEIGHT = ID.registerProperty("SET_PAGE_HEIGHT");
    protected static final ID SET_NO_OF_COPIES = ID.registerProperty("SET_NO_OF_COPIES");
    protected static final ID SET_SHOW_PRINT_DIALOG = ID.registerProperty("SET_SHOW_PRINT_DIALOG");
    protected static final ID SET_PRINTER = ID.registerProperty("SET_PRINTER");
    protected static final ID IS_ACROBAT_PRINT = ID.registerProperty("IS_ACROBAT_PRINT");
    protected static final ID IS_FILE_PRINT = ID.registerProperty("IS_FILE_PRINT");
    protected static final ID DO_PRINT = ID.registerProperty("DO_PRINT");
    private String print_matter;
    private String printer;
    private String default_printer;
    private String extension;
    private String fileName;
    private static String orientation;
    private static String acrobatPath;
    private static int noOfCopies;
    private static double pageWidth;
    private static double pageHeight;
    private boolean is_file = false;
    private static boolean isAcrobatPrint;
    private static boolean showPrintDialog;
    PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
    private static Process p;
    private static int pageLayout;
    private static Orientation pageOrientation;

    public DirectPrintBean() {
        isAcrobatPrint = false;
        showPrintDialog = false;
        this.fileName = "";
        this.extension = "";
        this.printer = "";
        this.print_matter = "";
        orientation = "portrait";
        acrobatPath = "C:\\Program Files\\Adobe\\Reader 10.0\\Reader\\AcroRd32.exe";
        pageWidth = 8.27;
        pageHeight = 11.69;
        noOfCopies = 1;
    }

    @Override
    public boolean setProperty(ID id, Object value) {
        boolean success = true;
        if (id == SET_PRINTER) {
            this.printer = (String)value;
        }
        if (id == SET_PRINT_MATTER) {
            this.print_matter = (String)value;
        }
        if (id == SET_ORIENTATION) {
            if (((String)value).equalsIgnoreCase("landscape")) {
                orientation = "landscape";
                pageLayout = 0;
            } else {
                orientation = "portrait";
                pageLayout = 1;
            }
        }
        if (id == SET_ACROBAT_PATH) {
            acrobatPath = (String)value;
        }
        if (id == SET_PAGE_WIDTH) {
            pageWidth = Double.parseDouble("" + value);
        }
        if (id == SET_PAGE_HEIGHT) {
            pageHeight = Double.parseDouble("" + value);
        }
        if (id == SET_NO_OF_COPIES) {
            noOfCopies = Integer.parseInt("" + value);
        }
        if (id == SET_SHOW_PRINT_DIALOG) {
            showPrintDialog = ((String)value).equalsIgnoreCase("true");
        }
        if (id == IS_FILE_PRINT) {
            this.is_file = ((String)value).equalsIgnoreCase("true");
        }
        if (id == IS_ACROBAT_PRINT) {
            isAcrobatPrint = ((String)value).equalsIgnoreCase("true");
        }
        if (id == DO_PRINT) {
            if (this.printer.equals("")) {
                PrintService service = PrintServiceLookup.lookupDefaultPrintService();
                this.printer = service.getName();
            }
            if (this.print_matter.equals("")) {
                System.out.println("Set Matter To Print...");
            } else {
                System.out.println("Printer : " + this.printer);
                System.out.println("Is File : " + this.is_file);
                this.printTo(this.printer, this.print_matter, this.is_file);
            }
        } else {
            success = super.setProperty(id, value);
        }
        return success;
    }

    @Override
    public Object getProperty(ID id) {
        if (id == DEFAULT_PRINTER) {
            try {
                PrintService service = PrintServiceLookup.lookupDefaultPrintService();
                this.default_printer = service.getName();
                return this.default_printer;
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private boolean printTo(String printerName, String fileNameOrContent, boolean isFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PrintService getServiceByPrinter(String printerName) {
        System.out.println("Printer Count : " + this.printServices.length);
        for (int i = 0; i < this.printServices.length; ++i) {
            PrintService printerObj = this.printServices[i];
            if (!printerObj.getName().equalsIgnoreCase(printerName)) continue;
            return printerObj;
        }
        return null;
    }

    private String getExtension() {
        String ext = "";
        int i = this.fileName.lastIndexOf(46);
        if (i > 0) {
            ext = this.fileName.substring(i + 1);
        }
        return ext;
    }

    public static void printPDF(File file, PrintService printService) {
        if (isAcrobatPrint) {
            try {
                Process process = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + file.getAbsolutePath());
            }
            catch (IOException e) {
                System.out.println("Acrobat Print Exception : " + e);
            }
        } else {
            try {
                PrinterJob pjob = PrinterJob.getPrinterJob();
                pjob.setPrintService(printService);
                pjob.setJobName(file.getName());
                PDDocument doc = PDDocument.load(file);
                if (printService != null) {
                    MediaSize ms;
                    System.out.println("1");
                    switch (pageLayout) {
                        case 1: {
                            pageOrientation = Orientation.PORTRAIT;
                            break;
                        }
                        case 0: {
                            pageOrientation = Orientation.LANDSCAPE;
                            break;
                        }
                        default: {
                            pageOrientation = Orientation.AUTO;
                        }
                    }
                    System.out.println("2");
                    HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                    aset.add(new Copies(noOfCopies));
                    aset.add(new RequestingUserName("Administrator", null));
                    System.out.println("2.5");
                    if (pageWidth == 0.0 && pageHeight == 0.0) {
                        aset.add(MediaSizeName.ISO_A4);
                        ms = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4);
                        aset.add(new MediaPrintableArea(0.0f, 0.0f, ms.getX(25400), ms.getY(25400), 25400));
                        PDFPageable pdfPageable = new PDFPageable(doc, pageOrientation, false);
                        pjob.setPageable(pdfPageable);
                    } else if (pageWidth == -1.0 && pageHeight == -1.0) {
                        PDFPageable pdfPageable = new PDFPageable(doc, pageOrientation, false);
                        pjob.setPageable(pdfPageable);
                    } else if (pageWidth == -2.0 && pageHeight == -2.0) {
                        aset.add(MediaSizeName.ISO_A5);
                        ms = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A5);
                        aset.add(new MediaPrintableArea(0.0f, 0.0f, ms.getX(25400), ms.getY(25400), 25400));
                        PDFPageable pdfPageable = new PDFPageable(doc, pageOrientation, false);
                        pjob.setPageable(pdfPageable);
                    } else if (pageWidth == -3.0 && pageHeight == -3.0) {
                        aset.add(MediaSizeName.ISO_A3);
                        ms = MediaSize.getMediaSizeForName(MediaSizeName.ISO_A3);
                        aset.add(new MediaPrintableArea(0.0f, 0.0f, ms.getX(25400), ms.getY(25400), 25400));
                        PDFPageable pdfPageable = new PDFPageable(doc, pageOrientation, false);
                        pjob.setPageable(pdfPageable);
                    } else {
                        Paper paper = new Paper();
                        paper.setSize(pageWidth * 100.0, pageHeight * 100.0);
                        paper.setImageableArea(0.0, -110.0, paper.getWidth(), paper.getHeight());
                        PageFormat pageFormat = new PageFormat();
                        pageFormat.setPaper(paper);
                        Book book = new Book();
                        book.append(new PDFPrintable(doc, Scaling.SHRINK_TO_FIT), pageFormat, doc.getNumberOfPages());
                        pjob.setPageable(book);
                    }
                    System.out.println("6");
                    if (showPrintDialog) {
                        if (pjob.printDialog()) {
                            try {
                                pjob.print();
                            }
                            catch (PrinterException exc) {
                                System.out.println(exc);
                            }
                        }
                    } else {
                        pjob.print(aset);
                    }
                }
            }
            catch (FileNotFoundException ex) {
                System.out.println("File Not Found.......");
            }
            catch (IOException ex) {
                System.out.println("IO Error......." + ex);
            }
            catch (PrinterException ex) {
                System.out.println("Printer Error.......");
            }
            catch (Exception ex) {
                System.out.println("Exception....... : " + ex);
            }
        }
    }

    public void printTest() {
        this.setProperty(SET_PAGE_WIDTH, "5.83");
        this.setProperty(SET_PAGE_HEIGHT, "8.27");
        this.setProperty(SET_PRINT_MATTER, "http://appsvr1.sctimst.ac.in/reports/rwservlet?report=C:/SCT_FORMS/cashcounter/Rpt_OP_Bill_New.rdf&userid=cash/cashier@surya&destype=cache&PDFEMBED=YES&desformat=pdf&T_LOCATION=H&T_FYEAR=2021-22&T_TCODE=2&T_BILL_NUMBER=8556");
        this.setProperty(IS_FILE_PRINT, "true");
        this.setProperty(DO_PRINT, "PRINT");
    }

    public static void main(String[] args) {
        DirectPrintBean obj = new DirectPrintBean();
        obj.printTest();
    }

    static {
        pageLayout = 1;
        pageOrientation = Orientation.PORTRAIT;
    }
}

