/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.descriptor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontLike;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.font.util.FontMetaDataValidation;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpParsingException;

public abstract class FontDescriptorHelper<T extends FontContainer> {
    protected T fContainer;
    protected PreflightContext context;
    protected PDFontLike font;
    protected PDFontDescriptor fontDescriptor;
    private static final Set<String> MANDATORYFIELDS = new HashSet<String>();

    public FontDescriptorHelper(PreflightContext context, PDFontLike font, T fontContainer) {
        this.fContainer = fontContainer;
        this.context = context;
        this.font = font;
    }

    public void validate() {
        PDFontDescriptor fd = this.font.getFontDescriptor();
        boolean isStandard14 = false;
        if (this.font instanceof PDFont) {
            isStandard14 = ((PDFont)this.font).isStandard14();
        }
        if (fd != null) {
            this.fontDescriptor = fd;
            if (!isStandard14) {
                this.checkMandatoryFields(this.fontDescriptor.getCOSObject());
            }
            if (this.hasOnlyOneFontFile(this.fontDescriptor)) {
                PDStream fontFile = this.extractFontFile(this.fontDescriptor);
                if (fontFile != null) {
                    this.processFontFile(this.fontDescriptor, fontFile);
                    this.checkFontFileMetaData(this.fontDescriptor, fontFile);
                }
            } else if (this.fontFileNotEmbedded(this.fontDescriptor)) {
                ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", this.fontDescriptor.getFontName() + ": FontFile entry is missing from FontDescriptor"));
                ((FontContainer)this.fContainer).notEmbedded();
            } else {
                ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", this.fontDescriptor.getFontName() + ": They is more than one FontFile"));
            }
        } else {
            ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("3.1.2", this.font.getName() + ": FontDescriptor is null or is an AFM Descriptor"));
            ((FontContainer)this.fContainer).notEmbedded();
        }
    }

    protected boolean checkMandatoryFields(COSDictionary fDescriptor) {
        COSBase type;
        boolean result = true;
        StringBuilder missingFields = new StringBuilder();
        for (String field : MANDATORYFIELDS) {
            if (fDescriptor.containsKey(field)) continue;
            if (missingFields.length() > 1) {
                missingFields.append(", ");
            }
            missingFields.append(field);
        }
        if (fDescriptor.containsKey(COSName.TYPE) && !COSName.FONT_DESC.equals(type = fDescriptor.getItem(COSName.TYPE))) {
            ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("3.1.2", this.font.getName() + ": /Type in FontDescriptor must be /FontDescriptor, but is " + type));
            result = false;
        }
        if (missingFields.length() > 0) {
            ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("3.1.2", this.font.getName() + ": some mandatory fields are missing from the FontDescriptor: " + missingFields + "."));
            result = false;
        }
        return result;
    }

    public abstract PDStream extractFontFile(PDFontDescriptor var1);

    protected boolean hasOnlyOneFontFile(PDFontDescriptor fontDescriptor) {
        PDStream ff1 = fontDescriptor.getFontFile();
        PDStream ff2 = fontDescriptor.getFontFile2();
        PDStream ff3 = fontDescriptor.getFontFile3();
        return ff1 != null ^ ff2 != null ^ ff3 != null;
    }

    protected boolean fontFileNotEmbedded(PDFontDescriptor fontDescriptor) {
        PDStream ff1 = fontDescriptor.getFontFile();
        PDStream ff2 = fontDescriptor.getFontFile2();
        PDStream ff3 = fontDescriptor.getFontFile3();
        return ff1 == null && ff2 == null && ff3 == null;
    }

    protected abstract void processFontFile(PDFontDescriptor var1, PDStream var2);

    protected void checkFontFileMetaData(PDFontDescriptor fontDescriptor, PDStream fontFile) {
        block7: {
            try {
                PDMetadata metadata = fontFile.getMetadata();
                if (metadata == null) break block7;
                if (metadata.getFilters() != null && !metadata.getFilters().isEmpty()) {
                    ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("1.2.7", this.font.getName() + ": Filter specified in font file metadata dictionnary"));
                    return;
                }
                byte[] mdAsBytes = this.getMetaDataStreamAsBytes(metadata);
                try {
                    DomXmpParser xmpBuilder = new DomXmpParser();
                    XMPMetadata xmpMeta = xmpBuilder.parse(mdAsBytes);
                    FontMetaDataValidation fontMDval = new FontMetaDataValidation();
                    ArrayList<ValidationResult.ValidationError> ve = new ArrayList<ValidationResult.ValidationError>();
                    fontMDval.analyseFontName(xmpMeta, fontDescriptor, ve);
                    fontMDval.analyseRights(xmpMeta, fontDescriptor, ve);
                    ((FontContainer)this.fContainer).push(ve);
                }
                catch (XmpParsingException e) {
                    if (e.getErrorType() == XmpParsingException.ErrorType.NoValueType) {
                        ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("7.6", e.getMessage(), e));
                        break block7;
                    }
                    if (e.getErrorType() == XmpParsingException.ErrorType.XpacketBadEnd) {
                        ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("7.1.5", this.font.getName() + ": Unable to parse font metadata due to : " + e.getMessage(), e));
                        break block7;
                    }
                    ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("7.1", e.getMessage(), e));
                }
            }
            catch (IllegalStateException e) {
                ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("7.1.3", this.font.getName() + ": The Metadata entry doesn't reference a stream object", e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] getMetaDataStreamAsBytes(PDMetadata metadata) {
        byte[] result = null;
        ByteArrayOutputStream bos = null;
        COSInputStream metaDataContent = null;
        try {
            bos = new ByteArrayOutputStream();
            metaDataContent = metadata.createInputStream();
            IOUtils.copy(metaDataContent, bos);
            result = bos.toByteArray();
        }
        catch (IOException e) {
            try {
                ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("7.1.4", this.font.getName() + ": Unable to read font metadata due to : " + e.getMessage(), e));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(metaDataContent);
                IOUtils.closeQuietly(bos);
                throw throwable;
            }
            IOUtils.closeQuietly(metaDataContent);
            IOUtils.closeQuietly(bos);
        }
        IOUtils.closeQuietly(metaDataContent);
        IOUtils.closeQuietly(bos);
        return result;
    }

    public static boolean isSubSet(String fontName) {
        return fontName != null && fontName.matches("^[A-Z]{6}\\+.*");
    }

    static {
        MANDATORYFIELDS.add("Flags");
        MANDATORYFIELDS.add("ItalicAngle");
        MANDATORYFIELDS.add("CapHeight");
        MANDATORYFIELDS.add("FontBBox");
        MANDATORYFIELDS.add("Ascent");
        MANDATORYFIELDS.add("Descent");
        MANDATORYFIELDS.add("StemV");
        MANDATORYFIELDS.add(COSName.FONT_NAME.getName());
        MANDATORYFIELDS.add(COSName.TYPE.getName());
    }
}

