/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.ssl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.security.ssl.OracleSSLCipherSuite;
import oracle.security.ssl.OracleSSLCredential;
import oracle.security.ssl.OracleSSLSocketFactory;

public class SSLSocketTest {
    public static String eas18PvtKey = "MIICEDAaBgkqhkiG9w0BBQMwDQQITGUs+qNqIqsCAQUEggHwrRuGemlqmhSKXcWX7+yzTDnUDcO7PsTYWRbWg43QGhITiTXMqwZdIvj9wVGI9WIWZlA/1cbAtvbdokrJsJZ3QkzPjYDcTvmU3X6quOPvg4FXxxSW2QTpkxRnT4PJD2esmgs4Kp9FK+TmLehIOx6HCC4lmfhgPaMkmX9MYUoOaPP0xRWd7FiR7RWKVYSbgDj7PyjfOOr/Rhv6vy+RYHEtK+OWQbn1X64TBsmV9rLbe89r9XjXp3YUjS4wtVmIKItUr59bKSKJV7HZLkUdXIYTf4cdnKK3Rz+FNHc1wNt97YVAESodShw/ry2zbg5OCpiCfniu+yxXyc69GTzCi/WxZWgJmtRUbaM/d01VpNbZovjds1lHbcAq5NYRxhWjDmxZCI9awU21CriV+k2fOiKg8mgbZppYLj2HCcnXTaO1WxwN21GpRMgPaW/zqb8GQfD+W5pFxSVRffDJVx+gKhuOXua6MvB8+BDJD1MZQpVshsfc0Gn5W1KE7HkgjuLW2k8z0gC/t/tdWX5BZ60PwuklrqVpDaCqCWEnrmLDPtmraU+rD3LwWoS+Jmi+x/jIJhijbeRg3PnHlp43bpqCijtAiYUTlcSbyeoOYHWQdajr+KYSWMk/X22lNvxVz3InRiYIWzm59MQ+aBmESMR4WzvYPQ==";
    public static String eas18Cert = "MIICezCCAeSgAwIBAgICAi8wDQYJKoZIhvcNAQEEBQAwazELMAkGA1UEBhMCVVMxDzANBgNVBAoTBk9yYWNsZTEoMCYGA1UECxMfRW50ZXJwcmlzZSBBcHBsaWNhdGlvbiBTZXJ2aWNlczEhMB8GA1UEAxMYRUFTUUEgQ2VydGlmaWNhdGUgU2VydmVyMB4XDTk5MDYyMzE5MzA0NFoXDTk5MTIyMDE5MzA0NFowgYYxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpDYWxpZm9ybmlhMRcwFQYDVQQHEw5SZWR3b29kIFNob3JlczEaMBgGA1UEChMRT3JhY2xlIENvcG9yYXRpb24xDzANBgNVBAsTBnBraXNlYzEcMBoGA1UEAxMTZWFzMTgudXMub3JhY2xlLmNvbTB8MA0GCSqGSIb3DQEBAQUAA2sAMGgCYQDsUH79VxhFhk0g3ZS31O3ylkYDTdwetF1+M+NPOGKFZnPxaPc1VgI6dpGCW44hh+Z+wACGdhHyMY56hOcJTkeETY9WgV58GwgmiklrACbBBnKZ7Nj8IA6tr9Iek5SHFC8CAwEAAaM2MDQwEQYJYIZIAYb4QgEBBAQDAgDAMB8GA1UdIwQYMBaAFAwh8BLiXyBVw2u7bmDTvGzsNRGMMA0GCSqGSIb3DQEBBAUAA4GBAIrbuBZyqlHnte/1bE+T4XPZ4o5YHW3qSW1rK1Mzqi1i+xTWARgveOow4a5W8TPU7jbTXGrD4YE8Y7BnQycFJs9kdMgLaIniA2n77TNSDoG4Of2ianejRocrxCg9Fwi5ciBT0lc2LMXZZTAD/wxN7jZTN3kkhky6LSrum159Sk1E";
    public static String easQACA = "MIICjjCCAfegAwIBAgIBATANBgkqhkiG9w0BAQQFADBrMQswCQYDVQQGEwJVUzEPMA0GA1UEChMGT3JhY2xlMSgwJgYDVQQLEx9FbnRlcnByaXNlIEFwcGxpY2F0aW9uIFNlcnZpY2VzMSEwHwYDVQQDExhFQVNRQSBDZXJ0aWZpY2F0ZSBTZXJ2ZXIwHhcNOTgwNDE1MDA0NTQ1WhcNMDAwNDE0MDA0NTQ1WjBrMQswCQYDVQQGEwJVUzEPMA0GA1UEChMGT3JhY2xlMSgwJgYDVQQLEx9FbnRlcnByaXNlIEFwcGxpY2F0aW9uIFNlcnZpY2VzMSEwHwYDVQQDExhFQVNRQSBDZXJ0aWZpY2F0ZSBTZXJ2ZXIwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBANi0bMVLgXMLZZKPg89YhtZ23vtbq2DV7ofReEqvki4Xz9Vvua24YAi3qduCwfLWpznjSca/kNC9inU417vSq2ckpmtrfYgBI+4BbOM9/Moc8491hOmJXyQLJ+Gbhhijp/i/AZ6S/UEApwSJdNV40EIat1zSiuiGPtIa7sscekBTAgMBAAGjQjBAMB0GA1UdDgQWBBQMIfAS4l8gVcNru25g07xs7DURjDAfBgNVHSMEGDAWgBQMIfAS4l8gVcNru25g07xs7DURjDANBgkqhkiG9w0BAQQFAAOBgQDJL7u3HvNdtbeeA/MoMNoFet3Rat89/Im1lukJRZ5MMm+a45c9LdwXAfbPr2PgNvwEUH6g4eVRVBwi2Nel+yp8bmui8MC50g/5uVB72g/5wGbzvt8VxSeQ84muzi91dhZlwVEt6WV8Qkc7m7+R5Y2h56gcL87gxJx6cwoUBjjqQg==";

    public static void exchangeData(SSLSocket sSLSocket) throws IOException {
        String string = "GET / HTTP/1.0 \r\n\r\n";
        BufferedInputStream bufferedInputStream = new BufferedInputStream(sSLSocket.getInputStream(), 8192);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(sSLSocket.getOutputStream(), string.length());
        bufferedOutputStream.write(string.getBytes(), 0, string.length());
        bufferedOutputStream.flush();
        System.out.println("Server Response:");
        System.out.println("----------------");
        String string2 = new String();
        byte[] byArray = new byte[4096];
        int n = 0;
        do {
            if ((n = bufferedInputStream.read(byArray, 0, byArray.length)) <= 0) continue;
            string2 = new String(byArray, 0, n);
            System.out.print(string2);
        } while (n > 0);
        System.out.println();
        bufferedOutputStream.close();
        bufferedInputStream.close();
    }

    public static void main(String[] stringArray) {
        if (OracleSSLCipherSuite.isSSLLibDomestic()) {
            System.out.println("Domestic SSL library");
        } else {
            System.out.println("Export SSL library");
        }
        String string = "";
        int n = 0;
        try {
            string = stringArray[0];
        }
        catch (Exception exception) {
            string = "localhost";
        }
        try {
            n = new Integer(stringArray[1]);
        }
        catch (Exception exception) {
            n = 443;
        }
        String string2 = System.getProperty("PROXY");
        String string3 = System.getProperty("CERTDBFILE");
        String string4 = System.getProperty("CERTDBPASS", "welcome1");
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("SSLSocketFactoryImplClass", "oracle.security.ssl.OracleSSLSocketFactoryImpl");
        try {
            String[] stringArray2;
            OracleSSLSocketFactory oracleSSLSocketFactory = (OracleSSLSocketFactory)SSLSocketFactory.getDefault();
            oracleSSLSocketFactory.setSSLProtocolVersion(768);
            OracleSSLCredential oracleSSLCredential = new OracleSSLCredential();
            if (string3 == null) {
                System.out.println("certdb is null");
            } else {
                System.out.println("Using wallet in " + string3 + " with password " + string4);
                oracleSSLCredential.setWallet(string3, string4);
            }
            oracleSSLSocketFactory.setSSLCredentials(oracleSSLCredential);
            boolean bl = true;
            if (string2 != null && string2.equals("Y")) {
                bl = false;
            }
            SSLSocket sSLSocket = null;
            if (bl) {
                sSLSocket = (SSLSocket)oracleSSLSocketFactory.createSocket(string, n);
            } else {
                stringArray2 = new Socket("www-proxy1", 80);
                if (SSLSocketTest.makeProxyConnection((Socket)stringArray2, string, n)) {
                    System.out.println("Proxy enable sucessfully");
                }
                sSLSocket = (SSLSocket)oracleSSLSocketFactory.createSocket((Socket)stringArray2);
            }
            stringArray2 = sSLSocket.getSupportedCipherSuites();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                System.out.println(stringArray2[n2]);
                ++n2;
            }
            sSLSocket.setEnabledCipherSuites(stringArray2);
            sSLSocket.startHandshake();
            System.out.println("Negotiated Cipher Suite: " + sSLSocket.getSession().getCipherSuite());
            X509Certificate[] x509CertificateArray = sSLSocket.getSession().getPeerCertificateChain();
            SSLSocketTest.verifyPeerCertChain(x509CertificateArray);
            SSLSocketTest.exchangeData(sSLSocket);
            sSLSocket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    private static boolean makeProxyConnection(Socket socket, String string, int n) {
        try {
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            String string2 = String.valueOf(n);
            String string3 = "CONNECT " + string + ":" + string2 + " HTTP/1.0\r\n" + "User-Agent: Oracle Proxy Enabled SSL Socket\r\n\r\n";
            outputStream.write(string3.getBytes(), 0, string3.length());
            byte[] byArray = new byte[2048];
            int n2 = inputStream.read(byArray, 0, 2048);
            System.out.println("Proxy Message:\n" + new String(byArray, 0, n2));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void verifyPeerCertChain(X509Certificate[] x509CertificateArray) {
        int n = 0;
        while (n < x509CertificateArray.length) {
            System.out.println("---------------------------");
            System.out.println("PeerCert [" + n + "] Information:");
            System.out.println("-Subjec: " + x509CertificateArray[n].getSubjectDN().getName());
            System.out.println("-Issuer: " + x509CertificateArray[n].getIssuerDN().getName());
            System.out.println("-Version: " + x509CertificateArray[n].getVersion());
            System.out.println("-StartTime: " + x509CertificateArray[n].getNotBefore().toString());
            System.out.println("-EndTime: " + x509CertificateArray[n].getNotAfter().toString());
            System.out.println("-SigAlgorithm: " + x509CertificateArray[n].getSigAlgName());
            System.out.println("-SigAlgParams: " + x509CertificateArray[n].getSigAlgParams());
            System.out.println("-SigAlgOID: " + x509CertificateArray[n].getSigAlgOID());
            System.out.println("-SerialNumber: " + x509CertificateArray[n].getSerialNumber());
            try {
                x509CertificateArray[n].checkValidity();
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
            ++n;
        }
    }
}

