/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.ssl;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.security.cert.X509CertificateImpl;
import oracle.security.jwallet.JWalletPersona;
import oracle.security.jwallet.JWalletPvtKey;
import oracle.security.jwallet.txtwallet.TxtWalletReader;
import oracle.security.ssl.OracleSSLCipherSuite;
import oracle.security.ssl.OracleSSLCredential;
import oracle.security.ssl.OracleSSLSession;
import oracle.security.ssl.OracleSSLSocketFactory;
import oracle.security.ssl.OracleSSLSocketImpl;
import oracle.security.ssl.OracleSSLSocketInputStream;
import oracle.security.ssl.OracleSSLSocketOutputStream;
import sun.misc.BASE64Encoder;

public final class SSLSocTest {
    public static OracleSSLSocketFactory m_sslSocFactory;
    public static OracleSSLCredential m_sslCredObj;
    public static String m_hostName;
    public static int m_portNum;
    public static String m_certdb;
    public static String m_walletPassword;

    public static void connectionTest(SSLSocket sSLSocket) {
        try {
            sSLSocket.startHandshake();
            System.out.println("Negotiated Cipher Suite: " + sSLSocket.getSession().getCipherSuite());
            X509Certificate[] x509CertificateArray = sSLSocket.getSession().getPeerCertificateChain();
            int n = 0;
            while (n < x509CertificateArray.length) {
                System.out.println("---------------------------");
                System.out.println(x509CertificateArray[n].toString());
                x509CertificateArray[n].checkValidity();
                ++n;
            }
            SSLSocTest.exchangeData(sSLSocket);
            sSLSocket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private static String encodeData(byte[] byArray) throws IOException {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (n < byArray.length) {
            byte[] byArray2 = byArray.length - n >= 57 ? new byte[57] : new byte[byArray.length - n];
            int n2 = 0;
            while (n2 < byArray2.length && n < byArray.length) {
                byArray2[n2] = byArray[n];
                ++n2;
                ++n;
            }
            bASE64Encoder.encode(byArray2, (OutputStream)byteArrayOutputStream);
        }
        return byteArrayOutputStream.toString();
    }

    public static void exchangeData(SSLSocket sSLSocket) throws IOException {
        String string = "G";
        String string2 = "ET ";
        String string3 = "/ HTTP/1.0 \r\n\r\n";
        BufferedInputStream bufferedInputStream = new BufferedInputStream(sSLSocket.getInputStream(), 8192);
        OutputStream outputStream = sSLSocket.getOutputStream();
        outputStream.write(string.getBytes()[0]);
        outputStream.write(string2.getBytes(), 0, string2.length());
        outputStream.write(string3.getBytes());
        outputStream.flush();
        System.out.println("Server Response:");
        System.out.println("----------------");
        String string4 = new String();
        byte[] byArray = new byte[4096];
        int n = 0;
        do {
            if ((n = bufferedInputStream.read(byArray)) <= 0) continue;
            string4 = new String(byArray, 0, n);
            System.out.print(string4);
        } while (n > 0);
        System.out.println();
        if (bufferedInputStream.read() != -1) {
            System.out.println("Data left in stream");
        }
        outputStream.close();
        bufferedInputStream.close();
    }

    public static void main(String[] stringArray) {
        if (OracleSSLCipherSuite.isSSLLibDomestic()) {
            System.out.println("Domestic SSL library");
        } else {
            System.out.println("Export SSL library");
        }
        try {
            m_hostName = stringArray[0];
        }
        catch (Exception exception) {
            m_hostName = "localhost";
        }
        try {
            m_portNum = new Integer(stringArray[1]);
        }
        catch (Exception exception) {
            m_portNum = 443;
        }
        String string = System.getProperty("SSL_VERSION", "SSL_Version_Undetermined");
        Properties properties = System.getProperties();
        ((Hashtable)properties).put("SSLSocketFactoryImplClass", "oracle.security.ssl.OracleSSLSocketFactoryImpl");
        m_sslSocFactory = (OracleSSLSocketFactory)SSLSocketFactory.getDefault();
        try {
            if (string.equalsIgnoreCase("SSL_Version_3_0")) {
                m_sslSocFactory.setSSLProtocolVersion(768);
            } else if (string.equalsIgnoreCase("SSL_Version_3_0_Only")) {
                m_sslSocFactory.setSSLProtocolVersion(101);
            } else if (string.equalsIgnoreCase("SSL_Version_3_0_With_2_0_Hello")) {
                m_sslSocFactory.setSSLProtocolVersion(100);
            } else if (string.equalsIgnoreCase("SSL_Version_2_0")) {
                m_sslSocFactory.setSSLProtocolVersion(2);
            } else if (string.equalsIgnoreCase("SSL_Version_Undetermined")) {
                m_sslSocFactory.setSSLProtocolVersion(0);
            } else {
                System.out.println("SSL Version is not set correctlyUsing SSL_Version_Undetermined");
                m_sslSocFactory.setSSLProtocolVersion(0);
            }
            System.out.println("SSL Version is " + string);
            OracleSSLCredential oracleSSLCredential = new OracleSSLCredential();
            m_certdb = System.getProperty("CERTDBFILE");
            m_walletPassword = System.getProperty("CERTDBPASS", "welcome1");
            if (m_certdb == null) {
                System.out.println("certdb is null");
            } else {
                System.out.println("Using wallet in " + m_certdb + " with password " + m_walletPassword);
                oracleSSLCredential.setWallet(m_certdb, m_walletPassword);
            }
            m_sslSocFactory.setSSLCredentials(oracleSSLCredential);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = 0;
        while (n < stringArray[2].length()) {
            switch (stringArray[2].charAt(n)) {
                case 'c': {
                    String[] stringArray2 = m_sslSocFactory.getDefaultCipherSuites();
                    System.out.println("Default Cipher Suites:");
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        System.out.println(stringArray2[n2]);
                        ++n2;
                    }
                    stringArray2 = m_sslSocFactory.getSupportedCipherSuites();
                    System.out.println("Supported Cipher Suites:");
                    n2 = 0;
                    while (n2 < stringArray2.length) {
                        System.out.println(stringArray2[n2]);
                        ++n2;
                    }
                    stringArray2 = OracleSSLCipherSuite.getSupportedDHCipherSuites();
                    System.out.println("Supported DH Cipher Suites:");
                    n2 = 0;
                    while (n2 < stringArray2.length) {
                        System.out.println(stringArray2[n2]);
                        ++n2;
                    }
                    break;
                }
                case 'C': {
                    try {
                        System.out.println("Testing Basic Functionality");
                        SSLSocTest.connectionTest((SSLSocket)m_sslSocFactory.createSocket(m_hostName, m_portNum));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.out);
                    }
                    break;
                }
                case 'S': {
                    System.out.println("Testing Socket Creation");
                    SSLSocTest.socketCreationTest();
                    break;
                }
                case 's': {
                    OracleSSLSocketImpl oracleSSLSocketImpl;
                    try {
                        System.out.println("Testing Various Socket Functionality");
                        oracleSSLSocketImpl = (OracleSSLSocketImpl)m_sslSocFactory.createSocket(m_hostName, m_portNum);
                        SSLSocTest.socketFuncTest(oracleSSLSocketImpl);
                        oracleSSLSocketImpl.finalize();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.out);
                    }
                    try {
                        oracleSSLSocketImpl = (OracleSSLSocketImpl)m_sslSocFactory.createSocket(m_hostName, m_portNum);
                        OracleSSLSocketImpl oracleSSLSocketImpl2 = new OracleSSLSocketImpl(oracleSSLSocketImpl);
                        SSLSocTest.socketFuncTest(oracleSSLSocketImpl2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.out);
                    }
                    break;
                }
                case 'W': 
                case 'w': {
                    if (m_certdb == null) {
                        System.out.println("Wallet not supplied");
                        break;
                    }
                    try {
                        System.out.println("Testing Wallet Creation");
                        SSLSocTest.walletCreationTest(stringArray[2].charAt(n) == 'W');
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.out);
                    }
                    break;
                }
                case 'X': {
                    try {
                        System.out.println("Testing OracleSSLSession functions");
                        SSLSocTest.sslSessionTest();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace(System.out);
                    }
                    break;
                }
                case 'H': 
                case 'h': {
                    System.out.println("Usage: java SSLSocTest.java <host> <port> [cWwCSHh]");
                    System.out.println("c = Print Ciphers");
                    System.out.println("C = Connect to host:port");
                    System.out.println("S = Socket Creation Test");
                    System.out.println("s = Socket Functionality Test");
                    System.out.println("W, w = Credential creation Test");
                    System.out.println("H, h = This Message");
                    break;
                }
                default: {
                    System.out.println("Invalid Parameter " + stringArray[2].charAt(n));
                    System.out.println("Usage: java SSLSocTest.java <host> <port> [cCSWwHh]");
                }
            }
            ++n;
        }
    }

    public static void socketCreationTest() {
        InetAddress inetAddress;
        InetAddress inetAddress2;
        try {
            inetAddress2 = InetAddress.getByName(m_hostName);
            inetAddress = InetAddress.getLocalHost();
        }
        catch (Exception exception) {
            System.out.println("Unable to resolve hostname");
            return;
        }
        try {
            System.out.println("createSocket(String, int)");
            SSLSocTest.connectionTest((SSLSocket)m_sslSocFactory.createSocket(m_hostName, m_portNum));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        try {
            System.out.println("createSocket(Inet, int)");
            SSLSocTest.connectionTest((SSLSocket)m_sslSocFactory.createSocket(inetAddress2, m_portNum));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        try {
            System.out.println("createSocket(host, port, inetAddress, port2)");
            SSLSocTest.connectionTest((SSLSocket)m_sslSocFactory.createSocket(m_hostName, m_portNum, inetAddress, 19978));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        try {
            System.out.println("createSocket(inetAddress1, port1, inetAddress2, port2)");
            SSLSocTest.connectionTest((SSLSocket)m_sslSocFactory.createSocket(inetAddress2, m_portNum, inetAddress, 19978));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public static void socketFuncTest(OracleSSLSocketImpl oracleSSLSocketImpl) throws IOException {
        System.out.println("New socket created: ");
        System.out.println("Output FD = " + oracleSSLSocketImpl.getOutputFD().toString());
        System.out.println("Input FD = " + oracleSSLSocketImpl.getInputFD().toString());
        System.out.println("Timeout = " + oracleSSLSocketImpl.getSoTimeout());
        System.out.println("Increasing the timeout by 1000");
        oracleSSLSocketImpl.setSoTimeout(oracleSSLSocketImpl.getSoTimeout() + 1000);
        System.out.println("New Timeout = " + oracleSSLSocketImpl.getSoTimeout());
        System.out.println("Need Cliet Auth? = " + oracleSSLSocketImpl.getNeedClientAuth());
        System.out.println("Client Mode = " + oracleSSLSocketImpl.getUseClientMode());
        System.out.println("Enable Session Creation " + oracleSSLSocketImpl.getEnableSessionCreation());
        System.out.println("Default Cipher Suites: ");
        String[] stringArray = oracleSSLSocketImpl.getDefaultCipherSuites();
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(stringArray[n]);
            ++n;
        }
        System.out.println("Enabled Cipher Suites: ");
        stringArray = oracleSSLSocketImpl.getEnabledCipherSuites();
        int n2 = 0;
        while (n2 < stringArray.length) {
            System.out.println(stringArray[n2]);
            ++n2;
        }
        System.out.println("There are " + oracleSSLSocketImpl.sslInputStreamAvailable() + " bytes for reading");
        OracleSSLSocketInputStream oracleSSLSocketInputStream = (OracleSSLSocketInputStream)oracleSSLSocketImpl.getInputStream();
        OracleSSLSocketOutputStream oracleSSLSocketOutputStream = (OracleSSLSocketOutputStream)oracleSSLSocketImpl.getOutputStream();
        System.out.println("There are " + oracleSSLSocketInputStream.available() + " bytes for reading");
        byte[] byArray = new byte[10];
        oracleSSLSocketImpl.startHandshake();
        SSLSocTest.exchangeData(oracleSSLSocketImpl);
        oracleSSLSocketImpl.close();
        System.out.println("Read " + oracleSSLSocketInputStream.read());
        System.out.println("Read " + oracleSSLSocketInputStream.read(byArray) + " bytes");
        System.out.println("There are " + oracleSSLSocketInputStream.available() + " bytes available");
        oracleSSLSocketInputStream.close();
        try {
            oracleSSLSocketOutputStream.write(102);
        }
        catch (IOException iOException) {}
        oracleSSLSocketOutputStream.close();
        oracleSSLSocketImpl.close();
        oracleSSLSocketImpl.close();
    }

    public static void sslSessionTest() {
        try {
            SSLSocket sSLSocket = (SSLSocket)m_sslSocFactory.createSocket(m_hostName, m_portNum);
            sSLSocket.startHandshake();
            OracleSSLSession oracleSSLSession = (OracleSSLSession)sSLSocket.getSession();
            System.out.println("Negotiated Cipher Suite: " + oracleSSLSession.getCipherSuite());
            System.out.println("Negotiated Protocol Version: " + oracleSSLSession.getNegotiatedProtocolVersion());
            System.out.println("getPeerCertificateChain(): ");
            X509Certificate[] x509CertificateArray = oracleSSLSession.getPeerCertificateChain();
            int n = 0;
            while (n < x509CertificateArray.length) {
                System.out.println("---------------------------");
                System.out.println(x509CertificateArray[n].toString());
                x509CertificateArray[n].checkValidity();
                ++n;
            }
            System.out.println("getPeerRawCertificateChain():");
            byte[][] byArray = oracleSSLSession.getPeerRawCertificateChain();
            int n2 = 0;
            while (n2 < byArray.length) {
                System.out.println("---------------------------");
                System.out.println(new X509CertificateImpl(byArray[n2], 0, byArray[n2].length).toString());
                ++n2;
            }
            System.out.println("Identifier Assigned to this Session: " + oracleSSLSession.getId());
            System.out.println("getSessionContext: " + oracleSSLSession.getSessionContext());
            System.out.println("getCreationTime: " + oracleSSLSession.getCreationTime());
            System.out.println("getLastAccessedTime: " + oracleSSLSession.getLastAccessedTime());
            System.out.println("getPeerHost: " + oracleSSLSession.getPeerHost());
            System.out.println("Object Bound: " + oracleSSLSession.getValue("Not Implemented"));
            System.out.println("Names of Bound Objects: " + oracleSSLSession.getValueNames());
            SSLSocTest.exchangeData(sSLSocket);
            sSLSocket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public static void walletCreationTest(boolean bl) throws IOException {
        String string;
        OracleSSLCredential oracleSSLCredential = new OracleSSLCredential();
        TxtWalletReader txtWalletReader = new TxtWalletReader(m_certdb, m_walletPassword);
        JWalletPersona jWalletPersona = txtWalletReader.getPersonaByIndex(0);
        int n = jWalletPersona.getTrustedCertCount();
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        System.out.println("Testing error handling in OracleSSLCredential");
        try {
            oracleSSLCredential.addTrustedCert("");
            System.out.println("ERROR 1: Adding empty trusted cert suceeded");
        }
        catch (Exception exception) {}
        try {
            oracleSSLCredential.addTrustedCert("-----BEGIN CERTIFICATE----------END CERTIFICATE-----");
            System.out.println("ERROR 2: Adding empty trusted cert suceeded");
        }
        catch (Exception exception) {}
        try {
            oracleSSLCredential.addTrustedCert("-----BEGIN CERTIFICATE----------END CERTIFICATE---");
            System.out.println("ERROR 3: Adding negative length trusted cert suceeded");
        }
        catch (Exception exception) {}
        try {
            oracleSSLCredential.setPrivateKey("", "");
            System.out.println("ERROR 1: Adding empty private key suceeded");
        }
        catch (Exception exception) {}
        try {
            oracleSSLCredential.setPrivateKey("-----BEGIN ENCRYPTED PRIVATE KEY----------END ENCRYPTED PRIVATE KEY-----", "");
            System.out.println("ERROR 2: Adding empty private key suceeded");
        }
        catch (Exception exception) {}
        try {
            oracleSSLCredential.addCertChain("");
            System.out.println("ERROR 1: Adding empty credemtial suceeded");
        }
        catch (Exception exception) {}
        try {
            oracleSSLCredential.addCertChain("-----BEGIN CERTIFICATE----------END CERTIFICATE-----");
            System.out.println("ERROR 2: Adding empty cert chain suceeded");
        }
        catch (Exception exception) {}
        try {
            oracleSSLCredential.getCertChainCert(0);
            System.out.println("ERROR: Getting chain with index out of bounds succeded");
        }
        catch (Exception exception) {}
        int n2 = 0;
        while (n2 < n) {
            byArray = jWalletPersona.getTrustedCertByIndex(n2).getCertData();
            string = bl ? "-----BEGIN CERTIFICATE-----\n" + SSLSocTest.encodeData(byArray) + "\n-----END CERTIFICATE-----" : String.valueOf(SSLSocTest.encodeData(byArray)) + "\n";
            System.out.println(string);
            System.out.println("------------------");
            oracleSSLCredential.addTrustedCert(string);
            ++n2;
        }
        int n3 = jWalletPersona.getCertChainCount();
        byte[] byArray2 = null;
        int n4 = n3;
        while (n4 > 0) {
            byArray2 = jWalletPersona.getCertChainByIndex(n4 - 1).getCertData();
            string = bl ? "-----BEGIN CERTIFICATE-----\n" + SSLSocTest.encodeData(byArray2) + "\n-----END CERTIFICATE-----" : String.valueOf(SSLSocTest.encodeData(byArray2)) + "\n";
            System.out.println(string);
            System.out.println("------------------");
            oracleSSLCredential.addCertChain(string);
            --n4;
        }
        JWalletPvtKey jWalletPvtKey = jWalletPersona.getPrivateKey();
        byte[] byArray3 = jWalletPvtKey.getPvtKeyData();
        if (byArray3 != null) {
            string = bl ? "-----BEGIN ENCRYPTED PRIVATE KEY-----\n" + SSLSocTest.encodeData(byArray3) + "\n-----END ENCRYPTED PRIVATE KEY-----" : String.valueOf(SSLSocTest.encodeData(byArray3)) + "\n";
            System.out.println(string);
            System.out.println("------------------");
            oracleSSLCredential.setPrivateKey(string, m_walletPassword);
        }
        System.out.println("Credentials Created " + oracleSSLCredential.toString());
        System.out.println("Resetting the credentials in sslSocFactory");
        m_sslSocFactory.setSSLCredentials(oracleSSLCredential);
    }
}

