/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.ssl;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import oracle.security.ssl.OracleSSLCredential;
import oracle.security.ssl.OracleSSLServerSocketFactory;

public class SSLServerSocketTest
extends Thread {
    private SSLSocket theConnection;
    private static File docroot;
    private static String indexfile;
    public static String eas18Cert;
    public static String eas18PvtKey;
    public static String easQACA;

    static {
        indexfile = "index.html";
        eas18Cert = "MIICRTCCAa6gAwIBAgICApUwDQYJKoZIhvcNAQEEBQAwazELMAkGA1UEBhMCVVMxDzANBgNVBAoTBk9yYWNsZTEoMCYGA1UECxMfRW50ZXJwcmlzZSBBcHBsaWNhdGlvbiBTZXJ2aWNlczEhMB8GA1UEAxMYRUFTUUEgQ2VydGlmaWNhdGUgU2VydmVyMB4XDTk5MTAxODIwNDk1NloXDTk5MTExNzIwNDk1NlowcTELMAkGA1UEBhMCVVMxEzARBgNVBAgTCkNhbGlmb3JuaWExEDAOBgNVBAcTB0JlbG1vbnQxFTATBgNVBAoTDE9yYWNsZSBDb3JwLjERMA8GA1UECxMIU2VjdXJpdHkxETAPBgNVBAMTCEVKQiBUZXN0MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAMmzQ1B/qtShCFHOrCSAZJHZFQeA4qpR3mRP6Kfjc5JWUQobVcCMc7JomRGtX4ir8sAWBB10fKpJL5R4SxzI9IcCAwEAAaM2MDQwEQYJYIZIAYb4QgEBBAQDAgDAMB8GA1UdIwQYMBaAFAwh8BLiXyBVw2u7bmDTvGzsNRGMMA0GCSqGSIb3DQEBBAUAA4GBAM5sZDR8Tyl3rIuPMwuzEiv8xUSr3+Qmr8ZVlaGJ9WAvNxDxY2JdzXcGZ6wMpJC9eYwOgPqtbKn9O+ynZXiKwzDB2CBVJs4reay2ldOW4diY4984sPJNWXOHkMsCHDG0iPpdGrXx7fWEftTolmqdSOHM/IgLA93vjur4UqD5j2Za";
        eas18PvtKey = "MIIBYDAaBgkqhkiG9w0BBQMwDQQISucTNuRL+b8CAQUEggFAg9caoLYHje06Owbz6Zuz0ebxbh9TdfkKPpC7WJ4XOfayWuRLRm6GBwW0HqSq47Wvs4gM+5iyuSx54PHjpkNxDlaOMTDdMQQRUwnrl3oWHJ+Lly8BLLKfiwIh0t70Ue23LqpdtOFAH9cStbE9dGWWxsxeN3AUqH6qAyPXkdXgsMewHJpW63l+k6PS8CXDqpyky9EXSmg+gPJcc96Pr0ancoWSFVkZTZdZvezYhXtS3QRwU1lVXD7Bq5FaNBARYXoo8kPAojGsXH+Pt3kCiJdTo9TLOdf0h2Wt7a3LmKApxHNw5Z6SPz4rZJlpGVFddF+iVj/UiwYWX6h/PX4YFFdTOP8htLqYWOA0kvohvT2nROM2psB8Hai5t1u9T/LP35YD+2CnVtMKPLS8lDSZsLi5nM2V56k0Ww8yDzH4eHYdCmI=";
        easQACA = "MIICjjCCAfegAwIBAgIBATANBgkqhkiG9w0BAQQFADBrMQswCQYDVQQGEwJVUzEPMA0GA1UEChMGT3JhY2xlMSgwJgYDVQQLEx9FbnRlcnByaXNlIEFwcGxpY2F0aW9uIFNlcnZpY2VzMSEwHwYDVQQDExhFQVNRQSBDZXJ0aWZpY2F0ZSBTZXJ2ZXIwHhcNOTgwNDE1MDA0NTQ1WhcNMDAwNDE0MDA0NTQ1WjBrMQswCQYDVQQGEwJVUzEPMA0GA1UEChMGT3JhY2xlMSgwJgYDVQQLEx9FbnRlcnByaXNlIEFwcGxpY2F0aW9uIFNlcnZpY2VzMSEwHwYDVQQDExhFQVNRQSBDZXJ0aWZpY2F0ZSBTZXJ2ZXIwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBANi0bMVLgXMLZZKPg89YhtZ23vtbq2DV7ofReEqvki4Xz9Vvua24YAi3qduCwfLWpznjSca/kNC9inU417vSq2ckpmtrfYgBI+4BbOM9/Moc8491hOmJXyQLJ+Gbhhijp/i/AZ6S/UEApwSJdNV40EIat1zSiuiGPtIa7sscekBTAgMBAAGjQjBAMB0GA1UdDgQWBBQMIfAS4l8gVcNru25g07xs7DURjDAfBgNVHSMEGDAWgBQMIfAS4l8gVcNru25g07xs7DURjDANBgkqhkiG9w0BAQQFAAOBgQDJL7u3HvNdtbeeA/MoMNoFet3Rat89/Im1lukJRZ5MMm+a45c9LdwXAfbPr2PgNvwEUH6g4eVRVBwi2Nel+yp8bmui8MC50g/5uVB72g/5wGbzvt8VxSeQ84muzi91dhZlwVEt6WV8Qkc7m7+R5Y2h56gcL87gxJx6cwoUBjjqQg==";
    }

    public SSLServerSocketTest(SSLSocket sSLSocket) {
        this.theConnection = sSLSocket;
    }

    public String guessContentTypeFromName(String string) {
        if (string.endsWith(".html") || string.endsWith(".htm")) {
            return "text/html";
        }
        if (string.endsWith(".txt") || string.endsWith(".java")) {
            return "text/plain";
        }
        if (string.endsWith(".gif")) {
            return "image/gif";
        }
        if (string.endsWith(".class")) {
            return "application/octet-stream";
        }
        if (string.endsWith(".jpg") || string.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        return "text/plain";
    }

    public static void main(String[] stringArray) {
        int n;
        Serializable serializable;
        int n2;
        SSLServerSocket sSLServerSocket = null;
        String string = System.getProperty("CERTDBFILE");
        String string2 = System.getProperty("CERTDBPASS", "welcome1");
        String string3 = System.getProperty("NUMOFCONNS");
        String string4 = System.getProperty("CLIENTAUTH");
        if (string3 == null) {
            n2 = 100;
        } else {
            serializable = new Integer(string3);
            n2 = (Integer)serializable;
        }
        try {
            docroot = new File(stringArray[0]);
        }
        catch (Exception exception) {
            docroot = new File(".");
        }
        try {
            n = Integer.parseInt(stringArray[1]);
            if (n == 0 || n > 65535) {
                n = 443;
            }
        }
        catch (Exception exception) {
            n = 443;
        }
        try {
            serializable = System.getProperties();
            ((Hashtable)serializable).put("SSLServerSocketFactoryImplClass", "oracle.security.ssl.OracleSSLServerSocketFactoryImpl");
            OracleSSLServerSocketFactory oracleSSLServerSocketFactory = (OracleSSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            oracleSSLServerSocketFactory.setSSLProtocolVersion(100);
            OracleSSLCredential oracleSSLCredential = new OracleSSLCredential();
            if (string == null) {
                System.out.println("certdb is null");
            } else {
                oracleSSLCredential.setWallet(string, string2);
            }
            oracleSSLServerSocketFactory.setSSLCredentials(oracleSSLCredential);
            sSLServerSocket = (SSLServerSocket)oracleSSLServerSocketFactory.createServerSocket(n);
            String[] stringArray2 = sSLServerSocket.getSupportedCipherSuites();
            System.out.println("Printing available ciphers...");
            int n3 = 0;
            while (n3 < stringArray2.length) {
                System.out.println(stringArray2[n3]);
                ++n3;
            }
            sSLServerSocket.setEnabledCipherSuites(stringArray2);
            if (string4 != null && string4.equals("Y")) {
                sSLServerSocket.setNeedClientAuth(true);
            }
            System.out.println("Waiting for a new client...");
            while (n2 > 0) {
                --n2;
                SSLServerSocket sSLServerSocket2 = sSLServerSocket;
                synchronized (sSLServerSocket2) {
                    X509Certificate[] x509CertificateArray;
                    Socket socket = null;
                    try {
                        socket = sSLServerSocket.accept();
                    }
                    catch (Exception exception) {
                        System.out.println(" Exception: " + exception.toString());
                        Object var14_15 = null;
                        continue;
                    }
                    if (sSLServerSocket.getNeedClientAuth()) {
                        System.out.println("verify peers");
                        x509CertificateArray = ((SSLSocket)socket).getSession().getPeerCertificateChain();
                        if (x509CertificateArray != null) {
                            SSLServerSocketTest.verifyPeerCertChain(x509CertificateArray);
                        } else {
                            System.out.println("Failed to get peerCerts");
                        }
                    }
                    x509CertificateArray = new SSLServerSocketTest((SSLSocket)socket);
                    x509CertificateArray.start();
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Server aborted prematurely");
            iOException.printStackTrace();
        }
    }

    public void run() {
        String string = "";
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(this.theConnection.getOutputStream());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.theConnection.getInputStream()));
            String string2 = bufferedReader.readLine();
            System.out.println("Client[" + this.theConnection.getInetAddress().getHostAddress() + "] Request: " + string2);
            if (string2 == null || string2.length() <= 0) {
                System.out.println("No valid request from client");
                dataOutputStream.close();
                bufferedReader.close();
                this.theConnection.close();
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("GET")) {
                String string4 = stringTokenizer.nextToken();
                if (string4.endsWith("/")) {
                    string4 = String.valueOf(string4) + indexfile;
                }
                String string5 = this.guessContentTypeFromName(string4);
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                }
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.trim().equals("")) break;
                }
                try {
                    File file = new File(docroot, string4.substring(1, string4.length()));
                    FileInputStream fileInputStream = new FileInputStream(file);
                    byte[] byArray = new byte[(int)file.length()];
                    int n = fileInputStream.read(byArray);
                    fileInputStream.close();
                    if (string.startsWith("HTTP/")) {
                        Date date = new Date();
                        dataOutputStream.writeBytes("HTTP/1.0 200 OK\r\n");
                        dataOutputStream.writeBytes("Content-type: " + string5 + "\r\n\r\n");
                    }
                    dataOutputStream.write(byArray, 0, n);
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    if (string.startsWith("HTTP/")) {
                        dataOutputStream.writeBytes("HTTP/1.0 404 File Not Found\r\n");
                        Date date = new Date();
                        dataOutputStream.writeBytes("Date: " + date + "\r\n");
                        dataOutputStream.writeBytes("Server: Java Web Server 1.0\r\n");
                        dataOutputStream.writeBytes("Content-type: text/html\r\n\r\n");
                    }
                    dataOutputStream.writeBytes("<HTML><HEAD><TITLE>File Not Found</TITLE></HEAD>\r\n");
                    dataOutputStream.writeBytes("<BODY><H1>HTTP Error 404: File Not Found <BR>" + string4 + "</H1></BODY></HTML>\r\n");
                    dataOutputStream.close();
                }
            } else if (string3.equals("POST")) {
                Object object;
                Object object2;
                String string6 = stringTokenizer.nextToken();
                String string7 = this.guessContentTypeFromName(string6);
                if (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    System.out.println("version " + string);
                }
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (!string2.trim().equals("")) continue;
                    string2 = bufferedReader.readLine();
                    object2 = new StringTokenizer(string2, "&");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken();
                        System.out.println("Token " + (String)object);
                    }
                    break block9;
                }
                bufferedReader.close();
                try {
                    File file = new File(docroot, string6.substring(1, string6.length()));
                    object2 = new FileInputStream(file);
                    object = new byte[(int)file.length()];
                    ((FileInputStream)object2).read((byte[])object);
                    ((FileInputStream)object2).close();
                    if (string.startsWith("HTTP/")) {
                        Date date = new Date();
                        dataOutputStream.writeBytes("HTTP/1.0 200 OK\r\n");
                        dataOutputStream.writeBytes("Content-type: " + string7 + "\r\n\r\n");
                    }
                    dataOutputStream.write((byte[])object);
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    if (string.startsWith("HTTP/")) {
                        dataOutputStream.writeBytes("HTTP/1.0 404 File Not Found\r\n");
                        object2 = new Date();
                        dataOutputStream.writeBytes("Date: " + object2 + "\r\n");
                        dataOutputStream.writeBytes("Server: Java Web Server 1.0\r\n");
                        dataOutputStream.writeBytes("Content-type: text/html\r\n\r\n");
                    }
                    dataOutputStream.writeBytes("<HTML><HEAD><TITLE>File Not Found</TITLE></HEAD>\r\n");
                    dataOutputStream.writeBytes("<BODY><H1>HTTP Error 404: File Not Found <BR>" + string6 + "</H1></BODY></HTML>\r\n");
                    dataOutputStream.close();
                }
            } else {
                if (string.startsWith("HTTP/")) {
                    dataOutputStream.writeBytes("HTTP/1.0 501 Not Implemented\r\n");
                    Date date = new Date();
                    dataOutputStream.writeBytes("Date: " + date + "\r\n");
                    dataOutputStream.writeBytes("Server: Java Secure Web Server 1.0\r\n");
                    dataOutputStream.writeBytes("Content-type: text/html\r\n\r\n");
                }
                dataOutputStream.writeBytes("<HTML><HEAD><TITLE>Not Implemented</TITLE></HEAD>\r\n");
                dataOutputStream.writeBytes("<BODY><H1>HTTP Error 501: Not Implemented</H1></BODY></HTML>\r\n");
                dataOutputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            this.theConnection.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void verifyPeerCertChain(X509Certificate[] x509CertificateArray) {
        int n = 0;
        while (n < x509CertificateArray.length) {
            System.out.println("---------------------------");
            System.out.println("PeerCert [" + n + "] Information:");
            System.out.println("-Subjec: " + x509CertificateArray[n].getSubjectDN().getName());
            System.out.println("-Issuer: " + x509CertificateArray[n].getIssuerDN().getName());
            System.out.println("-Version: " + x509CertificateArray[n].getVersion());
            System.out.println("-StartTime: " + x509CertificateArray[n].getNotBefore().toString());
            System.out.println("-EndTime: " + x509CertificateArray[n].getNotAfter().toString());
            System.out.println("-SigAlgorithm: " + x509CertificateArray[n].getSigAlgName());
            System.out.println("-SerialNumber: " + x509CertificateArray[n].getSerialNumber());
            try {
                x509CertificateArray[n].checkValidity();
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
            ++n;
        }
    }
}

