/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.ssl;

import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import oracle.security.cert.X509CertificateImpl;
import oracle.security.ssl.OracleSSLCredential;
import oracle.security.ssl.OracleSSLDebug;
import oracle.security.ssl.OracleX509TrustManagerInterface;

class OracleX509TrustManager
implements OracleX509TrustManagerInterface {
    private X509Certificate[] m_trustedX509CertA;

    OracleX509TrustManager(OracleSSLCredential oracleSSLCredential) {
        this.m_trustedX509CertA = new X509Certificate[oracleSSLCredential.getTrustedCertCount()];
        int n = 0;
        while (n < this.m_trustedX509CertA.length) {
            try {
                this.m_trustedX509CertA[n] = new X509CertificateImpl(oracleSSLCredential.getTrustedCert(n));
            }
            catch (CertificateException certificateException) {
                OracleSSLDebug.debug("Certificate #" + n + " is invalid");
            }
            ++n;
        }
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray) throws CertificateException, CertificateExpiredException, CertificateNotYetValidException {
        boolean bl = false;
        if (x509CertificateArray == null) {
            throw new CertificateException("Peer sent no certificates");
        }
        int n = 0;
        while (n < x509CertificateArray.length && !bl) {
            OracleSSLDebug.debug("Peer Cert[" + n + "] = " + x509CertificateArray[n]);
            int n2 = 0;
            while (n2 < this.m_trustedX509CertA.length && !bl) {
                if (this.m_trustedX509CertA[n2].equals(x509CertificateArray[n])) {
                    bl = true;
                }
                ++n2;
            }
            ++n;
        }
        if (!bl) {
            OracleSSLDebug.debug("Peer is not trusted");
            throw new CertificateException("Peer is not trusted");
        }
        OracleSSLDebug.debug("Checking Validity of Certificates");
        x509CertificateArray[0].checkValidity();
        OracleSSLDebug.debug("Certificate Chain OK");
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray) throws CertificateException, CertificateExpiredException, CertificateNotYetValidException {
        this.checkClientTrusted(x509CertificateArray);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return (X509Certificate[])this.m_trustedX509CertA.clone();
    }
}

