/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import oracle.security.ssl.OracleSSLDebug;
import oracle.security.ssl.OracleSSLSocketImpl;

public final class OracleSSLSocketTable {
    private static Hashtable table = new Hashtable();
    private static int _fd = 0;

    public OracleSSLSocketTable() {
        OracleSSLDebug.debug("instantiate the hashtable");
    }

    public synchronized int getFd() {
        return ++_fd;
    }

    public static OracleSSLSocketImpl getSocketInstance(int n) {
        return (OracleSSLSocketImpl)table.get(new Integer(n));
    }

    public static int read(int n, byte[] byArray, int n2, int n3) throws IOException {
        OracleSSLDebug.debug("SocketTable read Enter");
        OracleSSLSocketImpl oracleSSLSocketImpl = OracleSSLSocketTable.getSocketInstance(n);
        if (oracleSSLSocketImpl == null) {
            throw new IOException("In OracleSSLSocketTable - read: fd is in invalid");
        }
        InputStream inputStream = oracleSSLSocketImpl.getRawInputStream();
        int n4 = inputStream.read(byArray, n2, n3);
        OracleSSLDebug.debug("SocketTable read: " + n4 + " bytes");
        return n4;
    }

    public void removeSocketInstance(int n) {
        table.remove(new Integer(n));
    }

    public void setSocketInstance(int n, OracleSSLSocketImpl oracleSSLSocketImpl) {
        table.put(new Integer(n), oracleSSLSocketImpl);
    }

    public static void write(int n, byte[] byArray, int n2, int n3) throws IOException {
        OracleSSLDebug.debug("SocketTable write Enter fdin " + n);
        OracleSSLSocketImpl oracleSSLSocketImpl = OracleSSLSocketTable.getSocketInstance(n);
        if (oracleSSLSocketImpl == null) {
            throw new IOException("In OracleSSLSocketTable - write: fd is in invalid");
        }
        OutputStream outputStream = oracleSSLSocketImpl.getRawOutputStream();
        OracleSSLDebug.debug("SocketTable write offset " + n2 + " length " + n3);
        try {
            outputStream.write(byArray, n2, n3);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        OracleSSLDebug.debug("SocketTable write: " + n3 + " bytes");
    }
}

