/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.ssl;

import java.io.FileOutputStream;
import java.io.IOException;
import oracle.security.ssl.OracleSSLDebug;
import oracle.security.ssl.OracleSSLSocketImpl;

class OracleSSLSocketOutputStream
extends FileOutputStream {
    private OracleSSLSocketImpl _impl;
    private byte[] temp = new byte[1];

    OracleSSLSocketOutputStream(OracleSSLSocketImpl oracleSSLSocketImpl) throws IOException {
        super(oracleSSLSocketImpl.getOutputFD());
        this._impl = oracleSSLSocketImpl;
    }

    public void close() throws IOException {
        this._impl.OutputStreamClose();
    }

    protected void finalize() {
    }

    private native int sslOutputStreamWrite(byte[] var1, int var2, int var3, byte[] var4, OracleSSLSocketImpl var5) throws IOException;

    public void write(int n) throws IOException {
        this.temp[0] = (byte)n;
        this.write(this.temp, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        OracleSSLDebug.debug("write: " + n2 + " bytes" + byArray.toString());
        byte[] byArray2 = this._impl.acquireSSLContext();
        if (byArray2 == null) {
            throw new IOException("Attempt to write to a closed output stream");
        }
        try {
            this.sslOutputStreamWrite(byArray, n, n2, byArray2, this._impl);
        }
        finally {
            Object var6_5 = null;
            this._impl.releaseSSLContext();
        }
    }
}

