/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.ssl;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import oracle.security.ssl.OracleSSLDebug;
import oracle.security.ssl.OracleSSLSocketImpl;

class OracleSSLSocketInputStream
extends FileInputStream {
    private boolean eof;
    private byte[] temp = new byte[1];
    private OracleSSLSocketImpl _impl = null;

    OracleSSLSocketInputStream(OracleSSLSocketImpl oracleSSLSocketImpl) throws IOException {
        super(oracleSSLSocketImpl.getInputFD());
        this._impl = oracleSSLSocketImpl;
    }

    public int available() throws IOException {
        byte[] byArray = this._impl.acquireSSLContext();
        if (byArray == null) {
            return 0;
        }
        try {
            int n = this._impl.sslInputStreamAvailable();
            Object var4_3 = null;
            this._impl.releaseSSLContext();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._impl.releaseSSLContext();
            throw throwable;
        }
    }

    public void close() throws IOException {
        this._impl.InputStreamClose();
    }

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        int n = this.read(this.temp, 0, 1);
        if (n <= 0) {
            return -1;
        }
        return this.temp[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.eof) {
            return -1;
        }
        OracleSSLDebug.debug("read: " + n2 + " bytes");
        byte[] byArray2 = this._impl.acquireSSLContext();
        if (byArray2 == null) {
            throw new IOException("Attempting to read from a closed stream");
        }
        try {
            try {
                n3 = this.sslInputStreamRead(byArray, n, n2, byArray2, this._impl);
                OracleSSLDebug.debug("Got " + n3 + " bytes" + byArray.toString());
            }
            catch (EOFException eOFException) {
                this.eof = true;
            }
            Object var7_6 = null;
            this._impl.releaseSSLContext();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this._impl.releaseSSLContext();
            throw throwable;
        }
        if (this.eof) {
            return -1;
        }
        return n3;
    }

    protected native int sslInputStreamRead(byte[] var1, int var2, int var3, byte[] var4, OracleSSLSocketImpl var5) throws IOException;
}

