/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.ssl;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import oracle.security.cert.X509CertificateImpl;
import oracle.security.ssl.OracleSSLCipherSuite;
import oracle.security.ssl.OracleSSLCredential;
import oracle.security.ssl.OracleSSLDebug;
import oracle.security.ssl.OracleSSLSession;
import oracle.security.ssl.OracleSSLSocket;
import oracle.security.ssl.OracleSSLSocketFactoryImpl;
import oracle.security.ssl.OracleSSLSocketInputStream;
import oracle.security.ssl.OracleSSLSocketOutputStream;
import oracle.security.ssl.OracleSSLSocketTable;
import oracle.security.ssl.OracleX509TrustManagerInterface;

class OracleSSLSocketImpl
extends SSLSocket
implements OracleSSLSocket {
    private OracleSSLSocketFactoryImpl m_factoryImpl = null;
    private OracleSSLSession m_session = new OracleSSLSession();
    protected Vector m_listeners = new Vector();
    private Socket m_socket = null;
    private InputStream m_istream = null;
    private OutputStream m_ostream = null;
    private boolean m_isClientAuthReqd = false;
    protected boolean m_clientmode = true;
    private boolean m_isSocketOpenedByUs = true;
    private int fd = -1;
    private OracleSSLSocketInputStream sslInStream = null;
    private OracleSSLSocketOutputStream sslOutStream = null;
    private OracleX509TrustManagerInterface[] m_trustManagerA = null;
    private OracleSSLSocketTable _table = new OracleSSLSocketTable();
    private boolean isClosed = false;
    private int iSSLContextCount = 0;
    final int SSLBadParameterErr = -6981;
    final int X509CertChainInvalidErr = -6986;
    final int X509CertExpiredErr = -6985;
    final int SSLNoErr = 0;
    final int SSLUnknownErr = -6997;
    protected byte[][] trustedCert_ctx;
    protected byte[][] certChain_ctx;
    protected byte[] ssl_context;

    static {
        if (System.getProperty("oracle.server.version") == null) {
            System.loadLibrary("njssl9");
        }
    }

    OracleSSLSocketImpl() throws IOException, UnknownHostException {
        this.m_socket = this;
        this.fd = this._table.getFd();
        this._table.setSocketInstance(this.fd, this);
    }

    OracleSSLSocketImpl(String string, int n) throws IOException {
        super(string, n);
        this.fd = this._table.getFd();
        this.initSSLContext(InetAddress.getByName(string).getAddress(), n, this);
        this._table.setSocketInstance(this.fd, this);
        this.m_session.setSSLSessionContext(this.ssl_context);
        this.m_socket = this;
    }

    protected OracleSSLSocketImpl(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        super(string, n, inetAddress, n2);
        this.fd = this._table.getFd();
        this.initSSLContext(InetAddress.getByName(string).getAddress(), n, this);
        this._table.setSocketInstance(this.fd, this);
        this.m_session.setSSLSessionContext(this.ssl_context);
        this.m_socket = this;
    }

    OracleSSLSocketImpl(InetAddress inetAddress, int n) throws IOException {
        super(inetAddress, n);
        this.fd = this._table.getFd();
        this.initSSLContext(inetAddress.getAddress(), n, this);
        this._table.setSocketInstance(this.fd, this);
        this.m_session.setSSLSessionContext(this.ssl_context);
        this.m_socket = this;
    }

    protected OracleSSLSocketImpl(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException, UnknownHostException {
        super(inetAddress, n, inetAddress2, n2);
        this.fd = this._table.getFd();
        this.initSSLContext(inetAddress.getAddress(), n, this);
        this._table.setSocketInstance(this.fd, this);
        this.m_session.setSSLSessionContext(this.ssl_context);
        this.m_socket = this;
    }

    OracleSSLSocketImpl(Socket socket) throws IOException, UnknownHostException {
        this.m_socket = socket;
        this.m_isSocketOpenedByUs = false;
        this.fd = this._table.getFd();
        if (this.m_socket != null) {
            this.initSSLContext(this.m_socket.getInetAddress().getAddress(), this.m_socket.getPort(), this);
        }
        this._table.setSocketInstance(this.fd, this);
        this.m_session.setSSLSessionContext(this.ssl_context);
    }

    protected OracleSSLSocketImpl(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        this.m_socket = socket;
        this.m_isSocketOpenedByUs = bl;
        this.fd = this._table.getFd();
        this.initSSLContext(InetAddress.getByName(string).getAddress(), n, this);
        this._table.setSocketInstance(this.fd, this);
        this.m_session.setSSLSessionContext(this.ssl_context);
    }

    public void InputStreamClose() throws IOException {
        if (this.m_istream == null) {
            this.m_istream = this.m_socket == this ? super.getInputStream() : this.m_socket.getInputStream();
        }
        this.m_istream.close();
    }

    public void OutputStreamClose() throws IOException {
        if (this.m_ostream == null) {
            this.m_ostream = this.m_socket == this ? super.getOutputStream() : this.m_socket.getOutputStream();
        }
        this.m_ostream.close();
    }

    final synchronized byte[] acquireSSLContext() {
        if (this.isClosed || this.ssl_context == null) {
            return null;
        }
        ++this.iSSLContextCount;
        return this.ssl_context;
    }

    private native byte[][] addCertList(byte[] var1, byte[][] var2, byte[] var3);

    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.m_listeners.addElement(handshakeCompletedListener);
    }

    int checkTrustedCertChain(byte[][] byArray) {
        try {
            OracleSSLDebug.debug("Building cert chain from " + byArray.length + " certs");
            X509Certificate[] x509CertificateArray = new X509Certificate[byArray.length];
            int n = byArray.length - 1;
            int n2 = 0;
            while (n2 < byArray.length) {
                try {
                    x509CertificateArray[n] = new X509CertificateImpl(byArray[n2]);
                    OracleSSLDebug.debug("cert[" + n + "] is " + x509CertificateArray[n]);
                }
                catch (CertificateException certificateException) {
                    OracleSSLDebug.debug("Certificate #" + n2 + " is invalid");
                    return -6981;
                }
                --n;
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.m_trustManagerA.length) {
                if (this.m_trustManagerA[n3] instanceof OracleX509TrustManagerInterface) {
                    try {
                        if (this.getUseClientMode()) {
                            this.m_trustManagerA[n3].checkClientTrusted(x509CertificateArray);
                        }
                        OracleSSLDebug.debug("checkServerTrusted called");
                        this.m_trustManagerA[n3].checkServerTrusted(x509CertificateArray);
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        OracleSSLDebug.debug("Caught " + certificateExpiredException);
                        return -6985;
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        OracleSSLDebug.debug("Caught " + certificateNotYetValidException);
                        return -6985;
                    }
                    catch (CertificateException certificateException) {
                        OracleSSLDebug.debug("Caught " + certificateException);
                        return -6986;
                    }
                } else {
                    OracleSSLDebug.debug("TrustManager #" + n3 + " is of an unsupported type");
                    return -6981;
                }
                ++n3;
            }
        }
        catch (Throwable throwable) {
            OracleSSLDebug.debug("Caught " + throwable);
            return -6997;
        }
        OracleSSLDebug.debug("Certificate chain is OK");
        return 0;
    }

    public synchronized void close() throws IOException {
        if (this.fd >= 0) {
            byte[] byArray = this.acquireSSLContext();
            this.isClosed = true;
            OracleSSLDebug.debug("SSLSocketImpl close Thread:" + Thread.currentThread());
            if (this.m_isSocketOpenedByUs) {
                if (this.m_socket == this) {
                    super.close();
                } else {
                    this.m_socket.close();
                }
            }
            if (OracleSSLSocketTable.getSocketInstance(this.fd) == this) {
                this._table.removeSocketInstance(this.fd);
                OracleSSLDebug.debug("In close removing fd " + this.fd + "Thread " + Thread.currentThread());
                this.fd = -1;
            }
            if (byArray != null) {
                this.releaseSSLContext();
            }
        }
    }

    static String[] enabledCipherSuites(String[] stringArray) throws IllegalArgumentException {
        String[] stringArray2 = OracleSSLCipherSuite.getSupportedCipherSuites();
        String[] stringArray3 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < stringArray2.length && !stringArray[n].equals(stringArray2[n2])) {
                ++n2;
            }
            if (n2 == stringArray2.length) {
                throw new IllegalArgumentException(stringArray[n]);
            }
            stringArray3[n] = stringArray[n];
            ++n;
        }
        return stringArray3;
    }

    public void finalize() throws IOException {
        this.close();
    }

    private native void freeSSLContext(byte[] var1) throws SSLException;

    public String[] getDefaultCipherSuites() {
        return OracleSSLCipherSuite.getSupportedCipherSuites();
    }

    public boolean getEnableSessionCreation() {
        return false;
    }

    public String[] getEnabledCipherSuites() {
        return this.getEnabledCipherSuites(this.ssl_context);
    }

    private native String[] getEnabledCipherSuites(byte[] var1);

    public FileDescriptor getInputFD() throws IOException {
        if (this.m_istream == null) {
            this.m_istream = this.m_socket == this ? super.getInputStream() : this.m_socket.getInputStream();
        }
        return ((FileInputStream)this.m_istream).getFD();
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.sslInStream == null) {
            this.sslInStream = new OracleSSLSocketInputStream(this);
        }
        return this.sslInStream;
    }

    public boolean getNeedClientAuth() {
        return this.m_isClientAuthReqd;
    }

    public FileDescriptor getOutputFD() throws IOException {
        if (this.m_ostream == null) {
            this.m_ostream = this.m_socket == this ? super.getOutputStream() : this.m_socket.getOutputStream();
        }
        return ((FileOutputStream)this.m_ostream).getFD();
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.sslOutStream == null) {
            this.sslOutStream = new OracleSSLSocketOutputStream(this);
        }
        return this.sslOutStream;
    }

    public InputStream getRawInputStream() throws IOException {
        if (this.m_istream == null) {
            this.m_istream = this.m_socket == this ? super.getInputStream() : this.m_socket.getInputStream();
        }
        return this.m_istream;
    }

    public OutputStream getRawOutputStream() throws IOException {
        if (this.m_ostream == null) {
            this.m_ostream = this.m_socket == this ? super.getOutputStream() : this.m_socket.getOutputStream();
        }
        return this.m_ostream;
    }

    protected synchronized byte[] getSSLContext() {
        return this.ssl_context;
    }

    public SSLSession getSession() {
        return this.m_session;
    }

    public synchronized int getSoTimeout() throws SocketException {
        if (this.m_socket == this) {
            return super.getSoTimeout();
        }
        return this.m_socket.getSoTimeout();
    }

    public String[] getSupportedCipherSuites() {
        return OracleSSLCipherSuite.getSupportedCipherSuites();
    }

    public boolean getUseClientMode() {
        return this.m_clientmode;
    }

    public void initSSLContext(byte[] byArray, int n, Object object) {
        this.initSSLContextNative(byArray, n, object, this.fd);
    }

    public native void initSSLContextNative(byte[] var1, int var2, Object var3, int var4);

    public static boolean isSSLLibDomestic() {
        return OracleSSLSocketImpl.nativeIsDomesticLib();
    }

    private static native boolean nativeIsDomesticLib();

    final synchronized void releaseSSLContext() {
        block2: {
            --this.iSSLContextCount;
            if (this.iSSLContextCount != 0 || !this.isClosed || this.ssl_context == null) break block2;
            try {
                OracleSSLDebug.debug("Deleting ssl_context");
                this.freeSSLContext(this.ssl_context);
                this.ssl_context = null;
            }
            catch (IOException iOException) {}
        }
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.m_listeners.removeElement(handshakeCompletedListener);
    }

    private native void setAuthOption(int var1) throws SSLException;

    private native void setCertificate(byte[] var1, byte[][] var2, int var3, int var4) throws SSLException;

    private native void setCheckTrustPoints(byte[] var1, boolean var2);

    private native void setCipherList(byte[] var1, byte[][] var2);

    void setDHParam() throws SSLException {
        this.setDHParam(this.ssl_context);
    }

    private native void setDHParam(byte[] var1) throws SSLException;

    public void setEnableSessionCreation(boolean bl) {
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        String[] stringArray2 = OracleSSLSocketImpl.enabledCipherSuites(stringArray);
        byte[][] byArray = new byte[stringArray2.length][64];
        int n = 0;
        while (n < stringArray2.length) {
            byArray[n] = stringArray2[n].getBytes();
            ++n;
        }
        this.setCipherList(this.ssl_context, byArray);
    }

    public void setNeedClientAuth(boolean bl) {
        this.m_isClientAuthReqd = bl;
        this.setNeedClientAuth(this.ssl_context, bl);
    }

    private native void setNeedClientAuth(byte[] var1, boolean var2);

    private native void setPrivateKey(byte[] var1, byte[] var2, String var3) throws SSLException;

    void setSSLCredentials(OracleSSLCredential oracleSSLCredential) throws SSLException {
        int n = 0;
        byte[] byArray = null;
        int n2 = oracleSSLCredential.getTrustedCertCount();
        n = 0;
        while (n < n2) {
            byArray = oracleSSLCredential.getTrustedCert(n);
            this.trustedCert_ctx = this.addCertList(this.ssl_context, this.trustedCert_ctx, byArray);
            ++n;
        }
        if (n2 > 0) {
            this.setTrustpoints(this.ssl_context, this.trustedCert_ctx);
        } else {
            this.setCheckTrustPoints(this.ssl_context, false);
            this.setDHParam();
        }
        int n3 = oracleSSLCredential.getCertChainCount();
        if (n3 > 0) {
            n = 0;
            while (n < n3) {
                byArray = oracleSSLCredential.getCertChainCert(n);
                this.certChain_ctx = this.addCertList(this.ssl_context, this.certChain_ctx, byArray);
                ++n;
            }
            int n4 = 0;
            int n5 = 1;
            if (n3 == 1) {
                n5 = 0;
            }
            this.setCertificate(this.ssl_context, this.certChain_ctx, n4, n5);
            byArray = oracleSSLCredential.getPrivateKey();
            String string = oracleSSLCredential.getPvtKeyPassword();
            this.setPrivateKey(this.ssl_context, byArray, string);
        }
    }

    void setSSLProtocolVersion(int n) {
        this.setSSLProtocolVersion(this.ssl_context, n);
    }

    public native void setSSLProtocolVersion(byte[] var1, int var2);

    public void setSSLSessionContext() {
        this.m_session.setSSLSessionContext(this.ssl_context);
    }

    void setSSLSocketFactory(OracleSSLSocketFactoryImpl oracleSSLSocketFactoryImpl) {
        this.m_factoryImpl = oracleSSLSocketFactoryImpl;
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
        if (this.m_socket == this) {
            super.setSoTimeout(n);
        } else {
            this.m_socket.setSoTimeout(n);
        }
    }

    private native void setTrustpoints(byte[] var1, byte[][] var2) throws SSLException;

    public void setUseClientMode(boolean bl) {
        if (!bl) {
            this.setUseServerMode(this.ssl_context);
            this.m_clientmode = bl;
        }
    }

    private native void setUseServerMode(byte[] var1);

    private native int sslDataAvailable(byte[] var1);

    protected int sslInputStreamAvailable() throws IOException {
        int n = 0;
        if (this.m_istream == null) {
            this.m_istream = this.m_socket == this ? super.getInputStream() : this.m_socket.getInputStream();
        }
        n = this.sslDataAvailable(this.ssl_context);
        return n += this.m_istream.available();
    }

    public void startHandshake() throws IOException {
        try {
            this.setSSLProtocolVersion(this.m_factoryImpl.getSSLProtocolVersion());
            OracleSSLCredential oracleSSLCredential = this.m_factoryImpl.getSSLCredentials();
            this.m_trustManagerA = this.m_factoryImpl.getTrustManagers();
            if (oracleSSLCredential != null) {
                this.setSSLCredentials(oracleSSLCredential);
            } else {
                this.setDHParam();
            }
            this.startHandshake(this.ssl_context);
        }
        catch (Exception exception) {
            this.close();
            throw new IOException(exception.toString());
        }
    }

    private native void startHandshake(byte[] var1) throws SSLException;
}

