/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLException;
import oracle.security.ssl.OracleHttpsSocket;
import oracle.security.ssl.OracleSSLCipherSuite;
import oracle.security.ssl.OracleSSLCredential;
import oracle.security.ssl.OracleSSLDebug;
import oracle.security.ssl.OracleSSLSocketFactory;
import oracle.security.ssl.OracleSSLSocketImpl;
import oracle.security.ssl.OracleX509TrustManager;
import oracle.security.ssl.OracleX509TrustManagerInterface;

public class OracleSSLSocketFactoryImpl
extends OracleSSLSocketFactory {
    private OracleSSLCredential m_sslCredential = null;
    private int m_sslVersion = 0;
    private static String HTTPS_PROXY_HOST_ENV_VAR = "https.proxyHost";
    private static String HTTPS_PROXY_PORT_ENV_VAR = "https.proxyPort";
    private static String HTTPS_NON_PROXY_HOSTS_ENV_VAR = "https.nonProxyHosts";
    private boolean isProxyEnabled = false;
    private String httpsProxyHost = null;
    private int httpsProxyPort = 0;
    private OracleX509TrustManagerInterface[] m_trustManagerA = null;

    public OracleSSLSocketFactoryImpl() {
        this.initProxySettings();
    }

    public Socket createSocket() throws IOException {
        OracleSSLSocketImpl oracleSSLSocketImpl = new OracleSSLSocketImpl();
        oracleSSLSocketImpl.setSSLSocketFactory(this);
        return oracleSSLSocketImpl;
    }

    public Socket createSocket(String string, int n) throws IOException {
        if (this.isProxyEnabled) {
            OracleHttpsSocket oracleHttpsSocket = new OracleHttpsSocket(this.httpsProxyHost, this.httpsProxyPort);
            this.makeProxyConnection(oracleHttpsSocket, string, n);
            oracleHttpsSocket.setSSLSocketFactory(this);
            return oracleHttpsSocket;
        }
        OracleSSLSocketImpl oracleSSLSocketImpl = new OracleSSLSocketImpl(string, n);
        oracleSSLSocketImpl.setSSLSocketFactory(this);
        return oracleSSLSocketImpl;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        if (this.isProxyEnabled) {
            OracleHttpsSocket oracleHttpsSocket = new OracleHttpsSocket(this.httpsProxyHost, this.httpsProxyPort);
            this.makeProxyConnection(oracleHttpsSocket, string, n);
            oracleHttpsSocket.setSSLSocketFactory(this);
            return oracleHttpsSocket;
        }
        OracleSSLSocketImpl oracleSSLSocketImpl = new OracleSSLSocketImpl(string, n, inetAddress, n2);
        oracleSSLSocketImpl.setSSLSocketFactory(this);
        return oracleSSLSocketImpl;
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        if (this.isProxyEnabled) {
            OracleHttpsSocket oracleHttpsSocket = new OracleHttpsSocket(this.httpsProxyHost, this.httpsProxyPort);
            String string = inetAddress.getHostName();
            this.makeProxyConnection(oracleHttpsSocket, string, n);
            oracleHttpsSocket.setSSLSocketFactory(this);
            return oracleHttpsSocket;
        }
        OracleSSLSocketImpl oracleSSLSocketImpl = new OracleSSLSocketImpl(inetAddress, n);
        oracleSSLSocketImpl.setSSLSocketFactory(this);
        return oracleSSLSocketImpl;
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        if (this.isProxyEnabled) {
            return this.createSocket(inetAddress, n);
        }
        OracleSSLSocketImpl oracleSSLSocketImpl = new OracleSSLSocketImpl(inetAddress, n, inetAddress2, n2);
        oracleSSLSocketImpl.setSSLSocketFactory(this);
        return oracleSSLSocketImpl;
    }

    public Socket createSocket(Socket socket) throws IOException {
        OracleSSLSocketImpl oracleSSLSocketImpl = new OracleSSLSocketImpl(socket);
        oracleSSLSocketImpl.setSSLSocketFactory(this);
        return oracleSSLSocketImpl;
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        OracleSSLSocketImpl oracleSSLSocketImpl = new OracleSSLSocketImpl(socket, string, n, bl);
        oracleSSLSocketImpl.setSSLSocketFactory(this);
        return oracleSSLSocketImpl;
    }

    public String[] getDefaultCipherSuites() {
        return OracleSSLCipherSuite.getSupportedCipherSuites();
    }

    OracleSSLCredential getSSLCredentials() {
        return this.m_sslCredential;
    }

    int getSSLProtocolVersion() {
        return this.m_sslVersion;
    }

    public String[] getSupportedCipherSuites() {
        return OracleSSLCipherSuite.getSupportedCipherSuites();
    }

    public OracleX509TrustManagerInterface[] getTrustManagers() {
        return this.m_trustManagerA;
    }

    private void initProxySettings() {
        try {
            String string = System.getProperty(HTTPS_PROXY_HOST_ENV_VAR);
            String string2 = System.getProperty(HTTPS_PROXY_PORT_ENV_VAR);
            if (string != null && string.trim() != null && string2 != null && string2.trim() != null) {
                this.httpsProxyHost = string.trim();
                this.httpsProxyPort = Integer.parseInt(string2.trim());
                this.isProxyEnabled = true;
            }
        }
        catch (Exception exception) {
            this.isProxyEnabled = false;
        }
    }

    private void makeProxyConnection(OracleHttpsSocket oracleHttpsSocket, String string, int n) throws IOException {
        InputStream inputStream = oracleHttpsSocket.getRawInputStream();
        OutputStream outputStream = oracleHttpsSocket.getRawOutputStream();
        String string2 = String.valueOf(n);
        String string3 = "CONNECT " + string + ":" + string2 + " HTTP/1.0\r\n" + "User-Agent: Oracle Proxy Enabled SSL Socket\r\n\r\n";
        outputStream.write(string3.getBytes(), 0, string3.length());
        byte[] byArray = new byte[2048];
        int n2 = inputStream.read(byArray, 0, 2048);
    }

    public void setSSLCredentials(OracleSSLCredential oracleSSLCredential) throws SSLException {
        if (oracleSSLCredential != null) {
            this.m_sslCredential = oracleSSLCredential;
            OracleX509TrustManagerInterface[] oracleX509TrustManagerInterfaceArray = new OracleX509TrustManagerInterface[1];
            OracleSSLDebug.debug("Setting default TrustManagers");
            oracleX509TrustManagerInterfaceArray[0] = new OracleX509TrustManager(this.m_sslCredential);
            this.setTrustManagers(oracleX509TrustManagerInterfaceArray);
        }
    }

    public void setSSLProtocolVersion(int n) throws SSLException {
        if (n != 0 && n != 100 && n != 101 && n != 2 && n != 768) {
            throw new SSLException("SSL protocol version not supported");
        }
        this.m_sslVersion = n;
    }

    public void setTrustManagers(OracleX509TrustManagerInterface[] oracleX509TrustManagerInterfaceArray) {
        this.m_trustManagerA = oracleX509TrustManagerInterfaceArray;
    }
}

