/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.ssl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import oracle.security.cert.X509CertificateImpl;

public class OracleSSLSession
implements SSLSession {
    private byte[] id;
    private byte[] m_session_ctx = null;
    private String[] names = null;
    private X509CertificateImpl[] m_peerCertChain = null;
    private byte[][] m_peerRawCertChain = null;

    public String getCipherSuite() {
        return this.getNegotiatedCipherSuite(this.m_session_ctx);
    }

    public long getCreationTime() {
        return 0L;
    }

    public byte[] getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return 0L;
    }

    private native String getNegotiatedCipherSuite(byte[] var1);

    public String getNegotiatedProtocolVersion() {
        return this.getNegotiatedVer(this.m_session_ctx);
    }

    private native String getNegotiatedVer(byte[] var1);

    private native int getNumOfPeerCerts(byte[] var1);

    private native byte[] getPeerCertChain(byte[] var1, int var2) throws CertificateException;

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        try {
            this.getX509PeerCerts();
        }
        catch (CertificateException certificateException) {
            throw new SSLPeerUnverifiedException("Failed to retrive peer cert chain");
        }
        return this.m_peerCertChain;
    }

    public String getPeerHost() {
        return null;
    }

    public byte[][] getPeerRawCertificateChain() throws SSLPeerUnverifiedException {
        try {
            this.getRawPeerCerts();
        }
        catch (CertificateException certificateException) {
            throw new SSLPeerUnverifiedException("Failed to retrive peer cert chain");
        }
        if (this.m_peerRawCertChain != null) {
            return this.m_peerRawCertChain;
        }
        throw new SSLPeerUnverifiedException("Can not retrive peer cert chain");
    }

    private void getRawPeerCerts() throws CertificateException {
        int n = this.getNumOfPeerCerts(this.m_session_ctx);
        this.m_peerRawCertChain = new byte[n][];
        int n2 = 1;
        while (n2 <= n) {
            if (this.m_session_ctx == null) {
                throw new CertificateException();
            }
            this.m_peerRawCertChain[n2 - 1] = this.getPeerCertChain(this.m_session_ctx, n2);
            ++n2;
        }
    }

    public SSLSessionContext getSessionContext() {
        return null;
    }

    public Object getValue(String string) {
        return null;
    }

    public String[] getValueNames() {
        return this.names;
    }

    private void getX509PeerCerts() throws CertificateException {
        int n = this.getNumOfPeerCerts(this.m_session_ctx);
        this.m_peerCertChain = new X509CertificateImpl[n];
        int n2 = 1;
        while (n2 <= n) {
            byte[] byArray = null;
            if (this.m_session_ctx != null) {
                byArray = this.getPeerCertChain(this.m_session_ctx, n2);
            }
            this.m_peerCertChain[n2 - 1] = new X509CertificateImpl(byArray, 0, byArray.length);
            ++n2;
        }
    }

    public void invalidate() {
    }

    public void putValue(String string, Object object) {
    }

    public void removeValue(String string) {
    }

    public void setSSLSessionContext(byte[] byArray) {
        this.m_session_ctx = byArray;
    }
}

