/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import oracle.security.ssl.OracleSSLCipherSuite;
import oracle.security.ssl.OracleSSLServerSocketFactoryImpl;
import oracle.security.ssl.OracleSSLSocketFactoryImpl;
import oracle.security.ssl.OracleSSLSocketImpl;

class OracleSSLServerSocketImpl
extends SSLServerSocket {
    private OracleSSLServerSocketFactoryImpl m_factoryImpl = null;
    private int m_sslProtocolVer = 100;
    private OracleSSLSocketFactoryImpl m_socketFactoryImpl = new OracleSSLSocketFactoryImpl();
    protected String[] m_enabledCipherList;
    protected boolean m_useClientMode = false;
    protected boolean m_isClientAuthReqd = false;

    protected OracleSSLServerSocketImpl(int n) throws IOException {
        super(n);
    }

    protected OracleSSLServerSocketImpl(int n, int n2) throws IOException {
        super(n, n2);
    }

    protected OracleSSLServerSocketImpl(int n, int n2, InetAddress inetAddress) throws IOException {
        super(n, n2, inetAddress);
    }

    public synchronized Socket accept() throws IOException {
        this.m_socketFactoryImpl.setSSLCredentials(this.m_factoryImpl.getSSLCredentials());
        this.m_socketFactoryImpl.setSSLProtocolVersion(this.m_factoryImpl.getSSLProtocolVersion());
        OracleSSLSocketImpl oracleSSLSocketImpl = (OracleSSLSocketImpl)this.m_socketFactoryImpl.createSocket();
        this.implAccept(oracleSSLSocketImpl);
        oracleSSLSocketImpl.initSSLContext(oracleSSLSocketImpl.getInetAddress().getHostAddress().getBytes(), oracleSSLSocketImpl.getPort(), oracleSSLSocketImpl);
        oracleSSLSocketImpl.setEnabledCipherSuites(this.m_enabledCipherList);
        oracleSSLSocketImpl.setNeedClientAuth(this.m_isClientAuthReqd);
        oracleSSLSocketImpl.setUseClientMode(this.m_useClientMode);
        oracleSSLSocketImpl.startHandshake();
        oracleSSLSocketImpl.setSSLSessionContext();
        return oracleSSLSocketImpl;
    }

    public void close() throws IOException {
        super.close();
    }

    public boolean getEnableSessionCreation() {
        return false;
    }

    public String[] getEnabledCipherSuites() {
        return (String[])this.m_enabledCipherList.clone();
    }

    public boolean getNeedClientAuth() {
        return this.m_isClientAuthReqd;
    }

    public String[] getSupportedCipherSuites() {
        return OracleSSLCipherSuite.getSupportedCipherSuites();
    }

    public boolean getUseClientMode() {
        return this.m_useClientMode;
    }

    public void setEnableSessionCreation(boolean bl) {
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.m_enabledCipherList = OracleSSLSocketImpl.enabledCipherSuites(stringArray);
    }

    public void setNeedClientAuth(boolean bl) {
        this.m_isClientAuthReqd = bl;
    }

    public void setSSLProtocolVersion(int n) throws SSLException {
        if (n != 0 && n != 100 && n != 101 && n != 2 && n != 768) {
            throw new SSLException("SSL protocol version not supported");
        }
        this.m_sslProtocolVer = n;
    }

    void setSSLSocketFactory(OracleSSLServerSocketFactoryImpl oracleSSLServerSocketFactoryImpl) {
        this.m_factoryImpl = oracleSSLServerSocketFactoryImpl;
    }

    public void setUseClientMode(boolean bl) {
        this.m_useClientMode = bl;
    }
}

