/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLException;
import oracle.security.ssl.OracleSSLCipherSuite;
import oracle.security.ssl.OracleSSLCredential;
import oracle.security.ssl.OracleSSLServerSocketFactory;
import oracle.security.ssl.OracleSSLServerSocketImpl;

public class OracleSSLServerSocketFactoryImpl
extends OracleSSLServerSocketFactory {
    private OracleSSLCredential m_sslCredential = null;
    private int m_sslVersion = 100;

    public ServerSocket createServerSocket(int n) throws IOException {
        OracleSSLServerSocketImpl oracleSSLServerSocketImpl = new OracleSSLServerSocketImpl(n);
        oracleSSLServerSocketImpl.setSSLSocketFactory(this);
        return oracleSSLServerSocketImpl;
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        OracleSSLServerSocketImpl oracleSSLServerSocketImpl = new OracleSSLServerSocketImpl(n, n2);
        oracleSSLServerSocketImpl.setSSLSocketFactory(this);
        return oracleSSLServerSocketImpl;
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        OracleSSLServerSocketImpl oracleSSLServerSocketImpl = new OracleSSLServerSocketImpl(n, n2, inetAddress);
        oracleSSLServerSocketImpl.setSSLSocketFactory(this);
        return oracleSSLServerSocketImpl;
    }

    public String[] getDefaultCipherSuites() {
        return OracleSSLCipherSuite.getSupportedCipherSuites();
    }

    OracleSSLCredential getSSLCredentials() {
        return this.m_sslCredential;
    }

    int getSSLProtocolVersion() {
        return this.m_sslVersion;
    }

    public String[] getSupportedCipherSuites() {
        return OracleSSLCipherSuite.getSupportedCipherSuites();
    }

    public void setSSLCredentials(OracleSSLCredential oracleSSLCredential) throws SSLException {
        if (oracleSSLCredential != null) {
            this.m_sslCredential = oracleSSLCredential;
        }
    }

    public void setSSLProtocolVersion(int n) throws SSLException {
        if (n != 0 && n != 100 && n != 101 && n != 2 && n != 768) {
            throw new SSLException("SSL protocol version not supported");
        }
        this.m_sslVersion = n;
    }
}

