/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.ssl;

import java.io.IOException;
import java.util.Vector;
import oracle.security.cert.CertChain;
import oracle.security.jwallet.JWalletCertificate;
import oracle.security.jwallet.JWalletPersona;
import oracle.security.jwallet.JWalletPvtKey;
import oracle.security.jwallet.txtwallet.TxtWalletReader;
import sun.misc.BASE64Decoder;

public class OracleSSLCredential {
    private static String NEWLINE = "\n";
    private static String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    private static String END_CERT = "-----END CERTIFICATE-----";
    private static String BEGIN_ENC_PKEY = "-----BEGIN ENCRYPTED PRIVATE KEY-----";
    private static String END_ENC_PKEY = "-----END ENCRYPTED PRIVATE KEY-----";
    private static int SUBJECTNAME = 0;
    private static int ISSUERNAME = 1;
    private Vector m_tpVector = null;
    private Vector m_certChainVector = null;
    private byte[] m_pvtKey = null;
    private String m_pvtKeyPasswd = null;
    private CertChain cc = null;
    private BASE64Decoder m_decoder;

    public OracleSSLCredential() {
        this.init();
    }

    public void addCertChain(String string) throws NullPointerException {
        try {
            string = string.trim();
            if (string == null || string.length() <= 0) {
                throw new NullPointerException("null trusted certificate");
            }
            if (string.startsWith("-----BEGIN CERTIFICATE-----")) {
                this.addCertChain(this.m_decoder.decodeBuffer(string.substring(BEGIN_CERT.length(), string.length() - END_CERT.length())));
            } else {
                this.addCertChain(this.m_decoder.decodeBuffer(string));
            }
        }
        catch (Exception exception) {
            throw new NullPointerException(exception.toString());
        }
    }

    public void addCertChain(byte[] byArray) throws NullPointerException {
        if (byArray == null || byArray.length <= 0) {
            throw new NullPointerException("null cert chain certificate");
        }
        this.m_certChainVector.addElement(byArray);
    }

    public void addTrustedCert(String string) throws NullPointerException {
        try {
            string = string.trim();
            if (string == null || string.length() <= 0) {
                throw new NullPointerException("null trusted certificate");
            }
            if (string.startsWith("-----BEGIN CERTIFICATE-----")) {
                this.addTrustedCert(this.m_decoder.decodeBuffer(string.substring(BEGIN_CERT.length(), string.length() - END_CERT.length())));
            } else {
                this.addTrustedCert(this.m_decoder.decodeBuffer(string));
            }
        }
        catch (Exception exception) {
            throw new NullPointerException(exception.toString());
        }
    }

    public void addTrustedCert(byte[] byArray) throws NullPointerException {
        if (byArray == null || byArray.length <= 0) {
            throw new NullPointerException("null trusted certificate");
        }
        this.m_tpVector.addElement(byArray);
    }

    public byte[] getCertChainCert(int n) throws IllegalArgumentException {
        int n2 = this.m_certChainVector.size();
        if (n >= n2 || n < 0) {
            throw new IllegalArgumentException("Wrong index for cert chain  certificate");
        }
        return (byte[])this.m_certChainVector.elementAt(n);
    }

    public int getCertChainCount() {
        return this.m_certChainVector.size();
    }

    protected byte[] getPrivateKey() {
        return this.m_pvtKey;
    }

    protected String getPvtKeyPassword() {
        return this.m_pvtKeyPasswd;
    }

    protected byte[] getTrustedCert(int n) {
        return (byte[])this.m_tpVector.elementAt(n);
    }

    protected int getTrustedCertCount() {
        return this.m_tpVector.size();
    }

    private void init() {
        this.m_decoder = new BASE64Decoder();
        this.m_tpVector = new Vector();
        this.m_certChainVector = new Vector();
        this.m_pvtKey = null;
        this.m_pvtKeyPasswd = null;
    }

    public void setPrivateKey(String string, String string2) throws NullPointerException {
        try {
            string = string.trim();
            if (string == null || string.length() <= 0) {
                throw new NullPointerException("null private key");
            }
            if (string.startsWith("-----BEGIN ENCRYPTED PRIVATE KEY-----")) {
                this.setPrivateKey(this.m_decoder.decodeBuffer(string.substring(BEGIN_ENC_PKEY.length(), string.length() - END_ENC_PKEY.length())), string2);
            } else {
                this.setPrivateKey(this.m_decoder.decodeBuffer(string), string2);
            }
        }
        catch (Exception exception) {
            throw new NullPointerException(exception.toString());
        }
    }

    public void setPrivateKey(byte[] byArray, String string) throws NullPointerException {
        if (byArray == null || byArray.length <= 0) {
            throw new NullPointerException("null private key");
        }
        this.m_pvtKey = byArray;
        this.m_pvtKeyPasswd = string;
    }

    public void setWallet(String string, String string2) throws IOException {
        TxtWalletReader txtWalletReader = new TxtWalletReader(string, string2);
        JWalletPersona jWalletPersona = txtWalletReader.getPersonaByIndex(0);
        int n = jWalletPersona.getTrustedCertCount();
        JWalletCertificate jWalletCertificate = null;
        int n2 = 0;
        while (n2 < n) {
            jWalletCertificate = jWalletPersona.getTrustedCertByIndex(n2);
            this.addTrustedCert(jWalletCertificate.getCertData());
            ++n2;
        }
        JWalletPvtKey jWalletPvtKey = jWalletPersona.getPrivateKey();
        if (jWalletPvtKey != null) {
            byte[] byArray = jWalletPvtKey.getPvtKeyData();
            if (byArray != null) {
                this.setPrivateKey(jWalletPvtKey.getPvtKeyData(), string2);
            }
            int n3 = jWalletPersona.getCertChainCount();
            JWalletCertificate jWalletCertificate2 = null;
            int n4 = n3;
            while (n4 > 0) {
                jWalletCertificate2 = jWalletPersona.getCertChainByIndex(n4 - 1);
                this.addCertChain(jWalletCertificate2.getCertData());
                --n4;
            }
        }
    }

    public String toString() {
        return "Trusted Certificate Count=" + this.getTrustedCertCount() + "Cert Chain count =" + this.getCertChainCount();
    }
}

