/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.ssl;

import oracle.security.ssl.OracleSSLSocketImpl;

final class OracleSSLCipherSuite {
    private static String[] m_export_ciphers = new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_WITH_NULL_SHA", "SSL_RSA_WITH_NULL_MD5"};
    private static String[] m_export_DH_ciphers = new String[]{"SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA"};
    private static String[] m_non_export_ciphers = new String[]{"SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_RC4_128_MD5"};
    private static String[] m_non_export_DH_ciphers = new String[]{"SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DH_anon_WITH_DES_CBC_SHA"};

    OracleSSLCipherSuite() {
    }

    static String[] getSupportedCipherSuites() {
        if (OracleSSLCipherSuite.isSSLLibDomestic()) {
            int n = m_non_export_ciphers.length + m_export_ciphers.length;
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < m_non_export_ciphers.length) {
                stringArray[n2] = m_non_export_ciphers[n2];
                ++n2;
            }
            int n3 = 0;
            while (n3 < m_export_ciphers.length) {
                stringArray[n2 + n3] = m_export_ciphers[n3];
                ++n3;
            }
            return stringArray;
        }
        return m_export_ciphers;
    }

    static String[] getSupportedDHCipherSuites() {
        if (OracleSSLCipherSuite.isSSLLibDomestic()) {
            int n = m_non_export_DH_ciphers.length + m_export_DH_ciphers.length;
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < m_non_export_DH_ciphers.length) {
                stringArray[n2] = m_non_export_DH_ciphers[n2];
                ++n2;
            }
            int n3 = 0;
            while (n3 < m_export_DH_ciphers.length) {
                stringArray[n2 + n3] = m_export_DH_ciphers[n3];
                ++n3;
            }
            return stringArray;
        }
        return m_export_DH_ciphers;
    }

    static boolean isSSLLibDomestic() {
        return OracleSSLSocketImpl.isSSLLibDomestic();
    }
}

