/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.ssl;

import oracle.security.ssl.OracleSSLDebug;

public class CryptoUtils {
    byte[] encAlgObjPtr = null;
    byte[] decAlgObjPtr = null;
    static byte[] randomAlgoObjPtr = null;

    static {
        if (System.getProperty("oracle.server.version") == null) {
            System.loadLibrary("njssl9");
        }
        CryptoUtils.doNativeInitialization();
    }

    public static boolean compareDigests(byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        if (byArray == null || byArray2 == null) {
            return bl;
        }
        if (byArray.length != byArray2.length) {
            return bl;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return bl;
            }
            ++n;
        }
        bl = true;
        return bl;
    }

    public byte[] decrypt(byte[] byArray) {
        byte[] byArray2 = null;
        if (this.encAlgObjPtr == null || this.decAlgObjPtr == null) {
            OracleSSLDebug.debug("ERROR: Key Generation must precede encrypt/decrypt operations.");
            return byArray2;
        }
        if (byArray == null) {
            OracleSSLDebug.debug("ERROR: Data input for decryption is null");
            return byArray2;
        }
        return this.doNativeDecryption(this.decAlgObjPtr, byArray);
    }

    public static byte[] decryptStatic(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        if (byArray == null) {
            OracleSSLDebug.debug("ERROR: Key not exists for decryption");
            return byArray3;
        }
        if (byArray2 == null) {
            OracleSSLDebug.debug("ERROR: Data input for decryption is null");
            return byArray3;
        }
        return CryptoUtils.doNativeDecryptionStatic(byArray, byArray2);
    }

    private native byte[] doNativeDecryption(byte[] var1, byte[] var2);

    private static native byte[] doNativeDecryptionStatic(byte[] var0, byte[] var1);

    private native byte[] doNativeEncryption(byte[] var1, byte[] var2);

    private static native byte[] doNativeEncryptionStatic(byte[] var0, byte[] var1);

    private native void doNativeGenDESKey(byte[] var1, String var2);

    private static native byte[] doNativeGenDESKeyStatic(byte[] var0, String var1);

    private static native void doNativeGenRandomAlgo();

    private static native byte[] doNativeGetRandomBytes(byte[] var0, int var1);

    private static native void doNativeInitialization();

    private static native byte[] doNativeMessageDigest(byte[] var0);

    private native void doNativefreeAlgObjects(byte[] var1, byte[] var2);

    public byte[] encrypt(byte[] byArray) {
        byte[] byArray2 = null;
        if (this.encAlgObjPtr == null || this.decAlgObjPtr == null) {
            OracleSSLDebug.debug("ERROR: Key Generation must precede encrypt/decrypt operations.");
            return byArray2;
        }
        if (byArray == null) {
            OracleSSLDebug.debug("ERROR: Data input for encryption is null");
            return byArray2;
        }
        return this.doNativeEncryption(this.encAlgObjPtr, byArray);
    }

    public static byte[] encryptStatic(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        if (byArray == null) {
            OracleSSLDebug.debug("ERROR: Key not exists for encryption");
            return byArray3;
        }
        if (byArray2 == null) {
            OracleSSLDebug.debug("ERROR: Data input for encryption is null");
            return byArray3;
        }
        return CryptoUtils.doNativeEncryptionStatic(byArray, byArray2);
    }

    protected void finalize() {
        if (this.encAlgObjPtr != null && this.decAlgObjPtr != null) {
            this.doNativefreeAlgObjects(this.encAlgObjPtr, this.decAlgObjPtr);
            this.encAlgObjPtr = null;
            this.decAlgObjPtr = null;
            OracleSSLDebug.debug("Successfull Finalization (freed alg objs).\n");
        }
    }

    public void freeCMem() {
        OracleSSLDebug.debug(" Performing explicit cleanup.\n");
        this.finalize();
    }

    public static byte[] generateCommonKey() {
        return CryptoUtils.getRandomBytes(8);
    }

    public void generateDESKey(byte[] byArray, String string) {
        if (this.encAlgObjPtr == null && this.decAlgObjPtr == null) {
            this.doNativeGenDESKey(byArray, string);
        } else {
            OracleSSLDebug.debug("ERROR: DES key already created for this object.");
        }
    }

    public static byte[] generateDESKeyStatic(byte[] byArray, String string) {
        return CryptoUtils.doNativeGenDESKeyStatic(byArray, string);
    }

    public static void generateRandomAlgo() {
        if (randomAlgoObjPtr == null) {
            CryptoUtils.doNativeGenRandomAlgo();
        } else {
            OracleSSLDebug.debug("ERROR: Random Algo already created for this object.");
        }
        if (randomAlgoObjPtr == null) {
            System.out.println(" ERROR: Cannot create Random Algorithm");
            System.exit(-1);
        }
    }

    public static byte[] getMessageDigest(byte[] byArray) {
        return CryptoUtils.doNativeMessageDigest(byArray);
    }

    public static byte[] getRandomBytes(int n) {
        if (randomAlgoObjPtr == null) {
            CryptoUtils.generateRandomAlgo();
        }
        return CryptoUtils.doNativeGetRandomBytes(randomAlgoObjPtr, n);
    }

    public static void setTrace(int n) {
        if (n == 0) {
            OracleSSLDebug.setDebugFlag(false);
        } else {
            OracleSSLDebug.setDebugFlag(true);
        }
    }
}

