/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.jwallet.txtwallet;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import oracle.security.cert.CertChain;
import oracle.security.jwallet.JWalletCertificate;
import oracle.security.jwallet.JWalletPersona;
import oracle.security.jwallet.JWalletPvtKey;
import oracle.security.jwallet.txtwallet.TxtWalletCertificate;
import oracle.security.jwallet.txtwallet.TxtWalletPvtKey;
import sun.misc.BASE64Decoder;

class TxtWalletPersona
implements JWalletPersona {
    private BASE64Decoder m_decoder;
    private String m_passwd;
    private JWalletPvtKey m_pvtKey;
    private Vector m_certChainV = new Vector();
    private Vector m_tpV = new Vector();
    private Vector m_certChainDERVector = new Vector();
    private CertChain cc = null;
    private static String NEWLINE = "\r\n";
    private static String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    private static String END_CERT = "-----END CERTIFICATE-----";
    private static String BEGIN_ENC_PKEY = "-----BEGIN ENCRYPTED PRIVATE KEY-----";
    private static String END_ENC_PKEY = "-----END ENCRYPTED PRIVATE KEY-----";
    private static int SUBJECTNAME = 0;
    private static int ISSUERNAME = 1;

    public TxtWalletPersona(String string, String string2) {
        this.m_passwd = string2;
        this.m_decoder = new BASE64Decoder();
        this.cc = new CertChain();
        this.init(string);
    }

    private void closeFilehandle(RandomAccessFile randomAccessFile) {
        try {
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
    }

    public JWalletCertificate getCertChainByIndex(int n) {
        if (this.m_pvtKey != null) {
            return (JWalletCertificate)this.m_certChainV.elementAt(n);
        }
        return null;
    }

    public int getCertChainCount() {
        if (this.m_pvtKey != null) {
            return this.m_certChainV.size();
        }
        return 0;
    }

    private RandomAccessFile getFileHandle(File file) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
        }
        catch (Exception exception) {
            System.err.println("IO Exception caught: " + exception.toString());
            return null;
        }
        return randomAccessFile;
    }

    private Object getNextCertInChain(byte[] byArray, Vector vector) {
        String string = this.cc.checkAndGetCertInfo(byArray, SUBJECTNAME);
        String string2 = this.cc.checkAndGetCertInfo(byArray, ISSUERNAME);
        Object var5_5 = null;
        int n = 0;
        while (n < this.getTrustedCertCount()) {
            Object e = vector.elementAt(n);
            String string3 = this.cc.checkAndGetCertInfo(((TxtWalletCertificate)e).getCertData(), SUBJECTNAME);
            if (string2.equalsIgnoreCase(string3)) {
                var5_5 = e;
            }
            ++n;
        }
        return var5_5;
    }

    public JWalletPvtKey getPrivateKey() {
        return this.m_pvtKey;
    }

    public JWalletCertificate getTrustedCertByIndex(int n) {
        return (JWalletCertificate)this.m_tpV.elementAt(n);
    }

    public int getTrustedCertCount() {
        return this.m_tpV.size();
    }

    private void init(String string) {
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        boolean bl = false;
        boolean bl2 = true;
        File file = new File(string);
        this.readEncPrivateKey(file);
        this.readCertificates(file);
    }

    private void readCertificates(File file) {
        RandomAccessFile randomAccessFile = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = true;
        byte[] byArray = null;
        try {
            randomAccessFile = this.getFileHandle(file);
            while (bl2) {
                string = randomAccessFile.readLine().trim();
                if (string != null && string.startsWith(END_CERT)) {
                    bl = false;
                    byArray = this.m_decoder.decodeBuffer(string2);
                    this.m_tpV.addElement(new TxtWalletCertificate(byArray));
                    string2 = null;
                }
                if (bl) {
                    string2 = String.valueOf(string2) + string + NEWLINE;
                }
                if (!string.startsWith(BEGIN_CERT)) continue;
                string2 = new String();
                bl = true;
            }
            this.closeFilehandle(randomAccessFile);
        }
        catch (IOException iOException) {
            this.closeFilehandle(randomAccessFile);
            System.err.println("IO Exception caught: " + iOException.toString());
        }
        catch (NullPointerException nullPointerException) {
            this.closeFilehandle(randomAccessFile);
        }
        int n = 0;
        if (this.m_tpV.size() > 1 && this.m_pvtKey != null) {
            Object object = null;
            if (n == 0) {
                object = this.m_tpV.elementAt(n);
                this.m_certChainV.addElement(object);
                this.m_tpV.removeElementAt(0);
            }
            int n2 = 0;
            while (n2 < this.m_tpV.size()) {
                Object object2 = this.getNextCertInChain(((TxtWalletCertificate)object).getCertData(), this.m_tpV);
                if (object2 != null) {
                    this.m_certChainV.addElement(object2);
                    if (this.cc.verifySelfSigned(((TxtWalletCertificate)object2).getCertData())) break;
                    object = object2;
                }
                ++n2;
            }
        }
    }

    private void readEncPrivateKey(File file) {
        RandomAccessFile randomAccessFile = null;
        String string = null;
        boolean bl = false;
        String string2 = null;
        boolean bl2 = true;
        try {
            randomAccessFile = this.getFileHandle(file);
            while (bl2) {
                string = randomAccessFile.readLine().trim();
                if (string != null && string.startsWith(END_ENC_PKEY)) {
                    bl = false;
                }
                if (bl) {
                    string2 = String.valueOf(string2) + string + NEWLINE;
                }
                if (string == null || !string.startsWith(BEGIN_ENC_PKEY)) continue;
                bl = true;
                string2 = new String();
            }
            this.closeFilehandle(randomAccessFile);
        }
        catch (NullPointerException nullPointerException) {
            this.closeFilehandle(randomAccessFile);
        }
        catch (Exception exception) {
            this.closeFilehandle(randomAccessFile);
            System.err.println("Exception caught: " + exception.toString());
            string2 = null;
        }
        try {
            this.m_pvtKey = string2 != null ? new TxtWalletPvtKey(this.m_decoder.decodeBuffer(string2), this.m_passwd) : null;
        }
        catch (Exception exception) {
            System.out.println("PKEY Buffer decoding fail");
        }
    }
}

