/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.cert;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Set;
import oracle.security.cert.X509CertificateHelper;

public class X509CertificateImpl
extends X509Certificate {
    private X509CertificateHelper _x509CertHelper = new X509CertificateHelper();

    public X509CertificateImpl() {
    }

    public X509CertificateImpl(byte[] byArray) throws CertificateException {
        this(byArray, 0, byArray.length);
    }

    public X509CertificateImpl(byte[] byArray, int n, int n2) throws CertificateException {
        try {
            this._x509CertHelper.decode(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.toString());
        }
    }

    public void X509Certificate(InputStream inputStream) throws IOException {
        this.decode(inputStream);
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this._x509CertHelper.checkValidity();
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this._x509CertHelper.checkValidity(date);
    }

    public void decode(InputStream inputStream) throws IOException {
        try {
            this._x509CertHelper.decode(inputStream);
        }
        catch (Exception exception) {
            throw new IOException("Certificate decoding failed: " + exception.toString());
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Certificate) {
            try {
                byte[] byArray = ((Certificate)object).getEncoded();
                byte[] byArray2 = this.getEncoded();
                if (byArray.length != byArray2.length) {
                    return false;
                }
                int n = 0;
                boolean bl = true;
                while (bl && n < byArray2.length) {
                    bl = byArray[n] == byArray2[n];
                    ++n;
                }
                return bl;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                return this._x509CertHelper.equals(object);
            }
        }
        return false;
    }

    public int getBasicConstraints() {
        return 0;
    }

    public Set getCriticalExtensionOIDs() {
        return null;
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this._x509CertHelper.getEncoded();
    }

    public byte[] getExtensionValue(String string) {
        return null;
    }

    public Principal getIssuerDN() {
        return this._x509CertHelper.getIssuerName();
    }

    public boolean[] getIssuerUniqueID() {
        return null;
    }

    public boolean[] getKeyUsage() {
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        return null;
    }

    public Date getNotAfter() {
        return this._x509CertHelper.getNotAfter();
    }

    public Date getNotBefore() {
        return this._x509CertHelper.getNotBefore();
    }

    public PublicKey getPublicKey() {
        return this._x509CertHelper.getPublicKey();
    }

    public BigInteger getSerialNumber() {
        return this._x509CertHelper.getCertSerialNumber();
    }

    public String getSigAlgName() {
        return this._x509CertHelper.getSigAlgName();
    }

    public String getSigAlgOID() {
        return this._x509CertHelper.getSigAlgOID();
    }

    public byte[] getSigAlgParams() {
        return this._x509CertHelper.getSigAlgParams();
    }

    public byte[] getSignature() {
        return null;
    }

    public Principal getSubjectDN() {
        return this._x509CertHelper.getSubjectName();
    }

    public boolean[] getSubjectUniqueID() {
        return null;
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return null;
    }

    public int getVersion() {
        return this._x509CertHelper.getVersion();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public int hashCode() {
        return this._x509CertHelper.hashCode();
    }

    public String toString() {
        return "Subject:" + this.getSubjectDN();
    }

    public void verify(PublicKey publicKey) throws CertificateException {
        try {
            this._x509CertHelper.verify(publicKey);
        }
        catch (Exception exception) {
            throw new CertificateException(exception.toString());
        }
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException {
        String string2 = publicKey.getAlgorithm();
        if (!string2.equals(this.getPublicKey().getAlgorithm())) {
            throw new CertificateException("No such algorithm " + string2);
        }
        this.verify(publicKey);
    }
}

