/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.cert;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Date;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertException;
import sun.security.x509.X509Cert;

class X509CertificateHelper
extends X509Cert {
    byte[] der_encoded_cert = new byte[1];

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        Date date = new Date();
        this.checkValidity(date);
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        Date date2 = super.getNotAfter();
        Date date3 = super.getNotBefore();
        if (date.after(date2)) {
            throw new CertificateExpiredException("Certificate expired on " + date2.toString());
        }
        if (date.before(date3)) {
            throw new CertificateNotYetValidException("Certificate will be valid from" + date2.toString());
        }
    }

    public void decode(InputStream inputStream) throws IOException {
        try {
            super.decode(inputStream);
            this.der_encoded_cert = super.getSignedCert();
        }
        catch (Exception exception) {
            throw new IOException("Certificate decoding failed: " + exception.toString());
        }
    }

    public void decode(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.der_encoded_cert = new byte[n2];
            int n3 = n;
            while (n3 < n2) {
                this.der_encoded_cert[n3] = byArray[n3];
                ++n3;
            }
            super.decode((InputStream)new ByteArrayInputStream(this.der_encoded_cert));
        }
        catch (IOException iOException) {
            throw new IOException(iOException.toString());
        }
    }

    public boolean equals(Object object) {
        return false;
    }

    public BigInteger getCertSerialNumber() {
        return super.getSerialNumber().toBigInteger();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return super.getSignedCert();
        }
        catch (Exception exception) {
            throw new CertificateEncodingException();
        }
    }

    public Principal getIssuerDN() {
        return super.getIssuerName();
    }

    public Date getNotAfter() {
        return super.getNotAfter();
    }

    public Date getNotBefore() {
        return super.getNotBefore();
    }

    public PublicKey getPublicKey() {
        return super.getPublicKey();
    }

    public String getSigAlgName() {
        AlgorithmId algorithmId = super.getIssuerAlgorithmId();
        return algorithmId.getName();
    }

    public String getSigAlgOID() {
        return null;
    }

    public byte[] getSigAlgParams() {
        return null;
    }

    public Principal getSubjectDN() {
        return super.getSubjectName();
    }

    public int getVersion() {
        return super.getVersion();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.getSubjectDN().getName();
    }

    public void verify(PublicKey publicKey) throws CertException {
        super.verify(publicKey);
    }
}

