/*
 * Decompiled with CFR 0.152.
 */
package oracle.graphics.vgs.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import oracle.graphics.vgs.ui.Convert;
import oracle.graphics.vgs.ui.Device;
import oracle.graphics.vgs.ui.Graphic;
import oracle.graphics.vgs.ui.PackedTree;

public class VPolygon
extends Graphic {
    private Polygon mPoly;
    private Polygon mPolyRotated;
    private boolean mClosed;

    public VPolygon() {
        this.setClassType((byte)7);
        this.mPoly = new Polygon();
        this.mClosed = false;
    }

    public VPolygon(boolean bl) {
        this();
        this.mUseAntiAlias = bl;
    }

    public VPolygon(boolean bl, boolean bl2) {
        this(bl);
        this.mHonorLineWidth = bl2;
    }

    @Override
    public int pUnpack(PackedTree packedTree, DataInputStream dataInputStream) throws IOException {
        super.pUnpack(packedTree, dataInputStream);
        int n = dataInputStream.readInt();
        if (n > 0) {
            int n2;
            int n3 = dataInputStream.readInt();
            dataInputStream = packedTree.pushStream(n3);
            for (n2 = 0; n2 < n; ++n2) {
                int n4 = packedTree.getTransform().transformXValue(Convert.OracleIntToJava(dataInputStream));
                int n5 = packedTree.getTransform().transformYValue(Convert.OracleIntToJava(dataInputStream));
                this.mPoly.addPoint(n4, n5);
            }
            dataInputStream = packedTree.popStream();
            n2 = dataInputStream.readByte();
            this.mClosed = n2 != 0;
            this.setInnerBox(this.mPoly);
            this.setX(this.getBBoxX());
            this.setY(this.getBBoxY());
        }
        this.recalc();
        return 1;
    }

    public void recalc() {
        if (this.getBBDirty()) {
            this.setInnerBox(this.mPoly);
        }
        if (this.getRotated()) {
            this.mPolyRotated = Convert.rotatePts(this.mPoly, this.getCenter(), this.getRotationAngle());
            this.setInnerBox(this.mPolyRotated);
        }
        this.setDirty(false);
    }

    @Override
    public boolean setX(int n) {
        int n2 = n - this.getBBoxX();
        if (n2 != 0) {
            int n3 = 0;
            while (n3 < this.mPoly.npoints) {
                int n4 = n3++;
                this.mPoly.xpoints[n4] = this.mPoly.xpoints[n4] + n;
            }
            this.setDirty(true);
            this.setBBDirty(true);
        }
        super.setX(n);
        return true;
    }

    @Override
    public boolean setY(int n) {
        int n2 = n - this.getBBoxY();
        if (n2 != 0) {
            int n3 = 0;
            while (n3 < this.mPoly.npoints) {
                int n4 = n3++;
                this.mPoly.ypoints[n4] = this.mPoly.ypoints[n4] + n;
            }
            this.setDirty(true);
            this.setBBDirty(true);
        }
        super.setY(n);
        return true;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
        super.listProperties(printStream, string);
    }

    @Override
    public void drawGraphic(Graphics graphics, Device device) {
        Polygon polygon = this.getRotated() ? this.mPolyRotated : this.mPoly;
        if (this.getDirty()) {
            this.recalc();
        }
        super.drawGraphic(graphics, device);
        Polygon polygon2 = this.getVisualPoly(polygon);
        VPolygon.drawPoly(graphics, polygon2, this.mClosed, device.getColorEntry(this.getForeFillColor()), device.getColorEntry(this.getBackFillColor()), device.getColorEntry(this.getForeEdgeColor()), device.getColorEntry(this.getBackEdgeColor()), this.getFillPattern(), this.getEdgePattern(), this.getBrushWidth(), this.mUseAntiAlias);
    }

    public static void drawPoly(Graphics graphics, Polygon polygon, boolean bl, Color color, Color color2, Color color3, Color color4, int n, int n2, int n3, boolean bl2) {
        int n4;
        Color color5 = graphics.getColor();
        if (bl2) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (n != 255) {
            graphics.setColor(n == 0 ? color2 : color);
            graphics.fillPolygon(polygon);
        }
        graphics.setColor(n2 != 255 ? color3 : color4);
        for (n4 = 0; n4 < polygon.npoints - 1; ++n4) {
            Graphic.drawLine(graphics, polygon.xpoints[n4], polygon.ypoints[n4], polygon.xpoints[n4 + 1], polygon.ypoints[n4 + 1], n3, true, bl2);
        }
        if (bl) {
            Graphic.drawLine(graphics, polygon.xpoints[n4], polygon.ypoints[n4], polygon.xpoints[0], polygon.ypoints[0], n3, true, bl2);
        }
        graphics.setColor(color5);
    }
}

