/*
 * Decompiled with CFR 0.152.
 */
package oracle.graphics.vgs.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import oracle.graphics.vgs.ui.Convert;
import oracle.graphics.vgs.ui.Device;
import oracle.graphics.vgs.ui.Generic;
import oracle.graphics.vgs.ui.PackedTree;

public class VGImage
extends Generic {
    private short mImageID;
    private Rectangle mClipRect;
    private boolean mClipEnabled;
    private int mScan;
    private int mRows;
    private short mQuality;
    private byte mDither;
    private Image mImage;
    private Image mOutImage;
    private boolean doubleDirty;

    public VGImage() {
        this.setClassType((byte)4);
        this.setClipEnabled(false);
        this.doubleDirty = false;
    }

    public VGImage(boolean bl) {
        this();
        this.mUseAntiAlias = bl;
    }

    public VGImage(boolean bl, boolean bl2) {
        this(bl);
        this.mHonorLineWidth = bl2;
    }

    @Override
    public int pUnpack(PackedTree packedTree, DataInputStream dataInputStream) throws IOException {
        super.pUnpack(packedTree, dataInputStream);
        this.mImageID = dataInputStream.readShort();
        int n = packedTree.getTransform().transformXValue(Convert.OracleIntToJava(dataInputStream));
        int n2 = packedTree.getTransform().transformYValue(Convert.OracleIntToJava(dataInputStream));
        int n3 = packedTree.getTransform().scaleXValue(Convert.OracleIntToJava(dataInputStream));
        int n4 = packedTree.getTransform().scaleYValue(Convert.OracleIntToJava(dataInputStream));
        this.mClipRect = new Rectangle(n, n2, n3, n4);
        this.setVGX(Convert.OracleIntToJava(dataInputStream));
        this.setVGY(Convert.OracleIntToJava(dataInputStream));
        this.setVGWidth(Convert.OracleIntToJava(dataInputStream));
        this.setVGHeight(Convert.OracleIntToJava(dataInputStream));
        if (this.mClipRect.width != this.getWidth() || this.mClipRect.height != this.getHeight() || this.mClipRect.x != 0 || this.mClipRect.y != 0) {
            this.setClipEnabled(true);
        }
        this.mQuality = dataInputStream.readShort();
        this.mDither = dataInputStream.readByte();
        this.setDirty(true);
        this.doubleDirty = true;
        return 1;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
        super.listProperties(printStream, string);
    }

    @Override
    public void drawGraphic(Graphics graphics, Device device) {
        Component component = device.getComponent();
        super.drawGraphic(graphics, device);
        if (this.getDirty()) {
            this.recalc(device);
        }
        int n = this.getVisualX(this.getX(), this.getWidth());
        if (this.mUseAntiAlias) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.mOutImage != null) {
            graphics.drawImage(this.mOutImage, n, this.getY(), this.mScan, this.mRows, component);
        }
    }

    public void recalc(Device device) {
        Component component = device.getComponent();
        if (this.getDirty()) {
            this.setDirty(false);
            this.mImage = device.getImageEntry(this.mImageID);
            if (this.getClipEnabled()) {
                this.mScan = this.mClipRect.width - this.mClipRect.x;
                this.mRows = this.mClipRect.height - this.mClipRect.y;
                CropImageFilter cropImageFilter = new CropImageFilter(this.mClipRect.x, this.mClipRect.y, this.mClipRect.width, this.mClipRect.height);
                FilteredImageSource filteredImageSource = new FilteredImageSource(this.mImage.getSource(), cropImageFilter);
                this.mOutImage = component.createImage(filteredImageSource);
            } else {
                this.mScan = this.getWidth();
                this.mRows = this.getHeight();
                this.mOutImage = this.mImage;
            }
        }
    }

    public void setClipEnabled(boolean bl) {
        this.mClipEnabled = bl;
    }

    public boolean getClipEnabled() {
        return this.mClipEnabled;
    }

    public void setClipRect(Rectangle rectangle) {
        this.mClipRect = rectangle;
    }

    public Rectangle getClipRect() {
        return this.mClipRect;
    }

    public void setImageID(int n) {
        this.mImageID = (short)n;
    }
}

