/*
 * Decompiled with CFR 0.152.
 */
package oracle.graphics.vgs.ui;

public class Transform {
    private int mClientY;
    private int mVGSY;
    private int mClientX;
    private int mVGSX;
    private int mScalingPower;
    private int mXOffset;
    private int mYOffset;

    public Transform() {
        this(1, 1, 1, 1);
    }

    public Transform(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 0, 0, 0);
    }

    public Transform(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.setClientXScale(n);
        this.setClientYScale(n2);
        this.setVGSXScale(n3);
        this.setVGSYScale(n4);
        this.setScalingPower(n5);
        this.setXOffset(n6);
        this.setYOffset(n7);
    }

    public void setClientXScale(int n) {
        this.mClientX = n;
    }

    public int getClientXScale() {
        return this.mClientX;
    }

    public void setClientYScale(int n) {
        this.mClientY = n;
    }

    public int getClientYScale() {
        return this.mClientY;
    }

    public void setVGSXScale(int n) {
        this.mVGSX = n;
    }

    public int getVGSXScale() {
        return this.mVGSX;
    }

    public void setVGSYScale(int n) {
        this.mVGSY = n;
    }

    public int getVGSYScale() {
        return this.mVGSY;
    }

    public void setScalingPower(int n) {
        this.mScalingPower = n;
    }

    public int getScalingPower() {
        return this.mScalingPower;
    }

    public void setXOffset(int n) {
        this.mXOffset = n;
    }

    public int getXOffset() {
        return this.mXOffset;
    }

    public void setYOffset(int n) {
        this.mYOffset = n;
    }

    public int getYOffset() {
        return this.mYOffset;
    }

    private static final int calculate(int n, int n2, int n3, int n4) {
        return Math.round((float)n2 / (float)n3 * (float)n) << n4;
    }

    public int scaleXValue(int n) {
        return Transform.calculate(n, this.getClientXScale(), this.getVGSXScale(), this.getScalingPower());
    }

    public int scaleYValue(int n) {
        return Transform.calculate(n, this.getClientYScale(), this.getVGSYScale(), this.getScalingPower());
    }

    public int undoXScale(int n) {
        return Transform.calculate(n, this.getVGSXScale(), this.getClientXScale(), this.getScalingPower() * -1);
    }

    public int undoYScale(int n) {
        return Transform.calculate(n, this.getVGSYScale(), this.getClientYScale(), this.getScalingPower() * -1);
    }

    public int transformXValue(int n) {
        return Transform.calculate(n, this.getClientXScale(), this.getVGSXScale(), this.getScalingPower()) + this.getXOffset();
    }

    public int transformYValue(int n) {
        return Transform.calculate(n, this.getClientYScale(), this.getVGSYScale(), this.getScalingPower()) + this.getYOffset();
    }

    public int undoXTransform(int n) {
        return Transform.calculate(n - this.getXOffset(), this.getVGSXScale(), this.getClientXScale(), this.getScalingPower() * -1);
    }

    public int undoYTransform(int n) {
        return Transform.calculate(n - this.getYOffset(), this.getVGSYScale(), this.getClientYScale(), this.getScalingPower() * -1);
    }
}

