/*
 * Decompiled with CFR 0.152.
 */
package oracle.graphics.vgs.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;
import oracle.forms.engine.FDataInputStream;
import oracle.graphics.vgs.ui.CompoundText;
import oracle.graphics.vgs.ui.Convert;
import oracle.graphics.vgs.ui.Device;
import oracle.graphics.vgs.ui.Graphic;
import oracle.graphics.vgs.ui.Group;
import oracle.graphics.vgs.ui.PackedTree;
import oracle.graphics.vgs.ui.Rect;
import oracle.graphics.vgs.ui.SimpleText;

public class Text
extends Graphic {
    static final byte HANCHOR_MASK = 3;
    static final byte VANCHOR_MASK = 12;
    static final byte VGOTHOJT = 48;
    static final byte VALIGN_MASK = -64;
    static final byte ANCHOR_LEFT = 0;
    static final byte ANCHOR_CENTER = 1;
    static final byte ANCHOR_RIGHT = 2;
    static final byte ANCHOR_BOTTOM = 0;
    static final byte ANCHOR_MIDDLE = 4;
    static final byte ANCHOR_TOP = 8;
    static final byte ALIGN_TOP = 0;
    static final byte ALIGN_MIDDLE = 64;
    static final byte ALIGN_BOTTOM = -128;
    static final byte SPACING_MASK = 3;
    static final byte DIRECTION_MASK = 12;
    static final byte HORIZ_ALIGN_MASK = 112;
    static final byte SINGLE = 0;
    static final byte ONE_AND_HALF = 1;
    static final byte DOUBLE = 2;
    static final byte CUSTOM = 3;
    static final byte VGOTDEDR = 0;
    static final byte VGOTLRDR = 4;
    static final byte VGOTRLDR = 8;
    static final byte ALIGN_LEFT = 0;
    static final byte ALIGN_CENTER = 16;
    static final byte ALIGN_RIGHT = 32;
    static final byte ALIGN_START = 48;
    static final byte ALIGN_END = 64;
    static final byte VGOTFIXD = 1;
    static final byte VGOTWRAP = 2;
    static final byte VGOTBSCA = 4;
    static final byte VGOTFSCA = 8;
    static final byte VGOTINVI = 16;
    static final int VAL_NOT_INITIALIZED = -1;
    static final int USE_CURRENT_VAL = -2;
    static final int VAL_SET_PER_STRING = -3;
    private CompoundText[] mTextLines;
    private Rectangle mClipRect;
    private int mFixedBoxW;
    private int mFixedBoxH;
    private int mBoxWidth;
    private int mBoxHeight;
    private int mCustomSpacing;
    private double mLineSpacing;
    private byte mDeviceDirection = 1;
    private byte mRawAlign;
    private byte mRawTextDirection;
    private byte mAlign;
    private byte mTextDirection;
    private byte mHAnchor;
    private byte mVAnchor;
    private byte mVJustify;
    private int mYAdj;
    private boolean mFixed;
    private boolean mFontScaled;
    boolean mBoxScaled;
    boolean mInvisibleText;
    private boolean mClipped;
    private int mDescent;
    private int mSpaceAfterLine;
    private int mFontNum;
    private int mColorNum;
    private String mFontName;
    private int mFontSize;
    private int mFontStyle;
    private int mTextColor;
    private int mXDrawPos;
    private int mYDrawPos;
    private boolean mDirtyLayout;
    private Image mResultImage;

    public Text() {
        this.setClassType((byte)9);
        this.mClipRect = new Rectangle();
        this.mInvisibleText = false;
        this.mBoxScaled = false;
        this.mClipped = false;
        this.mFontScaled = false;
        this.mFixed = false;
        this.mAlign = 0;
        this.mTextDirection = 0;
        this.mFixedBoxH = 0;
        this.mFixedBoxW = 0;
        this.mLineSpacing = 0.0;
        this.setLayoutDirty(false);
    }

    public Text(boolean bl) {
        this();
        this.mUseAntiAlias = bl;
    }

    public Text(boolean bl, boolean bl2) {
        this(bl);
        this.mHonorLineWidth = bl2;
    }

    @Override
    public int pUnpack(PackedTree packedTree, DataInputStream dataInputStream) throws IOException {
        super.pUnpack(packedTree, dataInputStream);
        byte by = (byte)dataInputStream.readUnsignedByte();
        if ((by & 1) == 0) {
            this.setVGX(Convert.OracleIntToJava(dataInputStream));
        } else {
            this.setVGX(Convert.OracleShortToJava(dataInputStream));
        }
        if ((by & 2) == 0) {
            this.setVGY(Convert.OracleIntToJava(dataInputStream));
        } else {
            this.setVGY(Convert.OracleShortToJava(dataInputStream));
        }
        int n = (by & 4) != 0 ? (int)dataInputStream.readByte() : 48;
        this.mRawTextDirection = (byte)(n & 0xC);
        this.mRawAlign = (byte)(n & 0x70);
        this.updateDeviceDirection(this.mDeviceDirection);
        byte by2 = (byte)(n & 3);
        this.mCustomSpacing = (by & 8) != 0 ? packedTree.getTransform().scaleYValue(Convert.OracleIntToJava(dataInputStream)) : 0;
        switch (by2) {
            case 0: {
                this.mLineSpacing = 1.0;
                break;
            }
            case 1: {
                this.mLineSpacing = 1.5;
                break;
            }
            case 2: {
                this.mLineSpacing = 2.0;
                break;
            }
            case 3: {
                this.mLineSpacing = 0.0;
                break;
            }
            default: {
                this.mLineSpacing = 1.0;
                by2 = 0;
            }
        }
        if ((by & 0x10) != 0) {
            this.setFixedBoxWidth(packedTree.getTransform().scaleXValue(Convert.OracleIntToJava(dataInputStream)));
        } else {
            this.setFixedBoxWidth(packedTree.getTransform().scaleXValue(Convert.OracleShortToJava(dataInputStream)));
        }
        if ((by & 0x20) != 0) {
            this.setFixedBoxHeight(packedTree.getTransform().scaleYValue(Convert.OracleIntToJava(dataInputStream)));
        } else {
            this.setFixedBoxHeight(packedTree.getTransform().scaleYValue(Convert.OracleShortToJava(dataInputStream)));
        }
        int n2 = (by & 0x40) != 0 ? (int)dataInputStream.readByte() : 6;
        if ((n2 & 1) != 0) {
            this.setBBoxEnabled(true);
        } else {
            this.setBBoxEnabled(false);
            this.setFixedBoxWidth(0);
            this.setFixedBoxHeight(0);
        }
        this.mFontScaled = (n2 & 8) != 0;
        this.mBoxScaled = (n2 & 4) != 0;
        this.mInvisibleText = (n2 & 0x10) != 0;
        n = (by & 0x80) != 0 ? (int)dataInputStream.readByte() : 56;
        this.setHAlign((byte)(n & 3));
        this.setVAlign((byte)(n & 0xC));
        this.setVJustify((byte)(n & 0xFFFFFFC0));
        int n3 = dataInputStream.readByte();
        if (n3 == 255) {
            n3 = dataInputStream.readInt();
        }
        this.mTextLines = new CompoundText[n3];
        int n4 = dataInputStream.readInt();
        int n5 = packedTree.getVersion();
        if (n5 >= 66666666) {
            // empty if block
        }
        if (n3 > 0) {
            DataInputStream dataInputStream2 = packedTree.getStream(n4);
            int n6 = 0;
            for (int i = 0; i < n3; ++i) {
                int n7 = dataInputStream2.readByte();
                int n8 = dataInputStream2.readInt();
                if (n7 > 0) {
                    CompoundText compoundText = new CompoundText();
                    compoundText.strings = new SimpleText[n7];
                    int n9 = 0;
                    DataInputStream dataInputStream3 = packedTree.pushStream(n8);
                    for (int j = 0; j < n7; ++j) {
                        short s = dataInputStream3.readShort();
                        int n10 = dataInputStream3.readInt();
                        if (s != 0) {
                            DataInputStream dataInputStream4 = packedTree.pushStream(n10);
                            SimpleText simpleText = new SimpleText();
                            if (n5 >= 50342914 || n5 >= 20111 && n5 < 30000) {
                                simpleText.textString = FDataInputStream.readUTF(dataInputStream4);
                            } else {
                                byte[] byArray = new byte[s];
                                dataInputStream4.read(byArray);
                                simpleText.textString = new String(byArray, "UTF8");
                            }
                            if (simpleText.textString.endsWith("\n")) {
                                simpleText.textString = simpleText.textString.substring(0, simpleText.textString.length() - 1);
                            }
                            dataInputStream3 = packedTree.popStream();
                            simpleText.fontNum = dataInputStream3.readShort();
                            simpleText.colorNum = (short)dataInputStream3.readUnsignedByte();
                            compoundText.strings[n9++] = simpleText;
                            continue;
                        }
                        short s2 = dataInputStream3.readShort();
                        byte by3 = dataInputStream3.readByte();
                    }
                    if (n9 != 0) {
                        if (n9 < n7) {
                            SimpleText[] simpleTextArray = new SimpleText[n9];
                            System.arraycopy(compoundText.strings, 0, simpleTextArray, 0, n9);
                            compoundText.strings = simpleTextArray;
                        }
                        this.mTextLines[n6++] = compoundText;
                    }
                }
                dataInputStream2 = packedTree.popStream();
            }
            if (n6 != n3) {
                CompoundText[] compoundTextArray = new CompoundText[n6];
                System.arraycopy(this.mTextLines, 0, compoundTextArray, 0, n6);
                this.mTextLines = compoundTextArray;
            }
            this.setDirty(true);
        }
        return 1;
    }

    @Override
    public void drawGraphic(Graphics graphics, Device device) {
        super.drawGraphic(graphics, device);
        if (this.mDeviceDirection != Group.getDeviceDirection()) {
            this.updateDeviceDirection(Group.getDeviceDirection());
        }
        if (this.getDirty()) {
            this.recalc(graphics, device);
        }
        if (this.isLayoutDirty()) {
            this.recalcTextLayout(graphics, device);
            this.updateHAlignOffset();
            this.updateVAlignOffset();
        }
        int n = this.mXDrawPos;
        Rectangle rectangle = new Rectangle(this.mClipRect);
        if (this.mDeviceDirection == 2) {
            n = Group.getDeviceWidth() - this.getBBoxWidth() - n;
        }
        if (!this.getRotated()) {
            if (this.isBBoxEnabled() && this.getBoxScaleEnabled()) {
                Rect.drawRectangle(graphics, n + rectangle.x, this.mYDrawPos + rectangle.y, this.getFixedBoxWidth(), this.getFixedBoxHeight(), device.getColorEntry(this.getForeFillColor()), device.getColorEntry(this.getBackFillColor()), device.getColorEntry(this.getForeEdgeColor()), device.getColorEntry(this.getBackEdgeColor()), this.getFillPattern(), this.getEdgePattern(), this.getLineBevel(), 0, this.getBrushWidth(), this.mUseAntiAlias);
            }
            if (this.mClipped) {
                Graphics graphics2 = graphics.create(n, this.mYDrawPos, this.mBoxWidth, this.mBoxHeight);
                graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.drawText(graphics2, device, 0, 0);
            } else {
                this.drawText(graphics, device, n, this.mYDrawPos);
            }
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            if (this.mUseAntiAlias) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n, this.mYDrawPos);
            affineTransform.rotate(Math.toRadians(this.mRotationInDegrees), this.getWidth() / 2, this.getHeight() / 2);
            graphics2D.drawImage(this.mResultImage, affineTransform, device.getComponent());
        }
    }

    public void drawText(Graphics graphics, Device device, int n, int n2) {
        block14: {
            int n3;
            int n4;
            if (this.mUseAntiAlias) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (this.getRotated()) {
                n4 = this.getWidth();
                n3 = this.getHeight();
            } else {
                n4 = this.getBBoxWidth();
                n3 = this.getBBoxHeight();
            }
            Rect.drawRectangle(graphics, n, n2, n4, n3, device.getColorEntry(this.getForeFillColor()), device.getColorEntry(this.getBackFillColor()), device.getColorEntry(this.getForeEdgeColor()), device.getColorEntry(this.getBackEdgeColor()), this.getFillPattern(), this.getEdgePattern(), this.getLineBevel(), 0, this.getBrushWidth(), this.mUseAntiAlias);
            if (this.mInvisibleText) break block14;
            graphics.setColor(device.getColorEntry(this.mTextColor));
            Rectangle rectangle = graphics.getClipBounds();
            if (this.mFontNum != -3 && this.mColorNum != -3 && this.mFontNum > 0) {
                graphics.setFont(device.getFontEntry(this.mFontNum));
                graphics.setColor(device.getColorEntry(this.mColorNum));
                this.mFontStyle = device.getStyle(this.mFontNum);
                for (int i = 0; i < this.mTextLines.length; ++i) {
                    CompoundText compoundText = this.mTextLines[i];
                    if (rectangle != null && (n + compoundText.lineWidth <= 0 || n2 + compoundText.lineHeight <= 0 || n + compoundText.lineWidth < rectangle.x || n > rectangle.x + rectangle.width || n2 + compoundText.lineHeight < rectangle.y || n2 > rectangle.y + rectangle.height)) continue;
                    for (int j = 0; j < compoundText.strings.length; ++j) {
                        SimpleText simpleText = compoundText.strings[j];
                        if (rectangle != null && n + simpleText.XPos >= rectangle.x + rectangle.width) continue;
                        this.updateVJustify(compoundText.lineHeight);
                        GraphicUtils.drawString(graphics, simpleText.visualString, n + simpleText.XPos, n2 + compoundText.lineHeight + this.mYAdj - compoundText.descent);
                        Text.drawUnderlineOverstrike(graphics, simpleText.visualString, n + simpleText.XPos, n2 + compoundText.lineHeight + this.mYAdj - compoundText.descent, this.mFontStyle);
                    }
                }
            } else {
                graphics.setColor(device.getColorEntry(this.mTextColor));
                for (int i = 0; i < this.mTextLines.length; ++i) {
                    SimpleText simpleText;
                    int n5;
                    CompoundText compoundText = this.mTextLines[i];
                    if (rectangle != null && (n + compoundText.lineWidth <= 0 || n2 + compoundText.lineHeight <= 0 || n + compoundText.lineWidth < rectangle.x || n > rectangle.x + rectangle.width || n2 + compoundText.lineHeight < rectangle.y || n2 > rectangle.y + rectangle.height)) {
                        for (n5 = 0; n5 < compoundText.strings.length; ++n5) {
                            simpleText = compoundText.strings[n5];
                            if (simpleText.fontNum != -2) {
                                graphics.setFont(device.getFontEntry(simpleText.fontNum));
                                this.mFontStyle = device.getStyle(simpleText.fontNum);
                            }
                            if (simpleText.colorNum == -2) continue;
                            graphics.setColor(device.getColorEntry(simpleText.colorNum));
                        }
                        continue;
                    }
                    for (n5 = 0; n5 < compoundText.strings.length; ++n5) {
                        simpleText = compoundText.strings[n5];
                        if (simpleText.fontNum != -2) {
                            graphics.setFont(device.getFontEntry(simpleText.fontNum));
                            this.mFontStyle = device.getStyle(simpleText.fontNum);
                        }
                        if (simpleText.colorNum != -2) {
                            graphics.setColor(device.getColorEntry(simpleText.colorNum));
                        }
                        if (rectangle != null && n + simpleText.XPos >= rectangle.x + rectangle.width) continue;
                        this.updateVJustify(compoundText.lineHeight);
                        GraphicUtils.drawString(graphics, simpleText.visualString, n + simpleText.XPos, n2 + compoundText.lineHeight + this.mYAdj - compoundText.descent);
                        Text.drawUnderlineOverstrike(graphics, simpleText.visualString, n + simpleText.XPos, n2 + compoundText.lineHeight + this.mYAdj - compoundText.descent, this.mFontStyle);
                    }
                }
            }
        }
    }

    public synchronized void recalc(Graphics graphics, Device device) {
        this.mBoxWidth = 0;
        this.mBoxHeight = 0;
        if (this.mTextLines != null) {
            int n;
            int n2;
            Component component = device.getComponent();
            short s = -1;
            this.mFontNum = -1;
            short s2 = -1;
            this.mColorNum = -1;
            FontMetrics fontMetrics = graphics.getFontMetrics(device.getFontEntry(0));
            int n3 = this.mTextDirection == 2 ? 2 : 1;
            Locale locale = LocaleUtils.getDefaultableLocale(component);
            for (n2 = 0; n2 < this.mTextLines.length; ++n2) {
                CompoundText compoundText = this.mTextLines[n2];
                compoundText.lineWidth = 0;
                compoundText.lineHeight = 0;
                for (int i = 0; i < compoundText.strings.length; ++i) {
                    SimpleText simpleText = compoundText.strings[i];
                    if (simpleText.fontNum != s2) {
                        s2 = simpleText.fontNum;
                        this.mFontNum = this.mFontNum == -1 ? (int)s2 : -3;
                        fontMetrics = graphics.getFontMetrics(device.getFontEntry(simpleText.fontNum));
                        n = fontMetrics.getHeight();
                        if (n > compoundText.lineHeight) {
                            compoundText.lineHeight = n;
                            compoundText.descent = fontMetrics.getDescent();
                        }
                    } else {
                        simpleText.fontNum = (short)-2;
                    }
                    simpleText.XPos = compoundText.lineWidth;
                    simpleText.visualString = StringUtils.getDisplayString(simpleText.textString, locale, n3);
                    compoundText.lineWidth += fontMetrics.stringWidth(simpleText.visualString);
                    if (simpleText.colorNum != s) {
                        s = simpleText.colorNum;
                        if (this.mColorNum == -1) {
                            this.mColorNum = s;
                            continue;
                        }
                        this.mColorNum = -3;
                        continue;
                    }
                    simpleText.colorNum = (short)-2;
                }
                if (compoundText.lineHeight == 0) {
                    compoundText.lineHeight = fontMetrics.getHeight();
                    compoundText.descent = fontMetrics.getDescent();
                }
                if (this.mLineSpacing != 0.0) {
                    this.mBoxHeight += (int)((double)compoundText.lineHeight * this.mLineSpacing);
                    compoundText.spaceAfterLine = (int)((double)compoundText.lineHeight * (this.mLineSpacing - 1.0));
                } else {
                    this.mBoxHeight += this.mCustomSpacing + compoundText.lineHeight;
                    compoundText.spaceAfterLine = this.mCustomSpacing;
                }
                compoundText.lineHeight = this.mBoxHeight - compoundText.spaceAfterLine;
                if (this.mBoxWidth >= compoundText.lineWidth) continue;
                this.mBoxWidth = compoundText.lineWidth;
            }
            for (n2 = 0; n2 < this.mTextLines.length; ++n2) {
                int n4;
                CompoundText compoundText = this.mTextLines[n2];
                int n5 = compoundText.lineWidth;
                switch (this.mAlign) {
                    case 0: {
                        n4 = 0;
                        break;
                    }
                    case 16: {
                        if (this.mFixedBoxW > this.mBoxWidth) {
                            n4 = this.mFixedBoxW - n5 >> 1;
                            break;
                        }
                        n4 = this.mBoxWidth - n5 >> 1;
                        break;
                    }
                    case 32: {
                        if (this.mFixedBoxW > this.mBoxWidth) {
                            n4 = this.mFixedBoxW - n5;
                            break;
                        }
                        n4 = this.mBoxWidth - n5;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected Align setting " + this.mAlign);
                    }
                }
                if (n4 == 0) continue;
                for (n = 0; n < compoundText.strings.length; ++n) {
                    compoundText.strings[n].XPos += n4;
                }
            }
        }
        super.setWidth(this.mBoxWidth);
        super.setHeight(this.mBoxHeight);
        this.setLayoutDirty(true);
        this.setDirty(false);
    }

    public void recalcTextLayout(Graphics graphics, Device device) {
        this.setInnerBox(this.getX(), this.getY(), this.mBoxWidth, this.mBoxHeight);
        if (this.isBBoxEnabled()) {
            this.setClip();
            if (this.mBoxScaled) {
                this.setBoxScale();
            }
        }
        if (this.getRotated()) {
            this.text2Image(graphics, device);
        } else {
            this.setInnerBox(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        this.setLayoutDirty(false);
    }

    public void updateVJustify(int n) {
        this.mYAdj = 0;
        if (this.getRotated() && this.mRotationInDegrees != 0) {
            return;
        }
        switch (this.mVJustify) {
            case 0: {
                break;
            }
            case 64: {
                this.mYAdj = this.getBBoxHeight() / 2 - n / 2;
                break;
            }
            case -128: {
                this.mYAdj = this.getBBoxHeight() - n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected vAlign setting " + this.mVJustify);
            }
        }
    }

    public void updateVAlignOffset() {
        this.mYDrawPos = this.getBBoxY();
        switch (this.mVAnchor) {
            case 8: {
                if (!this.getRotated() || this.mRotationInDegrees % 180 <= 10 || this.mRotationInDegrees % 180 >= 170) break;
                if (this.mRotationInDegrees % 90 < 10 || this.mRotationInDegrees % 90 > 80) {
                    this.mYDrawPos -= this.getBBoxWidth() / 2 - this.getBBoxHeight() / 2;
                    break;
                }
                this.mYDrawPos += this.getBBoxHeight() / 2 - this.getHeight() / 2;
                break;
            }
            case 4: {
                if (this.getRotated() && this.mRotationInDegrees % 180 > 10 && this.mRotationInDegrees % 180 < 170) {
                    if (this.mRotationInDegrees % 90 < 10 || this.mRotationInDegrees % 90 > 80) {
                        this.mYDrawPos -= this.getBBoxWidth() / 2 - this.getBBoxHeight() / 2 + this.getHeight() / 2;
                        break;
                    }
                    this.mYDrawPos += this.getBBoxHeight() / 2 - this.getHeight();
                    break;
                }
                this.mYDrawPos -= this.getBBoxHeight() >> 1;
                break;
            }
            case 0: {
                if (this.getRotated() && this.mRotationInDegrees % 180 > 10 && this.mRotationInDegrees % 180 < 170) {
                    if (this.mRotationInDegrees % 90 < 10 || this.mRotationInDegrees % 90 > 80) {
                        this.mYDrawPos -= this.getBBoxWidth() / 2 - this.getBBoxHeight() / 2 + this.getHeight();
                        break;
                    }
                    this.mYDrawPos += this.getBBoxHeight() / 2 - this.getHeight() / 2 * 3;
                    break;
                }
                this.mYDrawPos -= this.getBBoxHeight();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected vAnchor setting " + this.mVAnchor);
            }
        }
    }

    public int updateHAlignOffset() {
        this.mXDrawPos = this.getBBoxX();
        switch (this.mHAnchor) {
            case 0: {
                if (!this.getRotated() || this.mRotationInDegrees % 180 <= 10 || this.mRotationInDegrees % 180 >= 170) break;
                if (this.mRotationInDegrees % 90 < 10 || this.mRotationInDegrees % 90 > 80) {
                    this.mXDrawPos -= this.getBBoxHeight() / 2 - this.getHeight() / 2;
                    break;
                }
                this.mXDrawPos -= this.getWidth() / 2 - this.getBBoxWidth() / 2;
                break;
            }
            case 1: {
                if (this.getRotated() && this.mRotationInDegrees % 180 > 10 && this.mRotationInDegrees % 180 < 170) {
                    if (this.mRotationInDegrees % 90 < 10 || this.mRotationInDegrees % 90 > 80) {
                        this.mXDrawPos -= this.getBBoxHeight() - this.getHeight() / 2;
                        break;
                    }
                    this.mXDrawPos -= this.getWidth() - this.getBBoxWidth() / 2;
                    break;
                }
                this.mXDrawPos -= this.getBBoxWidth() >> 1;
                break;
            }
            case 2: {
                if (this.getRotated() && this.mRotationInDegrees % 180 > 10 && this.mRotationInDegrees % 180 < 170) {
                    if (this.mRotationInDegrees % 90 < 10 || this.mRotationInDegrees % 90 > 80) {
                        this.mXDrawPos -= this.getBBoxHeight() / 2 * 3 - this.getHeight() / 2;
                        break;
                    }
                    this.mXDrawPos -= this.getWidth() / 2 * 3 - this.getBBoxWidth() / 2;
                    break;
                }
                this.mXDrawPos -= this.getBBoxWidth();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected anchor setting " + this.mHAnchor);
            }
        }
        return this.mXDrawPos;
    }

    public boolean setVJustify(byte by) {
        boolean bl;
        switch (by) {
            case -128: 
            case 0: 
            case 64: {
                this.mVJustify = by;
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean setVAlign(byte by) {
        boolean bl;
        switch (by) {
            case 0: 
            case 4: 
            case 8: {
                this.mVAnchor = by;
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public byte getVAlign() {
        return this.mVAnchor;
    }

    public boolean setHAlign(byte by) {
        boolean bl;
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                this.mHAnchor = by;
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public byte getHAlign() {
        return this.mHAnchor;
    }

    private boolean text2Image(Graphics graphics, Device device) {
        Component component = device.getComponent();
        if (this.getRotated()) {
            Image image;
            Polygon polygon = new Polygon();
            double d = this.getRotationAngle();
            int n = this.mRotationInDegrees;
            if (this.mDeviceDirection == 2) {
                d = -d;
                n = -n;
            }
            Color color = component.getBackground();
            if (this.getFillPattern() == 255) {
                int n2 = color.getRGB();
                boolean bl = true;
            } else {
                boolean bl = false;
                boolean bl2 = false;
            }
            this.setInnerBox(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            Polygon polygon2 = Convert.rotateRect(this.getInnerBox(), this.getCenter(), d);
            Rectangle rectangle = polygon2.getBounds();
            this.setInnerBox(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Image image2 = device.createImage(this.getWidth() + 1, this.getHeight() + 1);
            Graphics graphics2 = image2.getGraphics();
            graphics2.setColor(color);
            if (this.getFillPattern() == 255) {
                graphics2.fillRect(0, 0, this.getWidth() + 1, this.getHeight() + 1);
                this.drawText(graphics2, device, 0, 0);
                graphics2.setColor(color);
                graphics2.fillRect(0, 0, 1, 1);
            }
            this.drawText(graphics2, device, 0, 0);
            if (this.mClipped) {
                CropImageFilter cropImageFilter = new CropImageFilter(this.mClipRect.x, this.mClipRect.y, this.mClipRect.width, this.mClipRect.height);
                FilteredImageSource filteredImageSource = new FilteredImageSource(image2.getSource(), cropImageFilter);
                image = device.createImage(filteredImageSource);
            } else {
                image = image2;
            }
            this.mResultImage = image;
            return true;
        }
        return false;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    public void setBBoxEnabled(boolean bl) {
        this.mFixed = bl;
    }

    public boolean isBBoxEnabled() {
        return this.mFixed;
    }

    public void setFixedBoxWidth(int n) {
        this.mFixedBoxW = n;
    }

    public void setFixedBoxHeight(int n) {
        this.mFixedBoxH = n;
    }

    public int getFixedBoxWidth() {
        return this.mFixedBoxW;
    }

    public int getFixedBoxHeight() {
        return this.mFixedBoxH;
    }

    public void setBoxScaleEnabled(boolean bl) {
        this.mBoxScaled = bl;
    }

    public boolean getBoxScaleEnabled() {
        return this.mBoxScaled;
    }

    public void setInvisibleText(boolean bl) {
        this.mInvisibleText = bl;
    }

    public boolean isTextInvisible() {
        return this.mInvisibleText;
    }

    @Override
    public boolean setWidth(int n) {
        return false;
    }

    @Override
    public boolean setHeight(int n) {
        return false;
    }

    public void setLayoutDirty(boolean bl) {
        this.mDirtyLayout = bl;
    }

    public boolean isLayoutDirty() {
        return this.mDirtyLayout;
    }

    private boolean setClip() {
        if (this.isBBoxEnabled() && !this.mFontScaled) {
            int n = this.getFixedBoxWidth();
            int n2 = this.getFixedBoxHeight();
            this.mClipped = true;
            if (n > this.mBoxWidth) {
                n = this.mBoxWidth;
            }
            if (n2 > this.mBoxHeight) {
                if (n == this.mBoxWidth) {
                    this.mClipped = false;
                } else {
                    n2 = this.mBoxHeight;
                }
            }
            if (this.mAlign == 0) {
                this.mClipRect.x = 0;
            } else {
                int n3 = this.mBoxWidth - n;
                if (this.mAlign == 16) {
                    n3 /= 2;
                }
                this.mClipRect.x = n3;
            }
            this.mClipRect.y = 0;
            this.mClipRect.width = n;
            this.mClipRect.height = n2;
            return this.mClipped;
        }
        return false;
    }

    private boolean setBoxScale() {
        int n = this.getFixedBoxWidth();
        int n2 = this.getFixedBoxHeight();
        if (this.isBBoxEnabled() && this.mBoxScaled && (n > this.mBoxWidth || n2 > this.mBoxHeight)) {
            if (n < this.mBoxWidth) {
                super.setWidth(this.mBoxWidth);
            } else {
                super.setWidth(n);
            }
            if (n2 < this.mBoxHeight) {
                super.setHeight(this.mBoxHeight);
            } else {
                super.setHeight(n2);
            }
            return true;
        }
        return false;
    }

    private void updateDeviceDirection(byte by) {
        this.mDeviceDirection = by;
        this.mTextDirection = this.mRawTextDirection == 0 ? this.mDeviceDirection : (byte)(this.mRawTextDirection == 8 ? 2 : 1);
        this.mAlign = this.mRawAlign == 48 ? (this.mTextDirection == 2 ? (byte)32 : (byte)0) : (this.mRawAlign == 64 ? (this.mTextDirection == 2 ? (byte)0 : (byte)32) : this.mRawAlign);
        this.setDirty(true);
    }

    public static void drawUnderlineOverstrike(Graphics graphics, String string, int n, int n2, int n3) {
        boolean bl;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n4 = fontMetrics.stringWidth(string);
        int n5 = fontMetrics.getHeight();
        boolean bl2 = bl = !System.getProperty("java.version").startsWith("1.1") && !System.getProperty("java.version").startsWith("1.2") && !System.getProperty("java.version").startsWith("1.3");
        if (bl) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            float f = (float)((double)graphics.getFont().getSize() / 10.0);
            BasicStroke basicStroke = (BasicStroke)graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(f));
            if (n3 == 4) {
                graphics2D.drawLine(n, n2 + 1, n + n4, n2 + 1);
            } else if (n3 == 64) {
                graphics2D.drawLine(n, n2 - n5 / 4, n + n4, n2 - n5 / 4);
            }
            graphics2D.setStroke(basicStroke);
        } else if (n3 == 4) {
            graphics.drawLine(n, n2 + 1, n + n4, n2 + 1);
        } else if (n3 == 64) {
            graphics.drawLine(n, n2 - n5 / 4, n + n4, n2 - n5 / 4);
        }
    }

    public void resetColor(short s) {
        for (int i = 0; i < this.mTextLines.length; ++i) {
            CompoundText compoundText = this.mTextLines[i];
            for (int j = 0; j < compoundText.strings.length; ++j) {
                SimpleText simpleText = compoundText.strings[j];
                simpleText.colorNum = s;
            }
        }
    }
}

