/*
 * Decompiled with CFR 0.152.
 */
package oracle.graphics.vgs.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import oracle.graphics.vgs.ui.Convert;
import oracle.graphics.vgs.ui.Device;
import oracle.graphics.vgs.ui.Graphic;
import oracle.graphics.vgs.ui.PackedTree;
import oracle.graphics.vgs.ui.VGIcons;

public class Symbol
extends Graphic {
    protected byte mSymbolID;
    protected Point mSymbolCenter;
    protected byte mSymbolType;
    protected int mScale;

    public Symbol() {
        this.setClassType((byte)10);
    }

    public Symbol(boolean bl) {
        this();
        this.mUseAntiAlias = bl;
    }

    public Symbol(boolean bl, boolean bl2) {
        this(bl);
        this.mHonorLineWidth = bl2;
    }

    @Override
    public int pUnpack(PackedTree packedTree, DataInputStream dataInputStream) throws IOException {
        super.pUnpack(packedTree, dataInputStream);
        int n = packedTree.getTransform().transformXValue(Convert.OracleIntToJava(dataInputStream));
        int n2 = packedTree.getTransform().transformYValue(Convert.OracleIntToJava(dataInputStream));
        this.mScale = packedTree.getTransform().getScalingPower();
        this.setSymbolCenter(new Point(n, n2));
        this.setSymbolID(dataInputStream.readByte());
        this.setSymbolType(dataInputStream.readByte());
        this.setDirty(true);
        return 1;
    }

    public void recalc() {
        switch (this.getSymbolType()) {
            case 1: {
                this.setWidth(32);
                this.setHeight(32);
                break;
            }
            case 2: {
                this.setWidth(18);
                this.setHeight(18);
                break;
            }
            case 3: {
                this.setWidth(12);
                this.setHeight(12);
                break;
            }
        }
        if (this.mScale != 0) {
            if (this.mScale == 1) {
                this.setWidth(this.getWidth() * 2);
                this.setHeight(this.getHeight() * 2);
            } else {
                this.setWidth(this.getWidth() / 2);
                this.setHeight(this.getHeight() / 2);
            }
        }
        Point point = this.getSymbolCenter();
        this.setX(point.x - this.getWidth() / 2);
        this.setY(point.y - this.getHeight() / 2);
        this.setInnerBox(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.setDirty(false);
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
        super.listProperties(printStream, string);
    }

    @Override
    public void drawGraphic(Graphics graphics, Device device) {
        super.drawGraphic(graphics, device);
        if (this.getDirty()) {
            this.recalc();
        }
        int n = this.getVisualX(this.getX(), this.getWidth());
        if (this.mUseAntiAlias) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        Color color = device.getColorEntry(this.getForeFillColor());
        Color color2 = device.getColorEntry(this.getBackFillColor());
        Image image = VGIcons.getIcon(this.getSymbolID(), device, color, color2);
        graphics.drawImage(image, n, this.getY(), this.getWidth(), this.getHeight(), device.getComponent());
    }

    public boolean setSymbolID(byte by) {
        this.mSymbolID = by;
        return true;
    }

    public byte getSymbolID() {
        return this.mSymbolID;
    }

    public boolean setSymbolCenter(Point point) {
        this.mSymbolCenter = point;
        return true;
    }

    public Point getSymbolCenter() {
        return this.mSymbolCenter;
    }

    public boolean setSymbolType(byte by) {
        this.mSymbolType = by;
        return true;
    }

    public byte getSymbolType() {
        return this.mSymbolType;
    }
}

