/*
 * Decompiled with CFR 0.152.
 */
package oracle.graphics.vgs.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import oracle.graphics.vgs.ui.Arc;
import oracle.graphics.vgs.ui.Convert;
import oracle.graphics.vgs.ui.Device;
import oracle.graphics.vgs.ui.Graphic;
import oracle.graphics.vgs.ui.PackedTree;
import oracle.graphics.vgs.ui.VPolygon;

public class RoundRect
extends Graphic {
    private int vgXRadius;
    private int mXRadius;
    private int vgYRadius;
    private int mYRadius;
    private Rectangle baseRectangle;
    private Polygon mPoly;

    public RoundRect() {
        this.setClassType((byte)6);
        this.mYRadius = 0;
        this.vgYRadius = 0;
        this.mXRadius = 0;
        this.vgXRadius = 0;
        this.baseRectangle = new Rectangle();
    }

    public RoundRect(boolean bl) {
        this();
        this.mUseAntiAlias = bl;
    }

    public RoundRect(boolean bl, boolean bl2) {
        this(bl);
        this.mHonorLineWidth = bl2;
    }

    @Override
    public int pUnpack(PackedTree packedTree, DataInputStream dataInputStream) throws IOException {
        super.pUnpack(packedTree, dataInputStream);
        this.setVGX(Convert.OracleIntToJava(dataInputStream));
        this.setVGY(Convert.OracleIntToJava(dataInputStream));
        this.setVGWidth(Convert.OracleIntToJava(dataInputStream));
        this.setVGHeight(Convert.OracleIntToJava(dataInputStream));
        this.vgXRadius = Convert.OracleIntToJava(dataInputStream);
        this.mXRadius = this.mTransform.scaleXValue(this.vgXRadius);
        this.vgYRadius = Convert.OracleIntToJava(dataInputStream);
        this.mYRadius = this.mTransform.scaleYValue(this.vgYRadius);
        this.setInnerBox(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.recalc();
        return 1;
    }

    public void recalc() {
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        this.baseRectangle = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.mPoly = new Polygon();
        Polygon[] polygonArray = new Polygon[4];
        polygonArray[0] = new Polygon();
        polygonArray[0] = Arc.toPoly(polygonArray[0], n + n3 - this.mXRadius * 2, n2 + n4 - this.mYRadius * 2, this.vgXRadius * 2, this.vgYRadius * 2, 0, 5760, false, true, this.mTransform);
        polygonArray[1] = Convert.mirrorInX(polygonArray[0], n + n3 / 2);
        polygonArray[2] = Convert.mirrorInY(polygonArray[1], n2 + n4 / 2);
        polygonArray[3] = Convert.mirrorInY(polygonArray[0], n2 + n4 / 2);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < polygonArray[i].npoints; ++j) {
                this.mPoly.addPoint(polygonArray[i].xpoints[j], polygonArray[i].ypoints[j]);
            }
        }
        if (this.getRotated()) {
            this.mPoly = Convert.rotatePts(this.mPoly, this.getCenter(), this.getRotationAngle());
        }
    }

    @Override
    public void drawGraphic(Graphics graphics, Device device) {
        super.drawGraphic(graphics, device);
        int n = this.getVisualX(this.getX(), this.getWidth());
        Polygon polygon = this.getVisualPoly(this.mPoly);
        VPolygon.drawPoly(graphics, polygon, true, device.getColorEntry(this.getForeFillColor()), device.getColorEntry(this.getBackFillColor()), device.getColorEntry(this.getForeEdgeColor()), device.getColorEntry(this.getBackEdgeColor()), this.getFillPattern(), this.getEdgePattern(), this.getBrushWidth(), this.mUseAntiAlias);
    }

    public static void drawRoundRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color, Color color2, Color color3, Color color4, int n7, int n8, byte by) {
        Color color5 = graphics.getColor();
        if (n7 != 255) {
            graphics.setColor(n7 == 0 ? color2 : color);
            graphics.fillRoundRect(n, n2, n3, n4, n5, n6);
        }
        graphics.setColor(n8 != 255 ? color3 : color4);
        graphics.drawRoundRect(n, n2, n3, n4, n5, n6);
        graphics.setColor(color5);
    }

    public int getCornerXRadius() {
        return this.mXRadius;
    }

    public int getCornerYRadius() {
        return this.mYRadius;
    }

    public Polygon getRotatedPoints() {
        return this.mPoly;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
        super.listProperties(printStream, string);
    }
}

