/*
 * Decompiled with CFR 0.152.
 */
package oracle.graphics.vgs.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import oracle.bali.share.collection.StringKey;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.graphics.vgs.ui.Convert;
import oracle.graphics.vgs.ui.Device;
import oracle.graphics.vgs.ui.Graphic;
import oracle.graphics.vgs.ui.PackedTree;
import oracle.graphics.vgs.ui.VPolygon;

public class Rect
extends Graphic {
    private Rectangle mRectangle;
    private Polygon mPoly;

    public Rect() {
        this.setClassType((byte)8);
    }

    public Rect(boolean bl) {
        this();
        this.mUseAntiAlias = bl;
    }

    public Rect(boolean bl, boolean bl2) {
        this(bl);
        this.mHonorLineWidth = bl2;
    }

    @Override
    public int pUnpack(PackedTree packedTree, DataInputStream dataInputStream) throws IOException {
        super.pUnpack(packedTree, dataInputStream);
        byte by = (byte)dataInputStream.readUnsignedByte();
        if ((by & 1) == 0) {
            this.setVGX(Convert.OracleIntToJava(dataInputStream));
        } else {
            this.setVGX(Convert.OracleShortToJava(dataInputStream));
        }
        if ((by & 2) == 0) {
            this.setVGY(Convert.OracleIntToJava(dataInputStream));
        } else {
            this.setVGY(Convert.OracleShortToJava(dataInputStream));
        }
        if ((by & 4) == 0) {
            this.setVGWidth(Convert.OracleIntToJava(dataInputStream));
        } else {
            this.setVGWidth(Convert.OracleShortToJava(dataInputStream));
        }
        if ((by & 8) == 0) {
            this.setVGHeight(Convert.OracleIntToJava(dataInputStream));
        } else {
            this.setVGHeight(Convert.OracleShortToJava(dataInputStream));
        }
        this.setInnerBox(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.setDirty(true);
        return 1;
    }

    public void recalc() {
        this.mRectangle = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.mPoly = new Polygon();
        this.mPoly.addPoint(this.mRectangle.x, this.mRectangle.y);
        this.mPoly.addPoint(this.mRectangle.x, this.mRectangle.y + this.mRectangle.height);
        this.mPoly.addPoint(this.mRectangle.x + this.mRectangle.width, this.mRectangle.y + this.mRectangle.height);
        this.mPoly.addPoint(this.mRectangle.x + this.mRectangle.width, this.mRectangle.y);
        if (this.getRotated()) {
            this.mPoly = Convert.rotatePts(this.mPoly, this.getCenter(), this.getRotationAngle());
            this.setInnerBox(this.mPoly);
        }
        this.setDirty(false);
    }

    public void setRectangle(Rectangle rectangle) {
        this.setX(rectangle.x);
        this.setY(rectangle.y);
        this.setWidth(rectangle.width);
        this.setHeight(rectangle.height);
    }

    public Rectangle getRect() {
        return this.mRectangle;
    }

    public Polygon getRotatedPoints() {
        return this.mPoly;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
        super.listProperties(printStream, string);
    }

    @Override
    public void drawGraphic(Graphics graphics, Device device) {
        super.drawGraphic(graphics, device);
        if (this.getDirty()) {
            this.recalc();
        }
        Rectangle rectangle = this.getVisualRect(this.mRectangle);
        Polygon polygon = this.getVisualPoly(this.mPoly);
        if (!this.getRotated()) {
            Rect.drawRectangle(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, device.getColorEntry(this.getForeFillColor()), device.getColorEntry(this.getBackFillColor()), device.getColorEntry(this.getForeEdgeColor()), device.getColorEntry(this.getBackEdgeColor()), this.getFillPattern(), this.getEdgePattern(), this.getLineBevel(), this.getOracleStyle(device.getComponent()), this.getBrushWidth(), this.mUseAntiAlias);
        } else {
            VPolygon.drawPoly(graphics, polygon, true, device.getColorEntry(this.getForeFillColor()), device.getColorEntry(this.getBackFillColor()), device.getColorEntry(this.getForeEdgeColor()), device.getColorEntry(this.getBackEdgeColor()), this.getFillPattern(), this.getEdgePattern(), this.getBrushWidth(), this.mUseAntiAlias);
        }
    }

    public static void drawRectangle(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2, Color color3, Color color4, int n5, int n6, byte by, int n7, int n8, boolean bl) {
        Color color5 = graphics.getColor();
        if (bl) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (n5 != 255) {
            graphics.setColor(n5 == 0 ? color2 : color);
            graphics.fillRect(n, n2, n3, n4);
        }
        if (n7 != 0) {
            Color color6 = UIManager.getColor(n7 == 2 ? LookAndFeel.VERY_DARK_INTENSITY : LookAndFeel.NORMAL_INTENSITY);
            if (n7 == 3) {
                color6 = UIManager.getColor(new StringKey("groupBox"));
            }
            graphics.setColor(color6);
            if (n8 > 1) {
                for (int i = -n8 / 2; i < n8 / 2; ++i) {
                    graphics.drawRoundRect(n + i, n2 + i, n3 - 2 * i, n4 - 2 * i, 8, 8);
                }
            } else {
                graphics.drawRoundRect(n, n2, n3, n4, 8, 8);
            }
        } else {
            if (by != 0 && n8 == 1 && n > 0) {
                --n;
                ++n3;
            }
            if (n6 != 255) {
                switch (by) {
                    case 0: {
                        graphics.setColor(n6 != 255 ? color3 : color4);
                        if (n8 > 1) {
                            for (int i = -n8 / 2; i < n8 / 2; ++i) {
                                graphics.drawRect(n + i, n2 + i, n3 - 2 * i, n4 - 2 * i);
                            }
                        } else {
                            graphics.drawRect(n, n2, n3, n4);
                        }
                        break;
                    }
                    case 8: 
                    case 16: {
                        n3 = n3 == 0 ? 1 : n3;
                        n4 = n4 == 0 ? 1 : n4;
                        Color color7 = UIManager.getColor(LookAndFeel.CONTROL_SHADOW);
                        Color color8 = UIManager.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
                        if (n8 > 1) {
                            int n9;
                            graphics.setColor(Color.lightGray);
                            for (n9 = -n8 / 2; n9 < 0; ++n9) {
                                graphics.draw3DRect(n + n9, n2 + n9, n3 - 2 * n9, n4 - 2 * n9, by == 16);
                            }
                            for (n9 = 0; n9 < n8 / 2; ++n9) {
                                graphics.draw3DRect(n + n9, n2 + n9, n3 - 2 * n9, n4 - 2 * n9, by != 16);
                            }
                        } else {
                            graphics.setColor(by == 16 ? color8 : color7);
                            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                            graphics.setColor(by == 16 ? color7 : color8);
                            graphics.drawRect(n + 1, n2 + 1, n3 - 1, n4 - 1);
                        }
                        break;
                    }
                    case 24: 
                    case 32: {
                        graphics.setColor(Color.lightGray);
                        if (n8 > 1) {
                            for (int i = -n8 / 2; i < n8 / 2; ++i) {
                                graphics.draw3DRect(n + i, n2 + i, n3 - 2 * i, n4 - 2 * i, by == 24);
                            }
                        } else {
                            graphics.draw3DRect(n, n2, n3, n4, by == 24);
                        }
                        break;
                    }
                }
            }
        }
        graphics.setColor(color5);
    }

    protected int getOracleStyle(Component component) {
        return 0;
    }
}

