/*
 * Decompiled with CFR 0.152.
 */
package oracle.graphics.vgs.ui;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import oracle.graphics.vgs.ui.Convert;
import oracle.graphics.vgs.ui.Page;
import oracle.graphics.vgs.ui.Transform;

public class PackedTree {
    public static final int PAGE_SIZE = 64000;
    public static final int OFFSET_ARRAY_SIZE = 10;
    private Vector mPages = new Vector();
    private int[] mOffsets = new int[10];
    private int mCurOffset = 0;
    private int mCurPage = -1;
    private Transform mTransform;
    private static int mVGSVer;

    public PackedTree(Vector vector, int n, Transform transform) {
        this.initParameters(n, transform);
        for (int i = 0; i < vector.size(); ++i) {
            Page page = new Page((byte[])vector.elementAt(i));
            this.mPages.addElement(page);
        }
        this.mCurPage = 0;
    }

    public PackedTree(BufferedInputStream bufferedInputStream, int n, Transform transform) throws IOException {
        int n2 = 0;
        this.initParameters(n, transform);
        try {
            while (n2 > -1) {
                byte[] byArray = new byte[64000];
                int n3 = 0;
                while (n3 < 64000 && n2 > -1) {
                    n2 = bufferedInputStream.read(byArray, n3, 64000 - n3);
                    if (n2 <= 0) continue;
                    n3 += n2;
                }
                if (n3 <= 0) continue;
                this.mPages.addElement(new Page(byArray));
            }
            bufferedInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("FileStreamsTest: " + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.err.println("FileStreamsTest: " + iOException);
        }
        this.mCurPage = 0;
    }

    private final void initParameters(int n, Transform transform) {
        mVGSVer = n;
        this.mTransform = transform;
    }

    public static int getVersion() {
        return mVGSVer;
    }

    public Transform getTransform() {
        return this.mTransform;
    }

    public byte getByte(int n) throws IOException {
        int n2 = 0xFFFF & n >>> 16;
        int n3 = 0xFFFF & n;
        return ((Page)this.mPages.elementAt(n2)).getByte(n3);
    }

    public int getTreePos() {
        int n = this.mCurPage << 16;
        int n2 = ((Page)this.mPages.elementAt(this.mCurPage)).getCurPos();
        return n | n2;
    }

    public DataInputStream pushStream(int n) throws IOException {
        if (this.mCurOffset >= this.mOffsets.length) {
            this.mOffsets = Convert.growArray(this.mOffsets, 10);
        }
        this.mOffsets[this.mCurOffset] = this.getTreePos();
        ++this.mCurOffset;
        return this.getStream(n);
    }

    public DataInputStream popStream() throws IOException {
        --this.mCurOffset;
        return this.getStream(this.mOffsets[this.mCurOffset]);
    }

    public DataInputStream getStream(int n) throws IOException {
        this.mCurPage = 0xFFFF & n >>> 16;
        int n2 = 0xFFFF & n;
        return ((Page)this.mPages.elementAt(this.mCurPage)).getPos(n2);
    }
}

