/*
 * Decompiled with CFR 0.152.
 */
package oracle.graphics.vgs.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import oracle.graphics.vgs.ui.Convert;
import oracle.graphics.vgs.ui.Device;
import oracle.graphics.vgs.ui.Graphic;
import oracle.graphics.vgs.ui.PackedTree;

public class Line
extends Graphic {
    static final byte VGOLNO = 0;
    static final byte VGOLSTRT = 1;
    static final byte VGOLEND = 2;
    static final byte VGOLBOTH = 3;
    static final byte VGOLMTOS = 4;
    static final byte VGOLMTOE = 5;
    private Point mStartPt;
    private Point mEndPt;
    private byte mArrowStyle;
    private static final int ARROW_LENGTH = 12;
    private static final int ARROW_WIDTH = 10;
    private static final int HALF_ARROW_WIDTH = 5;
    private int[] xValuesForArrow = new int[3];
    private int[] yValuesForArrow = new int[3];

    public Line() {
        this.setClassType((byte)5);
        this.mStartPt = new Point(0, 0);
        this.mEndPt = new Point(0, 0);
    }

    public Line(boolean bl) {
        this();
        this.mUseAntiAlias = bl;
    }

    public Line(boolean bl, boolean bl2) {
        this(bl);
        this.mHonorLineWidth = bl2;
    }

    @Override
    public int pUnpack(PackedTree packedTree, DataInputStream dataInputStream) throws IOException {
        super.pUnpack(packedTree, dataInputStream);
        this.mStartPt.x = packedTree.getTransform().transformXValue(Convert.OracleIntToJava(dataInputStream));
        this.mStartPt.y = packedTree.getTransform().transformYValue(Convert.OracleIntToJava(dataInputStream));
        this.mEndPt.x = packedTree.getTransform().transformXValue(Convert.OracleIntToJava(dataInputStream));
        this.mEndPt.y = packedTree.getTransform().transformYValue(Convert.OracleIntToJava(dataInputStream));
        this.mArrowStyle = dataInputStream.readByte();
        this.setInnerBox(this.mStartPt, this.mEndPt);
        if (this.getRotated()) {
            this.mStartPt = Convert.rotatePt(this.mStartPt, this.getCenter(), this.getRotationAngle());
            this.mEndPt = Convert.rotatePt(this.mEndPt, this.getCenter(), this.getRotationAngle());
            this.setInnerBox(this.mStartPt, this.mEndPt);
        }
        return 1;
    }

    public void setStartPt(Point point) {
        this.mStartPt = point;
    }

    public void setEndPt(Point point) {
        this.mEndPt = point;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
        super.listProperties(printStream, string);
    }

    @Override
    public void drawGraphic(Graphics graphics, Device device) {
        super.drawGraphic(graphics, device);
        Color color = graphics.getColor();
        Point point = this.getVisualPoint(this.mStartPt);
        Point point2 = this.getVisualPoint(this.mEndPt);
        if (this.mUseAntiAlias) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.getEdgePattern() != 255) {
            switch (this.getLineBevel()) {
                case 8: 
                case 16: {
                    int n;
                    int n2 = n = point.y == point2.y ? 0 : 1;
                    if (n == 0 || point.x == point2.x) {
                        if (this.getBrushWidth() > 1) {
                            Graphic.drawBevelLine(graphics, point.x, point.y, point2.x, point2.y, this.getBrushWidth(), this.getLineBevel());
                            this.drawArrow(graphics);
                            break;
                        }
                        graphics.setColor(this.getLineBevel() == 16 ? Color.white : Color.gray);
                        graphics.drawLine(point.x, point.y, point2.x, point2.y);
                        graphics.setColor(this.getLineBevel() == 16 ? Color.gray : Color.white);
                        graphics.drawLine(point.x + n, point.y + 1 - n, point2.x + n, point2.y + 1 - n);
                        this.drawArrow(graphics);
                        break;
                    }
                }
                case 0: 
                case 24: 
                case 32: {
                    short s = this.getForeEdgeColor();
                    Color color2 = device.getColorEntry(s);
                    graphics.setColor(color2);
                    Graphic.drawLine(graphics, point.x, point.y, point2.x, point2.y, this.getBrushWidth(), false, this.mUseAntiAlias);
                    this.drawArrow(graphics);
                    break;
                }
            }
        }
        graphics.setColor(color);
    }

    private void drawArrow(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Point point = this.getVisualPoint(this.mStartPt);
        Point point2 = this.getVisualPoint(this.mEndPt);
        switch (this.mArrowStyle) {
            case 0: {
                break;
            }
            case 2: {
                n = point.x;
                n2 = point.y;
                n3 = point2.x;
                n4 = point2.y;
                this.calcValues(n, n2, n3, n4);
                graphics.fillPolygon(this.xValuesForArrow, this.yValuesForArrow, 3);
                break;
            }
            case 1: {
                n = point2.x;
                n2 = point2.y;
                n3 = point.x;
                n4 = point.y;
                this.calcValues(n, n2, n3, n4);
                graphics.fillPolygon(this.xValuesForArrow, this.yValuesForArrow, 3);
                break;
            }
            case 3: {
                n = point.x;
                n2 = point.y;
                n3 = point2.x;
                n4 = point2.y;
                this.calcValues(n, n2, n3, n4);
                graphics.fillPolygon(this.xValuesForArrow, this.yValuesForArrow, 3);
                this.calcValues(n3, n4, n, n2);
                graphics.fillPolygon(this.xValuesForArrow, this.yValuesForArrow, 3);
                break;
            }
            case 4: {
                n = point2.x;
                n2 = point2.y;
                n3 = point.x;
                n4 = point.y;
                this.calcValues(n, n2, (n3 + n) / 2, (n4 + n2) / 2);
                graphics.fillPolygon(this.xValuesForArrow, this.yValuesForArrow, 3);
                break;
            }
            case 5: {
                n = point.x;
                n2 = point.y;
                n3 = point2.x;
                n4 = point2.y;
                this.calcValues(n, n2, (n3 + n) / 2, (n4 + n2) / 2);
                graphics.fillPolygon(this.xValuesForArrow, this.yValuesForArrow, 3);
                break;
            }
        }
    }

    private void calcValues(int n, int n2, int n3, int n4) {
        if (n == n3) {
            if (n4 < n2) {
                this.arrowCoords(n3, n4, n3 - 5, n4 + 12, n3 + 5, n4 + 12);
            } else {
                this.arrowCoords(n3, n4, n3 - 5, n4 - 12, n3 + 5, n4 - 12);
            }
            return;
        }
        if (n2 == n4) {
            if (n3 > n) {
                this.arrowCoords(n3, n4, n3 - 12, n4 - 5, n3 - 12, n4 + 5);
            } else {
                this.arrowCoords(n3, n4, n3 + 12, n4 - 5, n3 + 12, n4 + 5);
            }
            return;
        }
        this.calcValuesQuad(n, n2, n3, n4);
    }

    private void calcValuesQuad(int n, int n2, int n3, int n4) {
        double d = this.toDegrees(Math.atan(0.4166666666666667));
        double d2 = Math.sqrt(154.0);
        double d3 = this.toDegrees(Math.atan((double)Math.abs(n - n3) / (double)Math.abs(n2 - n4)));
        if (n > n3) {
            if (n2 > n4) {
                d3 = 180.0 - d3;
            }
        } else {
            d3 = n2 > n4 ? 180.0 + d3 : 360.0 - d3;
        }
        this.xValuesForArrow[0] = n3;
        this.yValuesForArrow[0] = n4;
        this.calcCoords(1, n3, n4, d2, d3 - d);
        this.calcCoords(2, n3, n4, d2, d3 + d);
    }

    public void calcCoords(int n, int n2, int n3, double d, double d2) {
        while (d2 < 0.0) {
            d2 = 360.0 + d2;
        }
        while (d2 > 360.0) {
            d2 -= 360.0;
        }
        if (d2 <= 90.0) {
            this.xValuesForArrow[n] = n2 + (int)(Math.sin(this.toRadians(d2)) * d);
            this.yValuesForArrow[n] = n3 - (int)(Math.cos(this.toRadians(d2)) * d);
            return;
        }
        if (d2 <= 180.0) {
            this.xValuesForArrow[n] = n2 + (int)(Math.cos(this.toRadians(d2 - 90.0)) * d);
            this.yValuesForArrow[n] = n3 + (int)(Math.sin(this.toRadians(d2 - 90.0)) * d);
            return;
        }
        if (d2 <= 90.0) {
            this.xValuesForArrow[n] = n2 - (int)(Math.sin(this.toRadians(d2 - 180.0)) * d);
            this.yValuesForArrow[n] = n3 + (int)(Math.cos(this.toRadians(d2 - 180.0)) * d);
        } else {
            this.xValuesForArrow[n] = n2 - (int)(Math.cos(this.toRadians(d2 - 270.0)) * d);
            this.yValuesForArrow[n] = n3 - (int)(Math.sin(this.toRadians(d2 - 270.0)) * d);
        }
    }

    public void arrowCoords(int n, int n2, int n3, int n4, int n5, int n6) {
        this.xValuesForArrow[0] = n;
        this.yValuesForArrow[0] = n2;
        this.xValuesForArrow[1] = n3;
        this.yValuesForArrow[1] = n4;
        this.xValuesForArrow[2] = n5;
        this.yValuesForArrow[2] = n6;
    }

    private double toDegrees(double d) {
        return 57.29577951308232 * d;
    }

    private double toRadians(double d) {
        return Math.PI / 180 * d;
    }
}

