/*
 * Decompiled with CFR 0.152.
 */
package oracle.graphics.vgs.ui;

import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.IOException;
import oracle.forms.handler.FormCanvas;
import oracle.forms.ui.DrawnPanel;
import oracle.forms.ui.ExtendedFrame;
import oracle.graphics.vgs.ui.Arc;
import oracle.graphics.vgs.ui.Device;
import oracle.graphics.vgs.ui.Frame;
import oracle.graphics.vgs.ui.Generic;
import oracle.graphics.vgs.ui.Line;
import oracle.graphics.vgs.ui.PackedTree;
import oracle.graphics.vgs.ui.Rect;
import oracle.graphics.vgs.ui.RoundRect;
import oracle.graphics.vgs.ui.Symbol;
import oracle.graphics.vgs.ui.Text;
import oracle.graphics.vgs.ui.VGImage;
import oracle.graphics.vgs.ui.VPolygon;

public class Group
extends Generic {
    private int mGroupSize;
    private Generic[] mKids;
    private boolean mClip;
    private static byte mDeviceDirection;
    private static int mDeviceWidth;
    private boolean mHighContrast = false;

    public Group() {
        this.initGroup();
    }

    public Group(boolean bl) {
        this();
        this.mHighContrast = bl;
        this.mUseAntiAlias = true;
        this.mHonorLineWidth = false;
    }

    public Group(boolean bl, boolean bl2) {
        this(bl);
        this.mUseAntiAlias = bl2;
    }

    public Group(boolean bl, boolean bl2, boolean bl3) {
        this(bl, bl2);
        this.mHonorLineWidth = bl3;
    }

    public Group(Generic generic, Generic generic2) {
        this();
        this.mKids = new Generic[2];
        this.mKids[0] = generic2;
        this.mKids[1] = generic;
    }

    private void initGroup() {
        this.setClassType((byte)2);
        this.mGroupSize = 9;
    }

    public int unpackTree(PackedTree packedTree) throws IOException {
        return this.pUnpack(packedTree, packedTree.getStream(1));
    }

    @Override
    public int pUnpack(PackedTree packedTree, DataInputStream dataInputStream) throws IOException {
        super.pUnpack(packedTree, dataInputStream);
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int[] nArray = new int[n2];
        this.mClip = dataInputStream.readByte() == 1;
        this.mKids = new Generic[n2];
        int n3 = 0;
        if (n2 > 0) {
            int n4;
            dataInputStream = packedTree.getStream(n);
            for (n4 = n2 - 1; n4 >= 0; --n4) {
                nArray[n4] = dataInputStream.readInt();
            }
            block13: for (n4 = n2 - 1; n4 >= 0; --n4) {
                Generic generic;
                dataInputStream = packedTree.getStream(nArray[n4]);
                byte by = dataInputStream.readByte();
                switch (by) {
                    case 2: {
                        generic = new Group(this.mHighContrast, this.mUseAntiAlias, this.mHonorLineWidth);
                        break;
                    }
                    case 9: {
                        generic = new Text(this.mUseAntiAlias, this.mHonorLineWidth);
                        break;
                    }
                    case 5: {
                        generic = new Line(this.mUseAntiAlias, this.mHonorLineWidth);
                        break;
                    }
                    case 8: {
                        generic = new Rect(this.mUseAntiAlias, this.mHonorLineWidth);
                        break;
                    }
                    case 7: {
                        generic = new VPolygon(this.mUseAntiAlias, this.mHonorLineWidth);
                        break;
                    }
                    case 3: {
                        generic = new Arc(this.mUseAntiAlias, this.mHonorLineWidth);
                        break;
                    }
                    case 6: {
                        generic = new RoundRect(this.mUseAntiAlias, this.mHonorLineWidth);
                        break;
                    }
                    case 4: {
                        generic = new VGImage(this.mUseAntiAlias, this.mHonorLineWidth);
                        break;
                    }
                    case 10: {
                        generic = new Symbol(this.mUseAntiAlias, this.mHonorLineWidth);
                        break;
                    }
                    case 11: {
                        generic = new Frame(this.mHighContrast, this.mUseAntiAlias, this.mHonorLineWidth);
                        break;
                    }
                    default: {
                        continue block13;
                    }
                }
                ((Generic)generic).pUnpack(packedTree, dataInputStream);
                this.mKids[n3++] = generic;
            }
            if (n3 != n2) {
                Generic[] genericArray = new Generic[n3];
                System.arraycopy(this.mKids, 0, genericArray, 0, n3);
                this.mKids = genericArray;
            }
        }
        return 1;
    }

    public static byte getDeviceDirection() {
        return mDeviceDirection;
    }

    public static int getDeviceWidth() {
        return mDeviceWidth;
    }

    @Override
    public void drawGraphic(Graphics graphics, Device device) {
        DrawnPanel drawnPanel;
        ExtendedFrame extendedFrame;
        FormCanvas formCanvas;
        int n = this.mKids.length;
        mDeviceDirection = device.getDeviceDirection();
        mDeviceWidth = device.getDeviceSize().x;
        if (device instanceof FormCanvas && ((FormCanvas)device).isToLeft() && (formCanvas = (FormCanvas)device).getPanel().getCanvasType() == 0 && !formCanvas.isTabCanvas() && (extendedFrame = (ExtendedFrame)formCanvas.getParentWindow()) != null && (drawnPanel = extendedFrame.getVerticalToolbar()) != null && drawnPanel.isVisible()) {
            mDeviceWidth -= drawnPanel.getSize().width;
        }
        for (int i = n - 1; i >= 0; --i) {
            this.mKids[i].drawGraphic(graphics, device);
        }
    }
}

