/*
 * Decompiled with CFR 0.152.
 */
package oracle.graphics.vgs.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.graphics.vgs.ui.Convert;
import oracle.graphics.vgs.ui.Device;
import oracle.graphics.vgs.ui.Generic;
import oracle.graphics.vgs.ui.PackedTree;

public class Graphic
extends Generic {
    private int mGraphicSize = 14;
    private int mBrushWidth;
    private int vgAngle;
    private byte mDashCapJoin;
    private byte transferBevelFlags;
    private boolean mRotated;
    private double mRotationAngle;
    protected int mRotationInDegrees;
    private short mForeEdgeColor;
    private short mBackEdgeColor;
    private short mEdgePattern;
    private short mForeFillColor;
    private short mBackFillColor;
    private short mFillPattern;
    private byte mLineBevel;
    private byte mBorderFlags;
    public static final int PATTERN_TRANSPARENT = 255;
    public static final int SOLID = 0;
    public static final byte BEVEL_PLAIN = 0;
    public static final byte BEVEL_INSET = 8;
    public static final byte BEVEL_OUTSET = 16;
    public static final byte BEVEL_RAISE = 24;
    public static final byte BEVEL_LOWER = 32;
    private static final byte BEVEL_MASK = 56;

    Graphic() {
    }

    @Override
    public int pUnpack(PackedTree packedTree, DataInputStream dataInputStream) throws IOException {
        super.pUnpack(packedTree, dataInputStream);
        short s = (short)dataInputStream.readUnsignedByte();
        if ((s & 1) != 0) {
            this.vgAngle = Convert.OracleShortToJava(dataInputStream);
            this.setRotated(true);
            this.setRotationAngle(this.vgAngle);
        } else {
            this.setRotated(false);
            this.setRotationAngle(0);
        }
        if ((s & 2) != 0) {
            this.setForeEdgeColor((short)dataInputStream.readUnsignedByte());
        } else {
            this.setForeEdgeColor((short)0);
        }
        if ((s & 4) != 0) {
            this.setBackEdgeColor((short)dataInputStream.readUnsignedByte());
        } else {
            this.setBackEdgeColor((short)0);
        }
        if ((s & 8) != 0) {
            this.setEdgePattern((short)0);
        } else {
            this.setEdgePattern((short)255);
        }
        if ((s & 0x10) != 0) {
            this.setForeFillColor((short)dataInputStream.readUnsignedByte());
        } else {
            this.setForeFillColor((short)0);
        }
        if ((s & 0x20) != 0) {
            this.setBackFillColor((short)dataInputStream.readUnsignedByte());
        } else {
            this.setBackFillColor((short)6);
        }
        if ((s & 0x40) != 0) {
            this.setFillPattern((short)0);
        } else {
            this.setFillPattern((short)255);
        }
        if ((s & 0x80) != 0) {
            this.setLineBevel((byte)(dataInputStream.readByte() & 0x38));
        } else {
            this.setLineBevel((byte)0);
        }
        this.setBrushWidth(Convert.OracleIntToJava(dataInputStream));
        return 1;
    }

    public boolean getRotated() {
        return this.mRotated;
    }

    void setRotated(boolean bl) {
        this.mRotated = bl;
    }

    @Override
    public void drawGraphic(Graphics graphics, Device device) {
    }

    void setRotationAngle(int n) {
        this.mRotationAngle = Convert.VGAngle(n);
        this.mRotationInDegrees = Convert.degreesLhand(n);
    }

    double getRotationAngle() {
        return this.mRotationAngle;
    }

    protected void setForeEdgeColor(short s) {
        this.mForeEdgeColor = s;
    }

    public short getForeEdgeColor() {
        return this.mForeEdgeColor;
    }

    protected void setBackEdgeColor(short s) {
        this.mBackEdgeColor = s;
    }

    public short getBackEdgeColor() {
        return this.mBackEdgeColor;
    }

    protected void setForeFillColor(short s) {
        this.mForeFillColor = s;
    }

    public short getForeFillColor() {
        return this.mForeFillColor;
    }

    protected void setBackFillColor(short s) {
        this.mBackFillColor = s;
    }

    public short getBackFillColor() {
        return this.mBackFillColor;
    }

    protected void setEdgePattern(short s) {
        this.mEdgePattern = s;
    }

    public short getEdgePattern() {
        return this.mEdgePattern;
    }

    protected void setFillPattern(short s) {
        this.mFillPattern = s;
    }

    public short getFillPattern() {
        return this.mFillPattern;
    }

    public byte getLineBevel() {
        return this.mLineBevel;
    }

    protected void setLineBevel(byte by) {
        this.mLineBevel = by;
    }

    protected void setBrushWidth(int n) {
        this.mBrushWidth = UIManager.getLookAndFeel().getName().equalsIgnoreCase("Oracle") && !this.mHonorLineWidth ? 1 : this.mTransform.transformXValue(n);
    }

    public int getBrushWidth() {
        return this.mBrushWidth;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    public static void drawLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        int n6 = n3;
        int n7 = n4;
        if (bl2) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (n5 > 1) {
            double d = Math.atan((double)(n4 - n2) / (double)(n - n3));
            double d2 = (double)n5 * Math.sin(d) / 2.0;
            double d3 = (double)n5 * Math.cos(d) / 2.0;
            if (bl) {
                double d4 = 0.5 * d3;
                double d5 = 0.5 * d2;
                if (n3 > n) {
                    n3 = (int)((double)n3 + d4);
                    n4 = (int)((double)n4 - d5);
                    n = (int)((double)n - d4);
                    n2 = (int)((double)n2 + d5);
                } else {
                    n3 = (int)((double)n3 - d4);
                    n4 = (int)((double)n4 + d5);
                    n = (int)((double)n + d4);
                    n2 = (int)((double)n2 - d5);
                }
            }
            int[] nArray = new int[5];
            int[] nArray2 = new int[5];
            nArray[0] = (int)((double)n - d2);
            nArray2[0] = (int)((double)n2 - d3);
            nArray[1] = (int)((double)n3 - d2);
            nArray2[1] = (int)((double)n4 - d3);
            nArray[2] = (int)((double)n3 + d2);
            nArray2[2] = (int)((double)n4 + d3);
            nArray[3] = (int)((double)n + d2);
            nArray2[3] = (int)((double)n2 + d3);
            nArray[4] = nArray[0];
            nArray2[4] = nArray2[0];
            graphics.fillPolygon(nArray, nArray2, 5);
        } else {
            graphics.drawLine(n, n2, n6, n7);
        }
    }

    public static void drawBevelLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, byte by) {
        int n6;
        Color color = graphics.getColor();
        Color color2 = UIManager.getColor(LookAndFeel.CONTROL_SHADOW);
        int n7 = n5 > 5 ? (n5 > 11 ? 3 : 2) : (n6 = 1);
        if (by == 8) {
            n6 = 1;
        }
        graphics.setColor(Color.white);
        if (n2 == n4) {
            if (by == 16) {
                graphics.fillRect(n, n2 - n5 / 2, Math.abs(n3 - n), n5 - n6);
                graphics.setColor(color2);
                graphics.fillRect(n, n2 + n5 / 2 - n6, Math.abs(n3 - n), n6);
            } else if (by == 8) {
                graphics.fillRect(n, n2 - n5 / 2 - n6, Math.abs(n3 - n), n5 - n6);
                graphics.setColor(color2);
                graphics.fillRect(n, n2 - n5 / 2 - n6, Math.abs(n3 - n), n6);
            }
        } else if (n == n3) {
            if (by == 16) {
                graphics.fillRect(n - n5 / 2, n2, n5 - n6, Math.abs(n4 - n2));
                graphics.setColor(color2);
                graphics.fillRect(n + n5 / 2 - n6, n2, n6, Math.abs(n4 - n2));
            } else if (by == 8) {
                graphics.fillRect(n - n5 / 2 - n6, n2, n5 - n6, Math.abs(n4 - n2));
                graphics.setColor(color2);
                graphics.fillRect(n - n5 / 2 - n6, n2, n6, Math.abs(n4 - n2));
            }
        }
        graphics.setColor(color);
    }
}

