/*
 * Decompiled with CFR 0.152.
 */
package oracle.graphics.vgs.ui;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import oracle.graphics.vgs.test.VGTest;
import oracle.graphics.vgs.ui.Device;
import oracle.graphics.vgs.ui.Group;
import oracle.graphics.vgs.ui.PackedTree;
import oracle.graphics.vgs.ui.Transform;

public class Generic
implements VGTest {
    static final int genericSize = 16;
    static final int VGOBDISD = 1;
    static final int VGOBSELD = 2;
    static final int VGOBRDON = 4;
    static final int VGOBIBD = 8;
    static final int VGOBODTY = 16;
    static final int VGOBHIDE = 32;
    static final int BBX = 0;
    static final int BBY = 1;
    static final int BBW = 2;
    static final int BBH = 3;
    private byte mClassType;
    private String mName;
    private short mCharsetOfName;
    private Rectangle mInnerBox;
    private Rectangle mOuterBox;
    private Point mCenter;
    private boolean mDirty;
    private boolean mBBDirty;
    protected Transform mTransform = null;
    protected boolean mUseAntiAlias = false;
    protected boolean mHonorLineWidth = false;
    private int mX;
    private int mVGX;
    private int mY;
    private int mVGY;
    private int mWidth;
    private int mVGWidth;
    private int mHeight;
    private int mVGHeight;
    public static final byte UI_DIRECTION_DEFAULT = 0;
    public static final byte UI_DIRECTION_TORIGHT = 1;
    public static final byte UI_DIRECTION_TOLEFT = 2;

    public Generic() {
        this.setInnerBox(0, 0, 0, 0);
        this.setOuterBox(0, 0, 0, 0);
        this.mVGHeight = 0;
        this.mVGWidth = 0;
        this.mHeight = 0;
        this.mWidth = 0;
        this.mVGY = 0;
        this.mVGX = 0;
        this.mY = 0;
        this.mX = 0;
        this.setDirty(false);
        this.setBBDirty(false);
    }

    public int pUnpack(PackedTree packedTree, DataInputStream dataInputStream) throws IOException {
        this.mTransform = packedTree.getTransform();
        this.mName = new String();
        this.mCharsetOfName = 0;
        return 1;
    }

    public void setInnerBox(Point point, Point point2) {
        int n;
        int n2;
        int n3;
        int n4;
        if (point.x < point2.x) {
            n4 = point.x;
            n3 = point2.x - point.x;
        } else {
            n4 = point2.x;
            n3 = point.x - point2.x;
        }
        if (point.y < point2.y) {
            n2 = point.y;
            n = point2.y - point.y;
        } else {
            n2 = point2.y;
            n = point.y - point2.y;
        }
        this.setInnerBox(n4, n2, n3, n);
    }

    public void setInnerBox(Polygon polygon) {
        Rectangle rectangle;
        this.mInnerBox = rectangle = polygon.getBounds();
        this.mCenter = new Point(this.mInnerBox.x + this.mInnerBox.width / 2, this.mInnerBox.y + this.mInnerBox.height / 2);
    }

    public void setInnerBox(int n, int n2, int n3, int n4) {
        this.mInnerBox = new Rectangle(n, n2, n3, n4);
        this.mCenter = new Point(n + n3 / 2, n2 + n4 / 2);
    }

    public void setOuterBox(int n, int n2, int n3, int n4) {
        this.mOuterBox = new Rectangle(n, n2, n3, n4);
    }

    public void drawGraphic(Graphics graphics, Device device) {
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
    }

    protected void setClassType(byte by) {
        this.mClassType = by;
    }

    public byte getClassType() {
        return this.mClassType;
    }

    public String getName() {
        return this.mName;
    }

    public short getCharsetOfName() {
        return this.mCharsetOfName;
    }

    public Rectangle getInnerBox() {
        return this.mInnerBox;
    }

    public int getBBoxX() {
        return this.mInnerBox.x;
    }

    public int getBBoxY() {
        return this.mInnerBox.y;
    }

    public int getBBoxWidth() {
        return this.mInnerBox.width;
    }

    public int getBBoxHeight() {
        return this.mInnerBox.height;
    }

    public Point getCenter() {
        return this.mCenter;
    }

    public boolean setX(int n) {
        this.mX = n;
        if (this.mTransform != null) {
            this.mVGX = this.mTransform.undoXTransform(n);
        }
        return true;
    }

    public int getX() {
        return this.mX;
    }

    public boolean setY(int n) {
        this.mY = n;
        if (this.mTransform != null) {
            this.mVGY = this.mTransform.undoYTransform(n);
        }
        return true;
    }

    public int getY() {
        return this.mY;
    }

    public boolean setWidth(int n) {
        this.mWidth = n;
        if (this.mTransform != null) {
            this.mVGWidth = this.mTransform.undoXScale(n);
        }
        return true;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public boolean setHeight(int n) {
        this.mHeight = n;
        if (this.mTransform != null) {
            this.mVGHeight = this.mTransform.undoYScale(n);
        }
        return true;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public boolean setVGX(int n) {
        this.mVGX = n;
        this.mX = this.mTransform.transformXValue(this.getVGX());
        return true;
    }

    private int getVGX() {
        return this.mVGX;
    }

    public boolean setVGY(int n) {
        this.mVGY = n;
        this.mY = this.mTransform.transformYValue(this.getVGY());
        return true;
    }

    private int getVGY() {
        return this.mVGY;
    }

    public boolean setVGWidth(int n) {
        this.mVGWidth = n;
        this.mWidth = this.mTransform.scaleXValue(this.getVGWidth());
        return true;
    }

    protected int getVGWidth() {
        return this.mVGWidth;
    }

    public boolean setVGHeight(int n) {
        this.mVGHeight = n;
        this.mHeight = this.mTransform.scaleYValue(this.getVGHeight());
        return true;
    }

    protected int getVGHeight() {
        return this.mVGHeight;
    }

    public boolean setDirty(boolean bl) {
        this.mDirty = bl;
        return true;
    }

    public boolean getDirty() {
        return this.mDirty;
    }

    public boolean setBBDirty(boolean bl) {
        this.mBBDirty = bl;
        return true;
    }

    public boolean getBBDirty() {
        return this.mBBDirty;
    }

    public int getVisualX(int n, int n2) {
        if (Group.getDeviceDirection() == 2) {
            int n3 = Group.getDeviceWidth() - n2 - n;
            return n3;
        }
        return n;
    }

    public Point getVisualPoint(Point point) {
        if (Group.getDeviceDirection() == 2) {
            Point point2 = new Point(point);
            point2.x = Group.getDeviceWidth() - point2.x - 1;
            return point2;
        }
        return point;
    }

    public Rectangle getVisualRect(Rectangle rectangle) {
        if (Group.getDeviceDirection() == 2) {
            Rectangle rectangle2 = new Rectangle(rectangle);
            rectangle2.x = Group.getDeviceWidth() - rectangle2.width - rectangle2.x;
            return rectangle2;
        }
        return rectangle;
    }

    public Polygon getVisualPoly(Polygon polygon) {
        if (Group.getDeviceDirection() == 2) {
            Polygon polygon2 = new Polygon();
            int n = Group.getDeviceWidth();
            for (int i = 0; i < polygon.npoints; ++i) {
                int n2 = n - polygon.xpoints[i] - 1;
                int n3 = polygon.ypoints[i];
                polygon2.addPoint(n2, n3);
            }
            return polygon2;
        }
        return polygon;
    }
}

