/*
 * Decompiled with CFR 0.152.
 */
package oracle.graphics.vgs.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.graphics.vgs.ui.Convert;
import oracle.graphics.vgs.ui.Device;
import oracle.graphics.vgs.ui.Group;
import oracle.graphics.vgs.ui.PackedTree;
import oracle.graphics.vgs.ui.Rect;
import oracle.graphics.vgs.ui.Text;

public class Frame
extends Rect {
    static final int VGOFAL_LEFT = 1;
    static final int VGOFAL_CENTER = 2;
    static final int VGOFAL_RIGHT = 3;
    static final int VGOFAL_START = 4;
    static final int VGOFAL_END = 5;
    static final byte VGOFSHOWRT = 1;
    static final byte VGOFSHOWTX = 2;
    private Text mLabel;
    private byte mFlags;
    private byte mAlignment;
    private int mLabelOffset;
    private int mLabelSpacing;
    private boolean mHighContrast = false;

    public Frame() {
        this.setClassType((byte)11);
    }

    public Frame(boolean bl) {
        this();
        this.mHighContrast = bl;
    }

    public Frame(boolean bl, boolean bl2) {
        this(bl);
        this.mUseAntiAlias = bl2;
    }

    public Frame(boolean bl, boolean bl2, boolean bl3) {
        this(bl, bl2);
        this.mHonorLineWidth = bl3;
    }

    @Override
    public int pUnpack(PackedTree packedTree, DataInputStream dataInputStream) throws IOException {
        super.pUnpack(packedTree, dataInputStream);
        int n = dataInputStream.readInt();
        this.mFlags = dataInputStream.readByte();
        this.mAlignment = dataInputStream.readByte();
        this.mLabelOffset = packedTree.getTransform().transformXValue(Convert.OracleIntToJava(dataInputStream));
        this.mLabelSpacing = packedTree.getTransform().transformXValue(Convert.OracleIntToJava(dataInputStream));
        if (n != 0) {
            dataInputStream = packedTree.pushStream(n);
            dataInputStream.skipBytes(1);
            this.mLabel = new Text();
            this.mLabel.pUnpack(packedTree, dataInputStream);
            dataInputStream = packedTree.popStream();
        } else {
            this.mFlags = (byte)(this.mFlags & 0xFFFFFFFD);
        }
        if (this.mHighContrast && UIManager.getLookAndFeel().getName() == "Generic") {
            this.mLabel.resetColor(this.getBackFillColor());
        }
        this.setDirty(true);
        return 1;
    }

    public void recalc(Graphics graphics, Device device) {
        super.recalc();
        if ((this.mFlags & 2) != 0) {
            this.mLabel.recalc(graphics, device);
            if (this.mLabel.getWidth() > 0) {
                this.alignText();
                this.mLabel.recalcTextLayout(graphics, device);
            } else {
                this.mFlags = (byte)(this.mFlags & 0xFFFFFFFD);
            }
        }
        this.setDirty(false);
    }

    public void alignText() {
        switch (this.mAlignment) {
            case 4: {
                this.mLabel.setHAlign((byte)0);
                this.mLabel.setX(this.getX() + this.mLabelOffset + this.mLabelSpacing);
                break;
            }
            case 5: {
                this.mLabel.setHAlign((byte)2);
                this.mLabel.setX(this.getX() + this.getWidth() - (this.mLabelOffset + this.mLabelSpacing));
                break;
            }
            case 1: {
                if (Group.getDeviceDirection() == 2) {
                    this.mLabel.setHAlign((byte)2);
                    this.mLabel.setX(this.getX() + this.getWidth() - (this.mLabelOffset + this.mLabelSpacing));
                    break;
                }
                this.mLabel.setHAlign((byte)0);
                this.mLabel.setX(this.getX() + this.mLabelOffset + this.mLabelSpacing);
                break;
            }
            case 3: {
                if (Group.getDeviceDirection() != 2) {
                    this.mLabel.setHAlign((byte)2);
                    this.mLabel.setX(this.getX() + this.getWidth() - (this.mLabelOffset + this.mLabelSpacing));
                    break;
                }
                this.mLabel.setHAlign((byte)0);
                this.mLabel.setX(this.getX() + this.mLabelOffset + this.mLabelSpacing);
                break;
            }
            case 2: {
                this.mLabel.setHAlign((byte)1);
                this.mLabel.setX(this.getX() + this.getWidth() / 2);
            }
        }
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
        super.listProperties(printStream, string);
    }

    @Override
    public void drawGraphic(Graphics graphics, Device device) {
        if (this.getDirty()) {
            this.recalc(graphics, device);
        }
        if ((this.mFlags & 2) != 0) {
            if ((this.mFlags & 1) != 0) {
                int n = Group.getDeviceWidth();
                byte by = Group.getDeviceDirection();
                Rectangle rectangle = new Rectangle(graphics.getClipBounds());
                int n2 = 3;
                int n3 = this.mLabel.updateHAlignOffset();
                this.mLabel.updateVAlignOffset();
                while (n2-- > 0) {
                    Rectangle rectangle2 = new Rectangle(0, rectangle.y, n, rectangle.height);
                    if (n2 == 2) {
                        if (by == 2) {
                            rectangle2.x = n - n3 + this.mLabelSpacing;
                            rectangle2.width = n - rectangle2.x;
                        } else {
                            rectangle2.width = n3 - this.mLabelSpacing;
                        }
                    } else if (n2 == 1) {
                        if (rectangle2.y < this.mLabel.getY() + this.mLabel.getHeight() / 2) {
                            rectangle2.y = this.mLabel.getY() + this.mLabel.getHeight() / 2;
                        }
                    } else {
                        if (by != 2) {
                            rectangle2.x = n3 + this.mLabel.getWidth() + this.mLabelSpacing;
                        }
                        rectangle2.width = n - n3 - this.mLabel.getWidth() - this.mLabelSpacing;
                    }
                    int n4 = rectangle.x + rectangle.width;
                    int n5 = rectangle2.x + rectangle2.width;
                    int n6 = rectangle.y + rectangle.height;
                    int n7 = rectangle2.y + rectangle2.height;
                    if (rectangle2.x < rectangle.x) {
                        rectangle2.x = rectangle.x;
                    }
                    if (n5 > n4) {
                        n5 = n4;
                    }
                    rectangle2.width = n5 > rectangle2.x ? n5 - rectangle2.x : 0;
                    if (rectangle2.y < rectangle.y) {
                        rectangle2.y = rectangle.y;
                    }
                    if (n7 > n6) {
                        n7 = n6;
                    }
                    rectangle2.height = n7 > rectangle2.y ? n7 - rectangle2.y : 0;
                    graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    super.drawGraphic(graphics, device);
                }
                graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.mLabel.drawGraphic(graphics, device);
        } else if ((this.mFlags & 1) != 0) {
            super.drawGraphic(graphics, device);
        }
    }

    @Override
    protected int getOracleStyle(Component component) {
        int n = 0;
        if (UIManager.getLookAndFeel().getName() == "Oracle" && (this.getLineBevel() == 8 || this.getLineBevel() == 16 || this.getLineBevel() == 24 || this.getLineBevel() == 32)) {
            Color color = component.getBackground();
            n = color != null && color.equals(UIManager.getColor(LookAndFeel.DARK_LOOK)) ? 2 : 1;
            if (UIManager.getLookAndFeel().getDefaultColorScheme().getName().equalsIgnoreCase("BLAF")) {
                n = 3;
            }
        }
        return n;
    }
}

