/*
 * Decompiled with CFR 0.152.
 */
package oracle.graphics.vgs.ui;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.IOException;

public class Convert {
    static final int VGneg = -128;
    public static final int VGS_TICS = 64;

    private Convert() {
    }

    public static final int OracleIntToJava(DataInputStream dataInputStream) throws IOException {
        int n = 1;
        int n2 = dataInputStream.read();
        int n3 = dataInputStream.read();
        int n4 = dataInputStream.read();
        int n5 = dataInputStream.read();
        if ((n2 & 0xFFFFFF80) != 0) {
            n2 &= 0x7F;
            n = -1;
        }
        int n6 = (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
        return n6 *= n;
    }

    public static final short OracleShortToJava(DataInputStream dataInputStream) throws IOException {
        int n = 1;
        int n2 = dataInputStream.read();
        int n3 = dataInputStream.read();
        if ((n2 & 0xFFFFFF80) != 0) {
            n2 &= 0x7F;
            n = -1;
        }
        short s = (short)((n2 << 8) + n3);
        s = (short)(s * n);
        return s;
    }

    public static final double VGAngle(int n) {
        int n2 = n % 23040;
        double d = (double)n2 / 64.0;
        double d2 = d * Math.PI / 180.0;
        return d2;
    }

    public static final int degreesLhand(int n) {
        int n2 = n % 23040;
        int n3 = n2 / 64;
        return n3;
    }

    public static final int degreesAngle(int n) {
        int n2 = n % 23040;
        int n3 = n2 / 64;
        int n4 = n2 < 0 ? 360 + n3 : 360 - n3;
        return n4;
    }

    public static final Point rotatePt(Point point, Point point2, double d) {
        int n = point.x - point2.x;
        int n2 = point.y - point2.y;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        int n3 = (int)((double)n * d2 - (double)n2 * d3);
        int n4 = (int)((double)n * d3 + (double)n2 * d2);
        Point point3 = new Point(n3 + point2.x, n4 + point2.y);
        return point3;
    }

    public static final Polygon rotatePts(Polygon polygon, Point point, double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        Polygon polygon2 = new Polygon();
        for (int i = 0; i < polygon.npoints; ++i) {
            int n = polygon.xpoints[i] - point.x;
            int n2 = polygon.ypoints[i] - point.y;
            int n3 = (int)((double)n * d2 - (double)n2 * d3);
            int n4 = (int)((double)n * d3 + (double)n2 * d2);
            polygon2.addPoint(n3 + point.x, n4 + point.y);
        }
        return polygon2;
    }

    public static final Polygon rotateRect(Rectangle rectangle, Point point, double d) {
        Polygon polygon = new Polygon();
        polygon.addPoint(rectangle.x, rectangle.y);
        polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
        polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
        Polygon polygon2 = Convert.rotatePts(polygon, point, d);
        return polygon2;
    }

    public static final Polygon mirrorInX(Polygon polygon, int n) {
        Polygon polygon2 = new Polygon();
        for (int i = polygon.npoints - 1; i >= 0; --i) {
            int n2 = n - (polygon.xpoints[i] - n);
            int n3 = polygon.ypoints[i];
            polygon2.addPoint(n2, n3);
        }
        return polygon2;
    }

    public static final Polygon mirrorInY(Polygon polygon, int n) {
        Polygon polygon2 = new Polygon();
        for (int i = polygon.npoints - 1; i >= 0; --i) {
            int n2 = polygon.xpoints[i];
            int n3 = n - (polygon.ypoints[i] - n);
            polygon2.addPoint(n2, n3);
        }
        return polygon2;
    }

    public static final int[] growArray(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length + n];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    public static final int[][] flipArray90(int[][] nArray) {
        int[][] nArray2 = new int[nArray[0].length][nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[0].length - 1;
            int n2 = 0;
            while (n >= 0) {
                nArray2[n][i] = nArray[i][n2];
                --n;
                ++n2;
            }
        }
        return nArray2;
    }

    public static final int[][] flipArray180(int[][] nArray) {
        int[][] nArray2 = new int[nArray.length][nArray[0].length];
        int n = nArray.length - 1;
        int n2 = 0;
        while (n >= 0) {
            int n3 = nArray[0].length - 1;
            int n4 = 0;
            while (n3 >= 0) {
                nArray2[n][n3] = nArray[n2][n4];
                --n3;
                ++n4;
            }
            --n;
            ++n2;
        }
        return nArray2;
    }

    public static final int[][] flipArray270(int[][] nArray) {
        int[][] nArray2 = new int[nArray[0].length][nArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray[0].length - 1) {
            int n3 = 0;
            int n4 = nArray.length - 1;
            while (n4 >= 0) {
                nArray2[n2][n3] = nArray[n4][n];
                --n4;
                ++n3;
            }
            ++n2;
            ++n;
        }
        return nArray2;
    }

    public static final int[] copyArray(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }
}

