/*
 * Decompiled with CFR 0.152.
 */
package oracle.graphics.vgs.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import oracle.graphics.vgs.ui.Convert;
import oracle.graphics.vgs.ui.Device;
import oracle.graphics.vgs.ui.Graphic;
import oracle.graphics.vgs.ui.PackedTree;
import oracle.graphics.vgs.ui.Transform;

public class Arc
extends Graphic {
    private int mStartAngle;
    private int mEndAngle;
    private int mVGStart;
    private int mVGEnd;
    private Polygon mPoly;
    private boolean mChord;
    private boolean mClosed;
    private boolean mOval;

    public Arc() {
        this.setClassType((byte)3);
        this.setPoly(new Polygon());
        this.mVGEnd = 0;
        this.mVGStart = 0;
        this.mEndAngle = 0;
        this.mStartAngle = 0;
        this.mChord = false;
        this.mOval = false;
        this.mClosed = false;
    }

    public Arc(boolean bl) {
        this();
        this.mUseAntiAlias = bl;
    }

    public Arc(boolean bl, boolean bl2) {
        this(bl);
        this.mHonorLineWidth = bl2;
    }

    @Override
    public int pUnpack(PackedTree packedTree, DataInputStream dataInputStream) throws IOException {
        super.pUnpack(packedTree, dataInputStream);
        this.setVGX(Convert.OracleIntToJava(dataInputStream));
        this.setVGY(Convert.OracleIntToJava(dataInputStream));
        this.setVGWidth(Convert.OracleIntToJava(dataInputStream));
        this.setVGHeight(Convert.OracleIntToJava(dataInputStream));
        this.setVGStart(Convert.OracleShortToJava(dataInputStream));
        this.setVGEnd(Convert.OracleShortToJava(dataInputStream));
        if (dataInputStream.readByte() == 1) {
            this.setChord(true);
        } else {
            this.setChord(false);
        }
        if (dataInputStream.readByte() == 1) {
            this.setClosed(true);
        } else {
            this.setClosed(false);
        }
        this.recalc();
        return 1;
    }

    private void recalc() {
        this.mOval = this.mVGStart == this.mVGEnd && (this.getVGWidth() == this.getVGHeight() || !this.getRotated());
        this.setInnerBox(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.setPoly(Arc.toPoly(this.mPoly, this.getX(), this.getY(), this.getVGWidth(), this.getVGHeight(), this.mVGStart, this.mVGEnd, this.getClosed(), this.mChord, this.mTransform));
        if (this.getRotated()) {
            this.setPoly(Convert.rotatePts(this.mPoly, this.getCenter(), this.getRotationAngle()));
            this.setInnerBox(this.mPoly);
        }
        this.setDirty(false);
    }

    public static Polygon toPoly(Polygon polygon, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, Transform transform) {
        if (n3 == 0 && n4 == 0) {
            polygon.addPoint(n, n2);
            return polygon;
        }
        double d = Convert.VGAngle(n5);
        double d2 = Convert.VGAngle(n6);
        if (d2 <= d) {
            d2 += Math.PI * 2;
        }
        int n7 = n4 > n3 ? transform.scaleXValue(n4) : transform.scaleYValue(n3 / 2);
        int n8 = n3 / 2;
        int n9 = n4 / 2;
        int n10 = n + transform.scaleXValue(n8);
        int n11 = n2 + transform.scaleYValue(n9);
        double d3 = 1.0 / (double)n7;
        while (d < d2) {
            int n12 = n10 + transform.scaleXValue((int)((double)n8 * Math.cos(d)));
            int n13 = n11 + transform.scaleYValue((int)((double)n9 * Math.sin(d)));
            polygon.addPoint(n12, n13);
            d += d3;
        }
        if (n5 != n6) {
            int n14 = n10 + transform.scaleXValue((int)((double)n8 * Math.cos(d2)));
            int n15 = n11 + transform.scaleYValue((int)((double)n9 * Math.sin(d2)));
            polygon.addPoint(n14, n15);
            if (!bl2) {
                polygon.addPoint(n10, n11);
            }
        }
        return polygon;
    }

    private boolean setClosed(boolean bl) {
        this.mClosed = bl;
        return true;
    }

    public boolean getClosed() {
        return this.mClosed;
    }

    @Override
    public void listProperties(PrintStream printStream, String string) {
        super.listProperties(printStream, string);
    }

    @Override
    public void drawGraphic(Graphics graphics, Device device) {
        super.drawGraphic(graphics, device);
        if (this.getDirty()) {
            this.recalc();
        }
        int n = this.getVisualX(this.getX(), this.getWidth());
        Polygon polygon = this.getVisualPoly(this.mPoly);
        Color color = graphics.getColor();
        Color color2 = device.getColorEntry(this.getBackFillColor());
        Color color3 = device.getColorEntry(this.getForeFillColor());
        Color color4 = device.getColorEntry(this.getBackEdgeColor());
        Color color5 = device.getColorEntry(this.getForeEdgeColor());
        if (this.mUseAntiAlias) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.getFillPattern() != 255) {
            graphics.setColor(this.getFillPattern() == 0 ? color2 : color3);
            if (this.mOval) {
                graphics.fillOval(n, this.getY(), this.getWidth(), this.getHeight());
            } else {
                graphics.fillPolygon(polygon);
            }
        }
        if (this.getEdgePattern() != 255) {
            graphics.setColor(this.getEdgePattern() == 0 ? color4 : color5);
            if (this.mOval) {
                int n2 = this.getBrushWidth();
                if (n2 > 1) {
                    for (int i = -n2 / 2; i < n2 / 2; ++i) {
                        graphics.drawOval(n + i, this.getY() + i, this.getWidth() - 2 * i, this.getHeight() - 2 * i);
                    }
                } else {
                    graphics.drawOval(n, this.getY(), this.getWidth(), this.getHeight());
                }
            } else {
                int n3;
                int n4 = !this.getClosed() && !this.isChord() ? polygon.npoints - 1 : polygon.npoints;
                for (n3 = 1; n3 < n4; ++n3) {
                    Graphic.drawLine(graphics, polygon.xpoints[n3 - 1], polygon.ypoints[n3 - 1], polygon.xpoints[n3], polygon.ypoints[n3], this.getBrushWidth(), true, this.mUseAntiAlias);
                }
                if (this.getClosed()) {
                    Graphic.drawLine(graphics, polygon.xpoints[n3 - 1], polygon.ypoints[n3 - 1], polygon.xpoints[0], polygon.ypoints[0], this.getBrushWidth(), true, this.mUseAntiAlias);
                }
            }
        }
        graphics.setColor(color);
    }

    private boolean setStartAngle(int n) {
        this.mStartAngle = n;
        return true;
    }

    public int getStartAngle() {
        return this.mStartAngle;
    }

    private boolean setEndAngle(int n) {
        this.mEndAngle = n;
        return true;
    }

    public int getEndAngle() {
        return this.mEndAngle;
    }

    public boolean setVGStart(int n) {
        this.mVGStart = n;
        this.setStartAngle(Convert.degreesAngle(this.getVGStart()));
        return true;
    }

    private int getVGStart() {
        return this.mVGStart;
    }

    private boolean setVGEnd(int n) {
        this.mVGEnd = n;
        this.setEndAngle(Convert.degreesAngle(this.mVGEnd) - this.getStartAngle());
        return true;
    }

    private int getVGEnd() {
        return this.mVGEnd;
    }

    private boolean setPoly(Polygon polygon) {
        this.mPoly = polygon;
        return true;
    }

    public Polygon getPoly() {
        return this.mPoly;
    }

    public boolean setChord(boolean bl) {
        this.mChord = bl;
        return true;
    }

    public boolean isChord() {
        return this.mChord;
    }
}

