/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.session;

import java.applet.AppletContext;
import java.net.URL;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.IHandler;
import oracle.forms.properties.ID;
import oracle.forms.webutil.common.VBeanCommon;
import oracle.forms.webutil.session.DispatcherWatch;

public class SessionFunctions
extends VBeanCommon {
    private static final ID WUS_MONITOR_DISPATCHER = ID.registerProperty("WUS_MONITOR_DISPATCHER");
    static DispatcherWatch s_dispatcherWatch = null;
    static int s_instanceCount = 0;
    static int s_monitorInterval = -1;

    @Override
    public void setBeanInfo() {
        this.setBeanName("WebUtil Session Monitoring Facilities");
        this.setBeanShortName("WUS");
    }

    @Override
    public void init(IHandler iHandler) {
        super.init(iHandler);
        if (s_monitorInterval == -1) {
            s_monitorInterval = 0;
            String string = iHandler.getApplet().getParameter("WebUtilDispatchMonitorInterval");
            try {
                if (string != null && !string.equalsIgnoreCase("")) {
                    float f = Float.parseFloat(string) * 1000.0f;
                    s_monitorInterval = (int)f;
                    this.log((byte)1, "SessionFunctions.init()", "Dispatcher Monitoring interval set to " + s_monitorInterval);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ++s_instanceCount;
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        boolean bl = true;
        this.setErrorCondition(0);
        String string = iD.getName();
        if (iD == WUS_MONITOR_DISPATCHER) {
            this.setPropertyLogBefore(string, object);
            this.monitorDispatcher(this.defaultNullPropertyValue(object, null));
        } else {
            bl = super.setProperty(iD, object);
        }
        return bl;
    }

    @Override
    public void destroy() {
        if (!this.m_destroyed) {
            --s_instanceCount;
        }
        super.destroy();
    }

    public static boolean isRunning() {
        return s_instanceCount > 0;
    }

    private void monitorDispatcher(String string) {
        block6: {
            try {
                if (s_dispatcherWatch != null) {
                    s_dispatcherWatch.stopDispatcherWatch();
                    s_dispatcherWatch = null;
                    this.log((byte)1, "SessionFunctions.monitorDispatcher()", "Existing dispatcher monitor removed");
                }
                if (string == null) break block6;
                Runform runform = ((ComponentItem)this.getHandler()).getDispatcher();
                AppletContext appletContext = this.getHandler().getApplet().getAppletContext();
                URL uRL = null;
                try {
                    uRL = new URL(string);
                }
                catch (Exception exception) {
                    this.error(500, "SessionFunctions.monitorDispatcher()", this.getTranslatedMessage("ERROR500", exception.toString(), null, null));
                }
                if (uRL != null) {
                    s_dispatcherWatch = new DispatcherWatch(runform, appletContext, uRL, s_monitorInterval);
                    s_dispatcherWatch.start();
                    this.log((byte)1, "SessionFunctions.monitorDispatcher()", "Dispatcher monitor started");
                }
            }
            catch (Exception exception) {
                this.error(17, "SessionFunctions.monitorDispatcher()", this.getTranslatedMessage("ERROR017", exception.toString(), null, null));
            }
        }
    }
}

