/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.host;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.forms.webutil.common.LoggingEngine;
import oracle.forms.webutil.host.Host;
import oracle.forms.webutil.host.OutputSink;

public class HostCommand
extends Thread {
    Host m_pjc = null;
    LoggingEngine m_logger = null;
    OutputSink m_stdOut = null;
    OutputSink m_stdErr = null;
    Process m_proc = null;
    String m_cmd = null;
    int m_rc = -1;
    boolean m_callback = false;
    int m_processHandle = -1;

    public HostCommand(String string, boolean bl, Host host) {
        this.m_cmd = string;
        this.m_callback = bl;
        this.m_pjc = host;
        this.m_logger = host.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            this.m_logger.log((byte)1, "HostCommand.execute()", this.m_cmd);
            Runtime runtime = Runtime.getRuntime();
            if (this.m_pjc.isNextGenHost()) {
                Pattern pattern = Pattern.compile("([^\\s]*\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"[^\\s]*)|[^\\s\"]+");
                Matcher matcher = pattern.matcher(this.m_cmd);
                int n = 0;
                while (matcher.find()) {
                    ++n;
                }
                String[] stringArray = new String[n];
                int n2 = 0;
                matcher.reset();
                while (matcher.find()) {
                    stringArray[n2] = matcher.group().trim();
                    stringArray[n2] = stringArray[n2].replaceAll("\\\\\"", "\"");
                    ++n2;
                }
                stringArray[0] = stringArray[0].replaceAll("\"", "");
                for (int i = 0; i < stringArray.length; ++i) {
                    this.m_logger.log((byte)1, "HostCommand.execute() command array[" + i + "]", stringArray[i]);
                }
                this.m_proc = runtime.exec(stringArray);
            } else {
                this.m_proc = runtime.exec(this.m_cmd);
            }
            this.m_stdOut = new OutputSink(this.m_proc.getInputStream(), this.m_logger);
            this.m_stdErr = new OutputSink(this.m_proc.getErrorStream(), this.m_logger);
            this.m_stdOut.start();
            this.m_stdErr.start();
            this.m_rc = this.m_proc.waitFor();
            this.m_logger.log((byte)1, "HostCommand.execute()", "Return Code = " + this.m_rc);
        }
        catch (IOException iOException) {
            this.m_logger.log((byte)1, "HostCommand.execute()", "IOException: " + iOException.getMessage());
            StringTokenizer stringTokenizer = new StringTokenizer(iOException.getMessage(), "=");
            stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    this.m_rc = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    this.m_rc = -1;
                }
            }
        }
        catch (Exception exception) {
            this.m_pjc.unexpectedError("HostCommand.execute()", exception);
        }
        finally {
            if (this.m_pjc.isBlockAllowHeatBeat() && this.m_pjc.m_dialog != null) {
                while (!this.m_pjc.m_dialog.isVisible()) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.m_pjc.m_dialog.setVisible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.m_pjc.isBlockAllowHeatBeat()) {
            HostCommand hostCommand = this;
            synchronized (hostCommand) {
                if (!this.m_pjc.m_notified) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        this.execute();
        if (this.m_callback) {
            this.m_pjc.dispatchMessage(Host.WUH_CALLBACK_EVENT, "" + this.m_processHandle);
        }
    }

    public int getRC() {
        return this.m_rc;
    }

    public OutputSink getStdOut() {
        return this.m_stdOut;
    }

    public OutputSink getStdErr() {
        return this.m_stdErr;
    }

    public Process getProcess() {
        return this.m_proc;
    }

    public void setProcessHandle(int n) {
        this.m_processHandle = n;
    }
}

