/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.host;

import java.util.Iterator;
import javax.swing.JDialog;
import oracle.forms.engine.Message;
import oracle.forms.engine.MessageHandler;
import oracle.forms.engine.Runform;
import oracle.forms.handler.UICommon;
import oracle.forms.properties.ID;
import oracle.forms.webutil.common.VBeanCommon;
import oracle.forms.webutil.host.HostCommand;
import oracle.forms.webutil.host.OutputSink;

public class Host
extends VBeanCommon
implements Runnable {
    private static final ID WUH_EXECUTE = ID.registerProperty("WUH_EXECUTE");
    private static final ID WUH_PROC_ID = ID.registerProperty("WUH_PROC_ID");
    private static final ID WUH_EXECUTION_MODE = ID.registerProperty("WUH_EXECUTION_MODE");
    private static final int BLOCKING_MODE = 0;
    private static final int NON_BLOCKING_MODE = 1;
    private static final int CALLBACK_MODE = 2;
    protected static final ID WUH_CALLBACK_EVENT = ID.registerProperty("WUH_CALLBACK_EVENT");
    private static final ID WUH_STDOUT = ID.registerProperty("WUH_STDOUT");
    private static final ID WUH_STDERR = ID.registerProperty("WUH_STDERR");
    private static final ID WUH_RC = ID.registerProperty("WUH_RC");
    private static final ID WUH_TERMINATE_PROC = ID.registerProperty("WUH_TERMINATE_PROC");
    private static final ID WUH_CLEAR_PROC = ID.registerProperty("WUH_CLEAR_PROC");
    private int m_mode;
    private int m_process;
    private String m_cmd = null;
    private Iterator m_outputIterator = null;
    private int m_procId = -1;
    private HostCommand m_hc = null;
    JDialog m_dialog = null;
    boolean m_notified = false;

    @Override
    public void setBeanInfo() {
        this.setBeanName("WebUtil Client Side Host Commands");
        this.setBeanShortName("WUH");
    }

    @Override
    public Object getProperty(ID iD) {
        Object object = null;
        if (iD != WUC_CHECK_ERROR) {
            this.setErrorCondition(0);
        }
        String string = iD.getName();
        if (iD == WUH_EXECUTE) {
            this.getPropertyLogBefore(string);
            object = this.executeHost(this.m_cmd, this.m_mode);
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUH_RC) {
            this.getPropertyLogBefore(string);
            object = this.getProcessRC(this.m_process);
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUH_STDOUT) {
            this.getPropertyLogBefore(string);
            object = this.getProcessOutput(this.m_process, false);
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUH_STDERR) {
            this.getPropertyLogBefore(string);
            object = this.getProcessOutput(this.m_process, true);
            this.getPropertyLogAfter(string, object);
        } else {
            object = super.getProperty(iD);
        }
        return object;
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        boolean bl = true;
        this.setErrorCondition(0);
        String string = iD.getName();
        if (iD == WUH_PROC_ID) {
            this.setPropertyLogBefore(string, object);
            this.setProcessHandle(this.defaultNullPropertyValue(object, null));
        } else if (iD == WUH_EXECUTION_MODE) {
            this.setPropertyLogBefore(string, object);
            this.setExecMode(this.defaultNullPropertyValue(object, null));
        } else if (iD == WUH_EXECUTE) {
            if (object.equals("")) {
                this.setPropertyLogBefore(string, object);
                this.executeHost(this.m_cmd, this.m_mode);
            } else {
                this.setPropertyLogBefore(string, object);
                this.setExecCmd(this.defaultNullPropertyValue(object, null));
            }
        } else if (iD == WUH_CLEAR_PROC) {
            this.setPropertyLogBefore(string, object);
            this.cleanupProcess(this.defaultNullPropertyValue(object, null));
        } else if (iD == WUH_TERMINATE_PROC) {
            this.setPropertyLogBefore(string, object);
            this.terminateProcess(this.defaultNullPropertyValue(object, null));
        } else {
            bl = super.setProperty(iD, object);
        }
        return bl;
    }

    private void setProcessHandle(String string) {
        try {
            this.m_process = Integer.parseInt(string);
            if (this.m_process < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.error(401, "Host.setProcessHandle()", this.getTranslatedMessage("ERROR401", string, null, null));
        }
        catch (NullPointerException nullPointerException) {
            this.error(402, "Host.setProcessHandle()", this.getTranslatedMessage("ERROR402", null, null, null));
        }
        catch (Exception exception) {
            this.unexpectedError("Host.setProcessHandle()", exception);
        }
    }

    private void setExecMode(String string) {
        try {
            this.m_mode = Integer.parseInt(string);
            if (this.m_mode < 0 && this.m_mode > 2) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.error(403, "Host.setExecMode()", this.getTranslatedMessage("ERROR403", string, null, null));
        }
        catch (NullPointerException nullPointerException) {
            this.error(404, "Host.setExecMode()", this.getTranslatedMessage("ERROR404", null, null, null));
        }
        catch (Exception exception) {
            this.unexpectedError("Host.setProcessHandle()", exception);
        }
    }

    private void setExecCmd(String string) {
        if (string != null) {
            this.m_cmd = string;
        } else {
            this.error(405, "Host.setExecCmd()", this.getTranslatedMessage("ERROR405", null, null, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeHost(String string, int n) {
        this.log((byte)1, "Host.executeHost()", string);
        if (this.m_dialog != null) {
            this.m_dialog = null;
        }
        this.m_hc = new HostCommand(string, n == 2, this);
        this.m_procId = this.storeInObjectCache(this.m_hc);
        this.m_hc.setProcessHandle(this.m_procId);
        this.m_notified = false;
        this.m_hc.start();
        if (this.isBlockAllowHeatBeat()) {
            if (n == 0) {
                Thread thread = new Thread((Runnable)this, "Invisible Dialog thread");
                thread.start();
            } else {
                HostCommand hostCommand = this.m_hc;
                synchronized (hostCommand) {
                    this.m_hc.notify();
                    this.m_notified = true;
                }
            }
        } else if (n == 0) {
            try {
                this.m_hc.join();
                this.sendResponse();
            }
            catch (Exception exception) {
                this.error(406, "Host.executeHost()", this.getTranslatedMessage("ERROR406", exception.toString(), null, null));
            }
        }
        if (n != 0) {
            this.sendResponse();
        }
        return "" + this.m_procId;
    }

    private String getProcessRC(int n) {
        int n2 = -1;
        Object object = this.getFromObjectCache(n);
        if (object instanceof HostCommand) {
            n2 = ((HostCommand)object).getRC();
        } else {
            this.error(12, "Host.getProcessRC()", this.getTranslatedMessage("ERROR012", "HostCommand", null, null));
        }
        return "" + n2;
    }

    private String getProcessOutput(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Object object;
            if (this.m_outputIterator == null) {
                object = null;
                Object object2 = this.getFromObjectCache(n);
                if (object2 instanceof HostCommand) {
                    object = bl ? ((HostCommand)object2).getStdErr() : ((HostCommand)object2).getStdOut();
                } else {
                    this.error(12, "Host.getProcessOutput()", this.getTranslatedMessage("ERROR012", "HostCommand", null, null));
                }
                if (object != null) {
                    this.m_outputIterator = ((OutputSink)object).dumpOutput();
                    this.log((byte)1, "Host.getProcessOutput()", "Got Output Iterator for " + (bl ? "STDERR" : "STDOUT"));
                } else {
                    this.error(407, "Host.getProcessOutput()", this.getTranslatedMessage("ERROR407", null, null, null));
                }
            }
            if (this.m_outputIterator == null || !this.m_outputIterator.hasNext()) {
                this.log((byte)1, "Host.getProcessOutput()", "Output Iterator is empty");
                stringBuffer.append("X");
                this.m_outputIterator = null;
            } else {
                object = (String)this.m_outputIterator.next();
                if (((String)object).length() > 256) {
                    object = ((String)object).substring(0, 256);
                }
                stringBuffer.append(this.m_outputIterator.hasNext() ? "Y" : "N");
                stringBuffer.append((String)object);
                if (!this.m_outputIterator.hasNext()) {
                    this.m_outputIterator = null;
                }
            }
        }
        catch (Exception exception) {
            this.unexpectedError("Host.getProcessOutput()", exception);
            stringBuffer.append("X");
            this.m_outputIterator = null;
        }
        return stringBuffer.toString();
    }

    private void cleanupProcess(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n < 0) {
                throw new NumberFormatException();
            }
            this.m_process = -1;
            this.m_outputIterator = null;
            this.eraseFromObjectCache(n);
        }
        catch (NumberFormatException numberFormatException) {
            this.error(401, "Host.cleanupProcess()", this.getTranslatedMessage("ERROR401", string, null, null));
        }
        catch (NullPointerException nullPointerException) {
            this.error(402, "Host.cleanupProcess()", this.getTranslatedMessage("ERROR402", null, null, null));
        }
        catch (Exception exception) {
            this.unexpectedError("Host.cleanupProcess()", exception);
        }
    }

    private void terminateProcess(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n < 0) {
                throw new NumberFormatException();
            }
            Object object = this.getFromObjectCache(n);
            if (object instanceof HostCommand) {
                Process process = ((HostCommand)object).getProcess();
                if (process != null) {
                    try {
                        int n2 = process.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        process.destroy();
                    }
                }
            } else {
                this.error(12, "Host.terminateProcess()", this.getTranslatedMessage("ERROR012", "HostCommand", null, null));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.error(401, "Host.terminateProcess()", this.getTranslatedMessage("ERROR401", string, null, null));
        }
        catch (NullPointerException nullPointerException) {
            this.error(402, "Host.terminateProcess()", this.getTranslatedMessage("ERROR402", null, null, null));
        }
        catch (Exception exception) {
            this.unexpectedError("Host.terminateProcess()", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.m_mode == 0) {
            this.m_dialog = new JDialog(this.getFrame(), "Command in process...", true);
            this.m_dialog.setUndecorated(true);
            HostCommand hostCommand = this.m_hc;
            synchronized (hostCommand) {
                this.m_hc.notify();
                this.m_notified = true;
            }
            this.m_dialog.setVisible(true);
            this.sendResponse();
        }
    }

    private void sendResponse() {
        Message message = new Message(4, 0, ((MessageHandler)((Object)this.getHandler())).getHandlerId());
        message.add(ID.CUSTOM_PROPERTY.toID(), "" + this.m_procId);
        Runform runform = ((UICommon)this.getHandler()).getDispatcher();
        runform.onMessage(message, 0);
    }
}

