/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.fileTransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import oracle.forms.common.Base64Basic;
import oracle.forms.webutil.common.ProgressThread;
import oracle.forms.webutil.fileTransfer.FileTransfer;
import oracle.forms.webutil.fileTransfer.TransferAgent;

public class UploadAgent
extends TransferAgent {
    FileInputStream m_input = null;

    public UploadAgent(FileTransfer fileTransfer, File file, int n, int n2, boolean bl, boolean bl2, String string, String string2) {
        super(fileTransfer, file, n, n2, bl, bl2);
        String string3 = null;
        try {
            string3 = file.getPath();
            this.m_fileSize = (int)file.length();
            if (this.m_fileSize == 0) {
                throw new FileNotFoundException();
            }
            this.m_chunks = this.m_fileSize / this.m_maxBytes;
            if (this.m_fileSize % this.m_maxBytes > 0) {
                ++this.m_chunks;
            }
            this.m_input = new FileInputStream(file);
            fileTransfer.log((byte)1, "UploadAgent()", "File Opened:" + string3);
            this.m_operable = true;
            if (bl2) {
                this.m_progress = new ProgressThread(this.m_bean.getFrame(), this.m_fileSize, string, string2, string3);
                this.m_progress.start();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileTransfer.error(106, "UploadAgent()", fileTransfer.getTranslatedMessage("ERROR106", string3, null, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.m_operable) {
                for (int i = 0; i < this.m_chunks; ++i) {
                    String string = this.getDataInt();
                    if (string == null) {
                        string = "";
                    }
                    UploadAgent uploadAgent = this;
                    synchronized (uploadAgent) {
                        this.m_bean.dispatchMessage(FileTransfer.WUT_TRANSFER_EVENT, string);
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
            }
            this.m_bean.reset();
            if (this.m_withProgress && this.m_progress != null) {
                this.m_progress.dispose();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public String getData() {
        if (this.m_operable) {
            if (this.m_async) {
                return null;
            }
            return this.getDataInt();
        }
        return null;
    }

    private String getDataInt() {
        String string = null;
        try {
            byte[] byArray = new byte[this.m_maxBytes];
            int n = this.m_input.read(byArray);
            this.m_bytesTransferred += n;
            if (n > 0) {
                if (n == this.m_maxBytes) {
                    string = Base64Basic.encodeToString(byArray);
                } else {
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    string = Base64Basic.encodeToString(byArray2);
                }
                if (this.m_withProgress) {
                    this.m_progress.setProgress(this.m_bytesTransferred);
                }
            } else {
                this.m_bean.error(102, "UploadAgent.getData()", this.m_bean.getTranslatedMessage("ERROR102"));
                this.m_operable = false;
            }
            if (this.isFinished()) {
                this.m_input.close();
                this.m_bean.log((byte)1, "UploadAgent.getDataInt()", "File Closed");
            }
        }
        catch (Exception exception) {
            this.m_bean.error(109, "UploadAgent.getData()", this.m_bean.getTranslatedMessage("ERROR109", this.m_clientFile.getName(), exception.toString(), null));
            this.m_operable = false;
        }
        return string;
    }
}

