/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.fileTransfer;

import java.io.File;
import java.util.StringTokenizer;
import oracle.forms.handler.IHandler;
import oracle.forms.properties.ID;
import oracle.forms.webutil.common.VBeanCommon;
import oracle.forms.webutil.fileTransfer.DownloadAgent;
import oracle.forms.webutil.fileTransfer.TransferAgent;
import oracle.forms.webutil.fileTransfer.TransferAgentBusy;
import oracle.forms.webutil.fileTransfer.UploadAgent;

public class FileTransfer
extends VBeanCommon {
    private static final ID WUT_FILE_INFO = ID.registerProperty("WUT_FILE_INFO");
    protected static final ID WUT_TRANSFER = ID.registerProperty("WUT_TRANSFER");
    protected static final ID WUT_TRANSFER_EVENT = ID.registerProperty("WUT_TRANSFER_EVENT");
    protected static final ID WUT_STATUS = ID.registerProperty("WUT_STATUS");
    protected static final ID WUT_MAX_BYTES = ID.registerProperty("WUT_MAX_BYTES");
    int m_fileSize = 0;
    File m_file = null;
    boolean m_withProgress = false;
    String m_progressTitle = null;
    String m_progressSubTitle = null;
    boolean m_asyncMode = false;
    static TransferAgent m_agent = null;
    boolean m_upload = true;
    static boolean s_locked = false;
    static int s_transferMaxBytes = -1;

    @Override
    public void setBeanInfo() {
        this.setBeanName("WebUtil File Transfer Bean");
        this.setBeanShortName("WUT");
    }

    @Override
    public void init(IHandler iHandler) {
        super.init(iHandler);
        if (s_transferMaxBytes == -1) {
            s_transferMaxBytes = 24573;
            String string = iHandler.getApplet().getParameter("WebUtilMaxTransferSize");
            try {
                if (string != null && !string.equalsIgnoreCase("")) {
                    s_transferMaxBytes = Integer.parseInt(string);
                    if (s_transferMaxBytes > 24573) {
                        s_transferMaxBytes = 24573;
                    }
                    this.log((byte)1, "SessionFunctions.init()", "Max Transfer chunk size set to " + s_transferMaxBytes);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getProperty(ID iD) {
        Object object = null;
        if (iD != WUC_CHECK_ERROR) {
            this.setErrorCondition(0);
        }
        String string = iD.getName();
        if (iD == WUT_FILE_INFO) {
            this.getPropertyLogBefore(string);
            int n = this.m_fileSize / s_transferMaxBytes;
            if (this.m_fileSize % s_transferMaxBytes > 0) {
                ++n;
            }
            object = "" + this.m_fileSize + "|" + n;
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUT_TRANSFER) {
            object = this.getFileChunk();
            if (object == null) {
                object = "";
            }
        } else if (iD == WUT_STATUS) {
            this.getPropertyLogBefore(string);
            object = s_locked ? "BUSY" : "FREE";
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUT_MAX_BYTES) {
            this.getPropertyLogBefore(string);
            object = "" + s_transferMaxBytes;
            this.getPropertyLogAfter(string, object);
        } else {
            object = super.getProperty(iD);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setProperty(ID iD, Object object) {
        boolean bl = true;
        this.setErrorCondition(0);
        String string = iD.getName();
        if (iD == WUT_FILE_INFO) {
            this.setPropertyLogBefore(string, object);
            this.defineFile(this.defaultNullPropertyValue(object, null));
        } else if (iD == WUT_TRANSFER) {
            this.setFileChunk(this.defaultNullPropertyValue(object, null));
        } else if (iD == WUT_TRANSFER_EVENT) {
            if (m_agent != null) {
                TransferAgent transferAgent = m_agent;
                synchronized (transferAgent) {
                    m_agent.notify();
                }
            }
        } else {
            bl = super.setProperty(iD, object);
        }
        return bl;
    }

    private String getFileChunk() {
        String string = null;
        UploadAgent uploadAgent = null;
        try {
            if (m_agent == null) {
                if (s_locked) {
                    throw new TransferAgentBusy();
                }
                uploadAgent = new UploadAgent(this, this.m_file, -1, s_transferMaxBytes, this.m_asyncMode, this.m_withProgress, this.m_progressTitle, this.m_progressSubTitle);
                m_agent = uploadAgent;
                s_locked = true;
            } else {
                uploadAgent = (UploadAgent)m_agent;
            }
            if (uploadAgent.isOperable()) {
                string = uploadAgent.getData();
                if (!this.m_asyncMode) {
                    if (uploadAgent.isFinished()) {
                        m_agent = null;
                        s_locked = false;
                    }
                } else {
                    uploadAgent.start();
                }
            } else {
                this.reset();
            }
        }
        catch (TransferAgentBusy transferAgentBusy) {
            this.error(103, "FileTransfer.getFileChunk()", this.getTranslatedMessage("ERROR103", this.m_file.getName(), null, null));
        }
        return string;
    }

    private void setFileChunk(String string) {
        DownloadAgent downloadAgent = null;
        try {
            if (m_agent == null) {
                if (s_locked) {
                    throw new TransferAgentBusy();
                }
                downloadAgent = new DownloadAgent(this, this.m_file, this.m_fileSize, s_transferMaxBytes, false, this.m_withProgress, this.m_progressTitle, this.m_progressSubTitle);
                m_agent = downloadAgent;
                s_locked = true;
            } else {
                downloadAgent = (DownloadAgent)m_agent;
            }
            if (downloadAgent.isOperable()) {
                downloadAgent.setData(string);
                if (downloadAgent.isFinished()) {
                    this.reset();
                }
            } else {
                this.reset();
            }
        }
        catch (TransferAgentBusy transferAgentBusy) {
            this.error(104, "FileTransfer.getFileChunk()", this.getTranslatedMessage("ERROR104", this.m_file.getName(), null, null));
        }
    }

    private void defineFile(String string) {
        if (string != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                this.m_file = new File(stringTokenizer.nextToken());
                int n = Integer.parseInt(stringTokenizer.nextToken());
                this.m_fileSize = n == 0 && this.m_file.exists() ? (int)this.m_file.length() : n;
                this.m_asyncMode = stringTokenizer.nextToken().equalsIgnoreCase("A");
                this.m_withProgress = stringTokenizer.nextToken().equalsIgnoreCase("Y");
                if (this.m_withProgress) {
                    this.m_progressTitle = stringTokenizer.nextToken();
                    this.m_progressSubTitle = stringTokenizer.nextToken();
                }
            }
            catch (Exception exception) {
                this.error(100, "FileTransfer.defineFile()", this.getTranslatedMessage("ERROR100", string, null, null));
                this.log((byte)1, "FileTransfer.defineFile()", exception.toString());
            }
        } else {
            this.error(100, "FileTransfer.defineFile()", this.getTranslatedMessage("ERROR100", "<null>", null, null));
        }
    }

    public void reset() {
        m_agent = null;
        s_locked = false;
    }

    public static synchronized TransferAgent getAgent() {
        return m_agent;
    }
}

