/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.fileTransfer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import oracle.forms.common.Base64Basic;
import oracle.forms.webutil.common.ProgressThread;
import oracle.forms.webutil.fileTransfer.FileTransfer;
import oracle.forms.webutil.fileTransfer.TransferAgent;

public class DownloadAgent
extends TransferAgent {
    FileOutputStream m_output = null;

    public DownloadAgent(FileTransfer fileTransfer, File file, int n, int n2, boolean bl, boolean bl2, String string, String string2) {
        super(fileTransfer, file, n, n2, bl, bl2);
        String string3 = null;
        try {
            string3 = file.getPath();
            this.m_fileSize = n;
            this.m_chunks = this.m_fileSize / this.m_maxBytes;
            if (this.m_fileSize % this.m_maxBytes > 0) {
                ++this.m_chunks;
            }
            this.m_output = new FileOutputStream(file);
            fileTransfer.log((byte)1, "DownloadAgent()", "File Opened:" + string3);
            this.m_operable = true;
            if (bl2) {
                this.m_progress = new ProgressThread(this.m_bean.getFrame(), this.m_fileSize, string, string2, string3);
                this.m_progress.start();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileTransfer.error(105, "DownloadAgent()", fileTransfer.getTranslatedMessage("ERROR105", string3, null, null));
        }
    }

    @Override
    public void run() {
    }

    public void setData(String string) {
        byte[] byArray = null;
        if (string == null || string.length() == 0) {
            this.m_bean.error(107, "DownloadAgent.setData()", this.m_bean.getTranslatedMessage("ERROR107"));
        } else {
            try {
                byArray = Base64Basic.decode(string);
                this.m_bytesTransferred += byArray.length;
                this.m_output.write(byArray);
                if (this.m_withProgress) {
                    this.m_progress.setProgress(this.m_bytesTransferred);
                }
                if (this.isFinished()) {
                    this.m_output.close();
                    this.m_bean.log((byte)1, "DownloadAgent.setData()", "File Closed");
                    if (this.m_withProgress) {
                        this.m_progress = null;
                    }
                }
            }
            catch (IOException iOException) {
                this.m_bean.error(108, "DownloadAgent.setData()", this.m_bean.getTranslatedMessage("ERROR108"));
            }
        }
    }
}

