/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.fileTransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import oracle.forms.common.Base64Basic;

public class AppServerFileWriter {
    int m_lastError = 0;
    String m_lastErrorArgs = null;
    File m_file = null;
    FileOutputStream m_output = null;
    int m_MAX_READ_BUFF_LEN = 32768;

    public boolean openFile(String string) {
        boolean bl = false;
        try {
            if (string != null) {
                this.m_file = new File(string);
                this.m_output = new FileOutputStream(this.m_file);
                bl = true;
            } else {
                this.m_lastError = 117;
                this.m_lastErrorArgs = null;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_lastError = 132;
            this.m_lastErrorArgs = string;
        }
        catch (Exception exception) {
            this.m_lastError = 123;
            this.m_lastErrorArgs = string;
        }
        return bl;
    }

    public boolean WriteData(String string) {
        boolean bl = false;
        byte[] byArray = null;
        try {
            byArray = Base64Basic.decode(string);
            this.m_output.write(byArray);
            bl = true;
        }
        catch (Exception exception) {
            this.m_lastError = 124;
            this.m_lastErrorArgs = this.m_file.getPath();
        }
        return bl;
    }

    public boolean closeFile(int n) {
        boolean bl = false;
        try {
            this.m_output.close();
            this.m_output = null;
            if ((long)n == this.m_file.length()) {
                bl = true;
            } else {
                this.m_lastError = 125;
                this.m_lastErrorArgs = this.m_file.getPath() + "|" + n + "|" + this.m_file.length();
            }
        }
        catch (Exception exception) {
            this.m_lastError = 126;
            this.m_lastErrorArgs = this.m_file.getPath();
        }
        return bl;
    }

    public int getLastError() {
        return this.m_lastError;
    }

    public String getLastErrorArgs() {
        if (this.m_lastErrorArgs == null) {
            return new String("");
        }
        return this.m_lastErrorArgs;
    }

    public boolean decodeBASE64File(String string) {
        boolean bl = false;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            this.decodeBuffer(string, fileInputStream, this.m_output);
            fileInputStream.close();
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_lastError = 118;
            this.m_lastErrorArgs = string + " (a temporary BASE64 file)";
        }
        catch (IOException iOException) {
            this.m_lastError = 126;
            this.m_lastErrorArgs = string + " (a temporary BASE64 file)";
        }
        return bl;
    }

    private void decodeBuffer(String string, FileInputStream fileInputStream, FileOutputStream fileOutputStream) {
        int n;
        int n2;
        int n3;
        byte[] byArray = new byte[this.m_MAX_READ_BUFF_LEN + 3];
        byte[] byArray2 = new byte[this.m_MAX_READ_BUFF_LEN / 4 * 3 + 2];
        boolean bl = true;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        try {
            n3 = fileInputStream.read(byArray, n5, this.m_MAX_READ_BUFF_LEN);
        }
        catch (IOException iOException) {
            this.m_lastError = 119;
            this.m_lastErrorArgs = string + " (a temporary BASE64 file)";
            return;
        }
        while (n3 != -1) {
            n4 = this.removeBadBytes(byArray, n5, n3 + n5);
            n6 = n4 / 4 * 4;
            n2 = 0;
            n = 0;
            n5 = 0;
            while (n5 < n6) {
                n2 = this.uByteToInt(byArray[n5++]) << 18;
                n2 |= this.uByteToInt(byArray[n5++]) << 12;
                n2 |= this.uByteToInt(byArray[n5++]) << 6;
                byArray2[n + 2] = (byte)((n2 |= this.uByteToInt(byArray[n5++])) & 0xFF);
                byArray2[n + 1] = (byte)((n2 >>= 8) & 0xFF);
                byArray2[n] = (byte)(n2 >> 8);
                n += 3;
            }
            for (int i = 0; i < n4 - n6; ++i) {
                byArray[i] = byArray[n5++];
            }
            n5 = n4 - n6;
            try {
                n3 = fileInputStream.read(byArray, n5, this.m_MAX_READ_BUFF_LEN);
            }
            catch (IOException iOException) {
                this.m_lastError = 119;
                this.m_lastErrorArgs = string + " (a temporary BASE64 file)";
                n3 = -1;
            }
            if (n <= 0) continue;
            try {
                fileOutputStream.write(byArray2, 0, n);
            }
            catch (IOException iOException) {
                this.m_lastError = 124;
                this.m_lastErrorArgs = this.m_file.getPath();
            }
        }
        n5 = 0;
        n = 0;
        if (n4 - n6 == 2) {
            byArray2[n] = (byte)(this.uByteToInt(byArray[n5++]) << 2);
            int n7 = n++;
            byArray2[n7] = (byte)(byArray2[n7] | (byte)(this.uByteToInt(byArray[n5++]) >> 4));
            try {
                fileOutputStream.write(byArray2, 0, n);
            }
            catch (IOException iOException) {
                this.m_lastError = 124;
                this.m_lastErrorArgs = this.m_file.getPath();
            }
        } else if (n4 - n6 == 3) {
            n2 = this.uByteToInt(byArray[n5++]) << 10;
            n2 |= this.uByteToInt(byArray[n5++]) << 4;
            byArray2[n + 1] = (byte)((n2 |= this.uByteToInt(byArray[n5++]) >> 2) & 0xFF);
            byArray2[n] = (byte)(n2 >> 8);
            n += 2;
            try {
                fileOutputStream.write(byArray2, 0, n);
            }
            catch (IOException iOException) {
                this.m_lastError = 124;
                this.m_lastErrorArgs = this.m_file.getPath();
            }
        }
    }

    private int uByteToInt(byte by) {
        if (by >= 0) {
            return by;
        }
        return 256 + by;
    }

    private int charToInt(byte by) {
        if (by >= 65 && by <= 90) {
            return by - 65;
        }
        if (by >= 97 && by <= 122) {
            return by - 71;
        }
        if (by >= 48 && by <= 57) {
            return by + 4;
        }
        if (by == 43) {
            return 62;
        }
        if (by == 47) {
            return 63;
        }
        return -1;
    }

    private int removeBadBytes(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        for (n3 = n; n3 < n2; ++n3) {
            int n5 = this.charToInt(byArray[n3]);
            if (n5 == -1) continue;
            byArray[n4++] = (byte)n5;
        }
        return n4;
    }
}

