/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.fileTransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import oracle.forms.common.Base64Basic;

public class AppServerFileReader {
    File m_file = null;
    int m_maxBytes = 24573;
    int m_fileSize = 0;
    int m_bytesRead = 0;
    int m_chunks = 0;
    int m_lastError = 0;
    String m_lastErrorArgs = null;
    FileInputStream m_input = null;

    public boolean openFile(String string, int n) {
        boolean bl = false;
        try {
            if (n > 0 && n <= 24573) {
                this.m_maxBytes = n;
            }
            if (string != null) {
                this.m_file = new File(string);
                this.m_fileSize = (int)this.m_file.length();
                if (this.m_fileSize == 0) {
                    throw new FileNotFoundException();
                }
                this.m_chunks = this.m_fileSize / this.m_maxBytes;
                if (this.m_fileSize % this.m_maxBytes > 0) {
                    ++this.m_chunks;
                }
                this.m_input = new FileInputStream(this.m_file);
                bl = true;
            } else {
                this.m_lastError = 117;
                this.m_lastErrorArgs = null;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_lastError = 118;
            this.m_lastErrorArgs = string;
        }
        return bl;
    }

    public String readData() {
        String string = null;
        try {
            byte[] byArray = new byte[this.m_maxBytes];
            int n = this.m_input.read(byArray);
            this.m_bytesRead += n;
            if (n > 0) {
                if (n == this.m_maxBytes) {
                    string = Base64Basic.encodeToString(byArray);
                } else {
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    string = Base64Basic.encodeToString(byArray2);
                }
            } else {
                this.m_lastError = 120;
                this.m_lastErrorArgs = this.m_file.getPath();
            }
        }
        catch (Exception exception) {
            this.m_lastError = 119;
            this.m_lastErrorArgs = this.m_file.getPath();
        }
        return string;
    }

    public boolean closeFile() {
        boolean bl = false;
        try {
            this.m_input.close();
            this.m_input = null;
            bl = true;
        }
        catch (IOException iOException) {
            this.m_lastError = 126;
            this.m_lastErrorArgs = this.m_file.getPath();
        }
        return bl;
    }

    public int getSourceLength() {
        return this.m_fileSize;
    }

    public int getSourceChunks() {
        return this.m_chunks;
    }

    public int getLastError() {
        return this.m_lastError;
    }

    public String getLastErrorArgs() {
        if (this.m_lastErrorArgs == null) {
            return new String("");
        }
        return this.m_lastErrorArgs;
    }

    public static String getSeparator() {
        return File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean encodeBASE64File(String string) {
        Object object;
        byte[] byArray;
        block11: {
            byArray = null;
            try {
                object = new byte[this.m_maxBytes];
                int n = this.m_input.read((byte[])object);
                this.m_bytesRead += n;
                if (n > 0) {
                    if (n == this.m_maxBytes) {
                        byArray = this.encodeToBASE64((byte[])object);
                    } else {
                        byte[] byArray2 = new byte[n];
                        System.arraycopy(object, 0, byArray2, 0, n);
                        byArray = this.encodeToBASE64(byArray2);
                    }
                    break block11;
                }
                this.m_lastError = 120;
                this.m_lastErrorArgs = this.m_file.getPath();
                return false;
            }
            catch (Exception exception) {
                this.m_lastError = 119;
                this.m_lastErrorArgs = this.m_file.getPath();
                return false;
            }
        }
        try {
            object = new FileOutputStream(string);
            try {
                ((FileOutputStream)object).write(byArray);
            }
            finally {
                ((FileOutputStream)object).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_lastError = 120;
            this.m_lastErrorArgs = string + " (a temporary BASE64 file)";
            return false;
        }
        catch (IOException iOException) {
            this.m_lastError = 119;
            this.m_lastErrorArgs = string + " (a temporary BASE64 file)";
            return false;
        }
        return true;
    }

    private byte[] encodeToBASE64(byte[] byArray) {
        if (byArray.length <= 0) {
            return null;
        }
        byte[] byArray2 = new byte[(byArray.length + 2) / 3 * 4];
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        while (n + 2 < n3) {
            byArray2[n2++] = this.intToChar(this.uByteToInt(byArray[n]) >> 2 & 0x3F);
            byArray2[n2++] = this.intToChar((this.uByteToInt(byArray[n]) << 4 | this.uByteToInt(byArray[n + 1]) >> 4) & 0x3F);
            byArray2[n2++] = this.intToChar((this.uByteToInt(byArray[n + 1]) << 2 | this.uByteToInt(byArray[n + 2]) >> 6) & 0x3F);
            byArray2[n2++] = this.intToChar(this.uByteToInt(byArray[n + 2]) & 0x3F);
            n += 3;
        }
        if (n + 1 < n3) {
            byArray2[n2++] = this.intToChar(this.uByteToInt(byArray[n]) >> 2 & 0x3F);
            byArray2[n2++] = this.intToChar((this.uByteToInt(byArray[n]) << 4 | this.uByteToInt(byArray[n + 1]) >> 4) & 0x3F);
            byArray2[n2++] = this.intToChar(this.uByteToInt(byArray[n + 1]) << 2 & 0x3F);
            byArray2[n2++] = 61;
        } else if (n < n3) {
            byArray2[n2++] = this.intToChar(this.uByteToInt(byArray[n]) >> 2 & 0x3F);
            byArray2[n2++] = this.intToChar(this.uByteToInt(byArray[n]) << 4 & 0x3F);
            byArray2[n2++] = 61;
            byArray2[n2++] = 61;
        }
        return byArray2;
    }

    private int uByteToInt(byte by) {
        if (by >= 0) {
            return by;
        }
        return 256 + by;
    }

    private byte intToChar(int n) {
        if (n < 26) {
            return (byte)(n + 65);
        }
        if (n < 52) {
            return (byte)(n + 97 - 26);
        }
        if (n < 62) {
            return (byte)(n + 48 - 52);
        }
        if (n == 62) {
            return 43;
        }
        return 47;
    }
}

