/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.file;

import java.io.File;
import java.io.FileFilter;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class WebUtilFileListFilter
implements FileFilter {
    RE m_pattern = null;
    boolean m_matchAll = false;

    public WebUtilFileListFilter(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            if (string == null || string.equals("*") || string.equals("*.*") || string.trim().equals("")) {
                this.m_matchAll = true;
            } else {
                String string2 = string.toLowerCase();
                char c = string2.charAt(0);
                char c2 = string2.charAt(string2.length() - 1);
                block7: for (int i = 0; i < string2.length(); ++i) {
                    char c3 = string2.charAt(i);
                    switch (c3) {
                        case '$': 
                        case '(': 
                        case ')': 
                        case '+': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case '^': 
                        case '{': 
                        case '|': 
                        case '}': {
                            stringBuffer.append("\\");
                            stringBuffer.append(c3);
                            continue block7;
                        }
                        case '?': {
                            stringBuffer.append('.');
                            continue block7;
                        }
                        case '*': {
                            stringBuffer.append('.');
                            stringBuffer.append('*');
                            continue block7;
                        }
                        default: {
                            stringBuffer.append(c3);
                        }
                    }
                }
                if (c != '*') {
                    stringBuffer.insert(0, '^');
                }
                if (c2 != '*') {
                    stringBuffer.append('$');
                }
                this.m_pattern = new RE(stringBuffer.toString());
            }
        }
        catch (RESyntaxException rESyntaxException) {
            System.out.println("FileFilter: Invalid Regular Expression supplied " + stringBuffer + "(Source=" + string + ")");
            this.m_matchAll = true;
        }
    }

    @Override
    public boolean accept(File file) {
        boolean bl = false;
        String string = file.getName().toLowerCase();
        if (file.isDirectory()) {
            bl = true;
        } else if (this.m_matchAll || this.m_pattern.match(string)) {
            bl = true;
        }
        return bl;
    }
}

