/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.file;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class WebUtilFileFilter
extends FileFilter {
    String m_mask = null;
    String m_description = null;
    RE m_pattern = null;
    boolean m_matchAll = false;

    public WebUtilFileFilter(String string, String string2) {
        this.m_mask = string;
        StringBuffer stringBuffer = new StringBuffer("");
        try {
            if (string == null || string.equals("*") || string.equals("*.*")) {
                this.m_matchAll = true;
            } else {
                String string3 = string.toLowerCase();
                char c = string3.charAt(0);
                char c2 = string3.charAt(string3.length() - 1);
                block8: for (int i = 0; i < string3.length(); ++i) {
                    char c3 = string3.charAt(i);
                    switch (c3) {
                        case '$': 
                        case '(': 
                        case ')': 
                        case '+': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case '^': 
                        case '{': 
                        case '|': 
                        case '}': {
                            stringBuffer.append("\\");
                            stringBuffer.append(c3);
                            continue block8;
                        }
                        case '?': {
                            stringBuffer.append('.');
                            continue block8;
                        }
                        case ';': {
                            stringBuffer.append('|');
                            continue block8;
                        }
                        case '*': {
                            stringBuffer.append('.');
                            stringBuffer.append('*');
                            continue block8;
                        }
                        default: {
                            stringBuffer.append(c3);
                        }
                    }
                }
                if (c != '*') {
                    stringBuffer.insert(0, '^');
                }
                if (c2 != '*') {
                    stringBuffer.append('$');
                }
                this.m_pattern = new RE(stringBuffer.toString());
            }
        }
        catch (RESyntaxException rESyntaxException) {
            System.out.println("FileFilter: Invalid Regular Expression supplied " + stringBuffer + "(Source=" + string + ")");
            this.m_matchAll = true;
        }
        this.m_description = string2 != null ? string2 : "All Files (*.*)";
    }

    @Override
    public boolean accept(File file) {
        boolean bl = false;
        String string = file.getName().toLowerCase();
        if (file.isDirectory()) {
            bl = true;
        } else if (this.m_matchAll || this.m_pattern.match(string)) {
            bl = true;
        }
        return bl;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public String getMask() {
        return this.m_mask;
    }
}

