/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import oracle.forms.common.CharsetMapper;
import oracle.forms.engine.Message;
import oracle.forms.engine.MessageHandler;
import oracle.forms.engine.Runform;
import oracle.forms.handler.UICommon;
import oracle.forms.properties.ID;
import oracle.forms.webutil.common.VBeanCommon;
import oracle.forms.webutil.file.FFileChooser;
import oracle.forms.webutil.file.WebUtilFileFilter;
import oracle.forms.webutil.file.WebUtilFileListFilter;

public class FileFunctions
extends VBeanCommon
implements Runnable {
    private static final ID WUF_TEXTIO_FILEMODE = ID.registerProperty("WUF_TEXTIO_FILEMODE");
    private static final ID WUF_TEXTIO_CHARSET = ID.registerProperty("WUF_TEXTIO_CHARSET");
    private static final ID WUF_TEXTIO_OPEN = ID.registerProperty("WUF_TEXTIO_OPEN");
    private static final ID WUF_TEXTIO_CLOSE = ID.registerProperty("WUF_TEXTIO_CLOSE");
    private static final ID WUF_TEXTIO_HANDLE = ID.registerProperty("WUF_TEXTIO_HANDLE");
    private static final ID WUF_TEXTIO_GETLINE = ID.registerProperty("WUF_TEXTIO_GETLINE");
    private static final ID WUF_TEXTIO_PUT = ID.registerProperty("WUF_TEXTIO_PUT");
    private static final ID WUF_TEXTIO_NEWLINE = ID.registerProperty("WUF_TEXTIO_NEWLINE");
    private static final ID WUF_TEXTIO_ARG = ID.registerProperty("WUF_TEXTIO_ARG");
    private static final ID WUF_TEXTIO_PUTF = ID.registerProperty("WUF_TEXTIO_PUTF");
    private static final ID WUF_GFN_DIRNAME = ID.registerProperty("WUF_GFN_DIRNAME");
    private static final ID WUF_GFN_MESSAGE = ID.registerProperty("WUF_GFN_MESSAGE");
    private static final ID WUF_GFN_SAVEFILE = ID.registerProperty("WUF_GFN_SAVEFILE");
    private static final ID WUF_GFN_OPENFILE = ID.registerProperty("WUF_GFN_OPENFILE");
    private static final ID WUF_GFN_OPENDIR = ID.registerProperty("WUF_GFN_OPENDIR");
    private static final ID WUF_FILENAME = ID.registerProperty("WUF_FILENAME");
    private static final ID WUF_FILTER = ID.registerProperty("WUF_FILTER");
    private static final ID WUF_GFN_SELECTION_MADE = ID.registerProperty("WUF_GFN_SELECTION_MADE");
    private static final ID WUF_GFN_MULTISELECT = ID.registerProperty("WUF_GFN_MULTISELECT");
    private static final ID WUF_FILE_ATTRIBUTE = ID.registerProperty("WUF_FILE_ATTRIBUTE");
    private static final ID WUF_CREATE_DIRECTORY = ID.registerProperty("WUF_CREATE_DIRECTORY");
    private static final ID WUF_RENAME_FILE = ID.registerProperty("WUF_RENAME_FILE");
    private static final ID WUF_DELETE_FILE = ID.registerProperty("WUF_DELETE_FILE");
    private static final ID WUF_COPY_FILE = ID.registerProperty("WUF_COPY_FILE");
    private static final ID WUF_DIRECTORY_LIST = ID.registerProperty("WUF_DIRECTORY_LIST");
    private static final ID WUF_DIRECTORY_ROOT_LIST = ID.registerProperty("WUF_DIRECTORY_ROOT_LIST");
    private static final ID WUF_NO_DIRECTORIES = ID.registerProperty("WUF_NO_DIRECTORIES");
    private static final char SEP = '\n';
    private static final int ATTR_EXISTS = 1;
    private static final int ATTR_READABLE = 2;
    private static final int ATTR_WRITABLE = 3;
    private static final int ATTR_IS_DIRECTORY = 4;
    private static final int ATTR_IS_HIDDEN = 5;
    private static final int ATTR_SIZE = 6;
    private static final int ATTR_MOD_EPOCH = 7;
    private static final int ATTR_MOD_DATE = 8;
    private static final int WRITE_TO_CONSOLE = -2;
    private String m_fileName = null;
    private String m_fileMode = null;
    private Charset m_charSet = Charset.defaultCharset();
    private int m_fileID = -1;
    private String[] m_putfArgs = new String[5];
    private int m_putfArgCount = -1;
    private boolean openFile = false;
    private boolean directoryList = false;
    private String runResult = null;
    private String m_gfnDirname = null;
    private String m_gfnMessage = null;
    private boolean m_gfnSelectionMade = false;
    private boolean m_gfnMultiSelect = false;
    private static String m_gfnLastDir = null;
    private int m_attr = 0;
    private String m_newFileName = null;
    private String m_filterString = null;
    private boolean m_incDirs = true;

    @Override
    public void setBeanInfo() {
        this.setBeanName("WebUtil Client Side File Functions");
        this.setBeanShortName("WUF");
    }

    @Override
    public Object getProperty(ID iD) {
        Object object = null;
        if (iD != WUC_CHECK_ERROR) {
            this.setErrorCondition(0);
        }
        String string = iD.getName();
        if (iD == WUF_TEXTIO_OPEN) {
            this.getPropertyLogBefore(string);
            object = this.fopen();
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUF_TEXTIO_GETLINE) {
            this.getPropertyLogBefore(string);
            object = this.getLine();
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUF_GFN_SELECTION_MADE) {
            this.getPropertyLogBefore(string);
            object = this.m_gfnSelectionMade ? "TRUE" : "FALSE";
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUF_FILE_ATTRIBUTE) {
            this.getPropertyLogBefore(string);
            object = this.checkFileAttribute(this.m_fileName, this.m_attr);
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUF_CREATE_DIRECTORY) {
            this.getPropertyLogBefore(string);
            object = this.createDir(this.m_fileName);
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUF_RENAME_FILE) {
            this.getPropertyLogBefore(string);
            object = this.renameFile(this.m_fileName, this.m_newFileName);
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUF_DELETE_FILE) {
            this.getPropertyLogBefore(string);
            object = this.deleteFile(this.m_fileName);
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUF_COPY_FILE) {
            this.getPropertyLogBefore(string);
            object = this.copyFile(this.m_fileName, this.m_newFileName);
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUF_DIRECTORY_LIST) {
            this.getPropertyLogBefore(string);
            object = this.listDir(this.m_fileName, this.m_filterString, this.m_incDirs);
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUF_DIRECTORY_ROOT_LIST) {
            this.getPropertyLogBefore(string);
            object = this.listDir(null, null, true);
            this.getPropertyLogAfter(string, object);
        } else {
            object = super.getProperty(iD);
        }
        return object;
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        boolean bl = true;
        this.setErrorCondition(0);
        String string = iD.getName();
        if (iD == WUF_FILENAME) {
            this.setPropertyLogBefore(string, object);
            this.m_fileName = this.defaultNullPropertyValue(object, null);
        } else if (iD == WUF_TEXTIO_FILEMODE) {
            this.setPropertyLogBefore(string, object);
            this.m_fileMode = this.defaultNullPropertyValue(object, "r").toLowerCase();
        } else if (iD == WUF_TEXTIO_CHARSET) {
            this.setPropertyLogBefore(string, object);
            this.setFileEncoding(this.defaultNullPropertyValue(object, "(null)"));
        } else if (iD == WUF_TEXTIO_CLOSE) {
            this.setPropertyLogBefore(string, object);
            this.fclose(this.defaultNullPropertyValue(object, null));
        } else if (iD == WUF_TEXTIO_HANDLE) {
            this.setPropertyLogBefore(string, object);
            this.setHandle(this.defaultNullPropertyValue(object, null));
        } else if (iD == WUF_TEXTIO_PUT) {
            this.setPropertyLogBefore(string, object);
            this.put(this.defaultNullPropertyValue(object, ""));
        } else if (iD == WUF_TEXTIO_NEWLINE) {
            this.setPropertyLogBefore(string, object);
            this.newLine(this.defaultNullPropertyValue(object, "1"));
        } else if (iD == WUF_TEXTIO_ARG) {
            this.setPropertyLogBefore(string, object);
            this.putfArgs(this.defaultNullPropertyValue(object, null));
        } else if (iD == WUF_TEXTIO_PUTF) {
            this.setPropertyLogBefore(string, object);
            this.putf(this.defaultNullPropertyValue(object, ""));
        } else if (iD == WUF_GFN_DIRNAME) {
            this.setPropertyLogBefore(string, object);
            if (m_gfnLastDir == null) {
                m_gfnLastDir = System.getProperty("user.home");
            }
            if (object != null && object.toString().trim().length() == 0) {
                object = null;
            }
            this.m_gfnDirname = this.defaultNullPropertyValue(object, m_gfnLastDir);
        } else if (iD == WUF_GFN_MESSAGE) {
            this.setPropertyLogBefore(string, object);
            this.m_gfnMessage = this.defaultNullPropertyValue(object, null);
        } else if (iD == WUF_FILTER) {
            this.setPropertyLogBefore(string, object);
            this.m_filterString = this.defaultNullPropertyValue(object, null);
        } else if (iD == WUF_GFN_MULTISELECT) {
            this.setPropertyLogBefore(string, object);
            this.m_gfnMultiSelect = this.defaultNullPropertyValue(object, "FALSE").equalsIgnoreCase("true");
        } else if (iD == WUF_FILE_ATTRIBUTE) {
            this.setPropertyLogBefore(string, object);
            this.m_attr = Integer.parseInt(this.defaultNullPropertyValue(object, "0"));
        } else if (iD == WUF_RENAME_FILE || iD == WUF_COPY_FILE) {
            this.setPropertyLogBefore(string, object);
            this.m_newFileName = this.defaultNullPropertyValue(object, null);
        } else if (iD == WUF_NO_DIRECTORIES) {
            this.setPropertyLogBefore(string, object);
            this.m_incDirs = object.toString().equalsIgnoreCase("Y");
        } else if (iD == WUF_GFN_OPENDIR) {
            this.setPropertyLogBefore(string, object);
            this.openFile = false;
            this.directoryList = true;
            Thread thread = new Thread((Runnable)this, "gfnDialog thread");
            thread.start();
        } else if (iD == WUF_GFN_OPENFILE) {
            this.setPropertyLogBefore(string, object);
            this.openFile = true;
            this.directoryList = false;
            Thread thread = new Thread((Runnable)this, "gfnDialog thread");
            thread.start();
        } else if (iD == WUF_GFN_SAVEFILE) {
            this.setPropertyLogBefore(string, object);
            this.openFile = false;
            this.directoryList = false;
            Thread thread = new Thread((Runnable)this, "gfnDialog thread");
            thread.start();
        } else {
            bl = super.setProperty(iD, object);
        }
        return bl;
    }

    private Object fopen() {
        String string = null;
        try {
            if (this.m_fileMode.equals("r")) {
                try {
                    this.log((byte)1, "FileFunctions.fopen()", "Opening in Read Mode");
                    string = "" + this.storeInObjectCache(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_fileName), this.m_charSet)));
                }
                catch (IOException iOException) {
                    this.error(200, "FileFunctions.fopen()", this.getTranslatedMessage("ERROR200", this.m_fileName, null, null));
                    string = "";
                }
            } else {
                try {
                    this.log((byte)1, "FileFunctions.fopen()", "Opening in Write/Append Mode");
                    string = "" + this.storeInObjectCache(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_fileName, this.m_fileMode.equals("a")), this.m_charSet)));
                }
                catch (IOException iOException) {
                    this.error(201, "FileFunctions.fopen()", this.getTranslatedMessage("ERROR201", this.m_fileName, this.m_fileMode, iOException.toString()));
                    string = "";
                }
            }
        }
        catch (Exception exception) {
            this.unexpectedError("FileFunctions.fopen()", exception);
        }
        return string;
    }

    private Object getLine() {
        String string;
        block6: {
            string = null;
            try {
                Object object = this.getFromObjectCache(this.m_fileID);
                if (object instanceof BufferedReader) {
                    try {
                        string = ((BufferedReader)object).readLine();
                        if (string == null) {
                            string = "\n";
                        }
                        break block6;
                    }
                    catch (IOException iOException) {
                        this.error(203, "FileFunctions.get_line()", this.getTranslatedMessage("ERROR203", iOException.toString(), null, null));
                        string = "\n";
                    }
                    break block6;
                }
                this.error(12, "FileFunctions.get_line()", this.getTranslatedMessage("ERROR012", "BufferedReader", null, null));
                string = "";
            }
            catch (Exception exception) {
                this.unexpectedError("FileFunctions.getLine()", exception);
            }
        }
        return string;
    }

    private void fclose(String string) {
        try {
            if (this.setHandle(string)) {
                Object object = this.getFromObjectCache(this.m_fileID);
                if (object instanceof BufferedWriter) {
                    try {
                        ((BufferedWriter)object).flush();
                        ((BufferedWriter)object).close();
                    }
                    catch (IOException iOException) {
                        this.error(204, "FileFunctions.fclose()", this.getTranslatedMessage("ERROR204", iOException.toString(), null, null));
                    }
                } else if (object instanceof BufferedReader) {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (IOException iOException) {
                        this.error(204, "FileFunctions.fclose()", this.getTranslatedMessage("ERROR204", iOException.toString(), null, null));
                    }
                } else {
                    this.error(12, "FileFunctions.fclose()", this.getTranslatedMessage("ERROR012", "BufferedWriter/BufferedReader", null, null));
                }
                this.eraseFromObjectCache(this.m_fileID);
                this.m_fileID = -1;
            }
        }
        catch (Exception exception) {
            this.unexpectedError("FileFunctions.fclose()", exception);
        }
    }

    private boolean setHandle(String string) {
        boolean bl = false;
        try {
            this.m_fileID = Integer.parseInt(string);
            if (this.m_fileID < 0 && this.m_fileID != -2) {
                throw new NumberFormatException();
            }
            if (this.m_putfArgCount >= 0) {
                for (int i = 0; i <= this.m_putfArgCount; ++i) {
                    this.m_putfArgs[i] = null;
                }
                this.m_putfArgCount = -1;
            }
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            this.error(206, "FileFunctions.setHandle()", this.getTranslatedMessage("ERROR206", string, null, null));
        }
        catch (NullPointerException nullPointerException) {
            this.error(207, "FileFunctions.setHandle()", this.getTranslatedMessage("ERROR207", null, null, null));
        }
        catch (Exception exception) {
            this.unexpectedError("FileFunctions.setHandle()", exception);
        }
        return bl;
    }

    private void put(String string) {
        try {
            if (this.m_fileID == -2) {
                System.out.print(string);
            } else {
                Object object = this.getFromObjectCache(this.m_fileID);
                if (object instanceof BufferedWriter) {
                    BufferedWriter bufferedWriter = (BufferedWriter)object;
                    try {
                        bufferedWriter.write(string);
                    }
                    catch (IOException iOException) {
                        this.error(202, "FileFunctions.put()", this.getTranslatedMessage("ERROR202", iOException.toString(), null, null));
                    }
                } else {
                    this.error(12, "FileFunctions.put()", this.getTranslatedMessage("ERROR012", "BufferedWriter", null, null));
                }
            }
        }
        catch (Exception exception) {
            this.unexpectedError("FileFunctions.put()", exception);
        }
    }

    private void newLine(String string) {
        block10: {
            try {
                int n = 0;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.error(205, "FileFunctions.newLine()", this.getTranslatedMessage("ERROR205", string, null, null));
                }
                if (this.m_fileID == -2) {
                    for (int i = 1; i <= n; ++i) {
                        System.out.println();
                    }
                    break block10;
                }
                Object object = this.getFromObjectCache(this.m_fileID);
                if (object instanceof BufferedWriter) {
                    BufferedWriter bufferedWriter = (BufferedWriter)object;
                    try {
                        for (int i = 1; i <= n; ++i) {
                            bufferedWriter.newLine();
                        }
                        break block10;
                    }
                    catch (IOException iOException) {
                        this.error(202, "FileFunctions.newLine()", this.getTranslatedMessage("ERROR202", iOException.toString(), null, null));
                        break block10;
                    }
                }
                this.error(12, "FileFunctions.newLine()", this.getTranslatedMessage("ERROR012", "BufferedWriter", null, null));
            }
            catch (Exception exception) {
                this.unexpectedError("FileFunctions.newLine()", exception);
            }
        }
    }

    private void putfArgs(String string) {
        try {
            if (this.m_putfArgCount < 4) {
                this.m_putfArgs[++this.m_putfArgCount] = string;
            } else {
                this.error(208, "FileFunctions.putfArgs()", this.getTranslatedMessage("ERROR208"));
            }
        }
        catch (Exception exception) {
            this.unexpectedError("FileFunctions.putfArgs()", exception);
        }
    }

    private void putf(String string) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("");
        Object object = null;
        BufferedWriter bufferedWriter = null;
        int n = 0;
        int n2 = -1;
        try {
            if (this.m_fileID != -2) {
                object = this.getFromObjectCache(this.m_fileID);
            }
            if ((object instanceof BufferedWriter || this.m_fileID == -2) && string != null) {
                bufferedWriter = (BufferedWriter)object;
                int n3 = string.indexOf("%s");
                while (n3 != -1) {
                    stringBuffer.append(string.substring(n, n3));
                    stringBuffer.append(this.m_putfArgs[++n2]);
                    n = n3 + 2;
                    n3 = string.indexOf("%s", n);
                }
                stringBuffer.append(string.substring(n));
                try {
                    String string2 = stringBuffer.toString();
                    n3 = string2.indexOf("\\n");
                    n = 0;
                    while (n3 != -1) {
                        if (this.m_fileID == -2) {
                            System.out.println(string2.substring(n, n3));
                        } else {
                            bufferedWriter.write(string2.substring(n, n3));
                            bufferedWriter.newLine();
                        }
                        n = n3 + 2;
                        n3 = string2.indexOf("\\n", n);
                    }
                    if (this.m_fileID == -2) {
                        System.out.println(string2.substring(n));
                    } else {
                        bufferedWriter.write(string2.substring(n));
                    }
                    bl = true;
                }
                catch (IOException iOException) {
                    this.error(202, "putf()", this.getTranslatedMessage("ERROR202", iOException.toString(), null, null));
                }
            } else {
                this.error(12, "FileFunctions.putf()", this.getTranslatedMessage("ERROR012", "BufferedWriter", null, null));
            }
        }
        catch (Exception exception) {
            this.unexpectedError("FileFunctions.putf()", exception);
        }
    }

    @Override
    public void run() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FileFunctions.this.runInternal();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void runInternal() {
        Object var1_1 = null;
        String string = null;
        String string2 = null;
        try {
            int n;
            Object object;
            Object object2;
            String string3;
            Object object3;
            this.m_gfnSelectionMade = false;
            FFileChooser fFileChooser = new FFileChooser(null);
            if (this.m_gfnMessage != null) {
                fFileChooser.setDialogTitle(this.m_gfnMessage);
            }
            if (this.m_fileName != null && !this.m_fileName.isEmpty()) {
                fFileChooser.setSelectedFile(new File(this.m_gfnDirname, this.m_fileName));
            } else if (this.m_gfnDirname != null) {
                fFileChooser.setCurrentDirectory(new File(this.m_gfnDirname));
            }
            if (this.m_filterString != null) {
                fFileChooser.setAcceptAllFileFilterUsed(false);
                object3 = null;
                String string4 = null;
                string3 = null;
                object2 = new StringTokenizer(this.m_filterString, "|");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    string4 = ((StringTokenizer)object2).nextToken();
                    if (((StringTokenizer)object2).hasMoreTokens()) {
                        string3 = ((StringTokenizer)object2).nextToken();
                    } else {
                        string4 = new String("All Files (*.*)");
                        string3 = new String("*.*");
                    }
                    if (string4 == null || string3 == null) continue;
                    this.log((byte)1, "gfnDialog run()", "Creating Custom File Filter : Mask=" + string3 + ", Label=" + string4);
                    object = new WebUtilFileFilter(string3, string4);
                    fFileChooser.addChoosableFileFilter((FileFilter)object);
                    if (object3 != null) continue;
                    object3 = object;
                }
                fFileChooser.setFileFilter((FileFilter)object3);
            } else {
                fFileChooser.setAcceptAllFileFilterUsed(true);
            }
            if (this.openFile) {
                this.log((byte)1, "gfnDialog run()", "Open File mode");
                fFileChooser.setDialogType(0);
                fFileChooser.setMultiSelectionEnabled(this.m_gfnMultiSelect);
                n = fFileChooser.showOpenDialog(this.getFrame());
            } else if (!this.directoryList) {
                this.log((byte)1, "gfnDialog run()", "Save File mode");
                fFileChooser.setDialogType(1);
                n = fFileChooser.showSaveDialog(this.getFrame());
            } else {
                this.log((byte)1, "gfnDialog run()", "Directory selection mode");
                fFileChooser.setFileSelectionMode(1);
                if (this.m_gfnDirname != null) {
                    fFileChooser.setCurrentDirectory(new File(this.m_gfnDirname));
                }
                if (this.m_gfnMessage == null) {
                    fFileChooser.setDialogTitle(this.getTranslatedMessage("SELDIR_TITLE"));
                }
                fFileChooser.setApproveButtonMnemonic(this.getTranslatedMessage("OK_MNEMONIC").charAt(0));
                n = fFileChooser.showDialog(this.getFrame(), this.getTranslatedMessage("OK"));
            }
            if (n == 0) {
                String string5;
                File[] fileArray;
                this.m_gfnSelectionMade = true;
                object3 = fFileChooser.getSelectedFile().getAbsolutePath();
                int n2 = ((String)object3).lastIndexOf(File.separator);
                string3 = ((String)object3).substring(0, n2);
                m_gfnLastDir = string3;
                if (m_gfnLastDir == null) {
                    m_gfnLastDir = fFileChooser.getSelectedFile().getAbsolutePath();
                }
                object2 = "";
                if (this.m_filterString != null && fFileChooser.getFileFilter() instanceof WebUtilFileFilter && (object = (WebUtilFileFilter)fFileChooser.getFileFilter()) != null && (fileArray = ((WebUtilFileFilter)object).getMask()) != null && (string5 = fileArray.substring(fileArray.indexOf(42) + 1)).indexOf(42) == -1 && string5.indexOf(63) == -1) {
                    object2 = string5;
                }
                if (!this.m_gfnMultiSelect) {
                    string = fFileChooser.getSelectedFile().getName();
                    if (!string.equalsIgnoreCase("")) {
                        string2 = m_gfnLastDir + File.separator;
                        this.log((byte)1, "gfnDialog()", "Selected Directory: " + string2 + " Selected File: " + string);
                        this.runResult = fFileChooser.getSelectedFile().getAbsolutePath();
                        if (string.indexOf(46) == -1) {
                            this.runResult = this.runResult + (String)object2;
                        }
                    } else {
                        this.log((byte)1, "gfnDialog()", "Selected Directory: " + m_gfnLastDir);
                        this.runResult = m_gfnLastDir;
                    }
                } else {
                    object = new StringBuffer(m_gfnLastDir);
                    ((StringBuffer)object).append(File.separator);
                    ((StringBuffer)object).append('\n');
                    fileArray = fFileChooser.getSelectedFiles();
                    for (int i = 0; i < fileArray.length; ++i) {
                        string = fileArray[i].getName();
                        if (string.indexOf(46) == -1) {
                            string = string + (String)object2;
                        }
                        ((StringBuffer)object).append(string);
                        ((StringBuffer)object).append('\n');
                    }
                    this.log((byte)1, "gfnDialog run()", "Multiple selection result: " + ((StringBuffer)object).toString());
                    this.runResult = ((StringBuffer)object).toString();
                }
            } else {
                this.m_gfnSelectionMade = false;
                this.runResult = "";
            }
            object3 = new Message(4, 0, ((MessageHandler)((Object)this.getHandler())).getHandlerId());
            ((Message)object3).add(ID.CUSTOM_PROPERTY.toID(), this.runResult);
            Runform runform = ((UICommon)this.getHandler()).getDispatcher();
            runform.onMessage((Message)object3, 0);
        }
        catch (Exception exception) {
            this.unexpectedError("FileFunctions.gfnDialog run()", exception);
        }
    }

    private String checkFileAttribute(String string, int n) {
        String string2;
        block16: {
            string2 = null;
            try {
                if (string == null) break block16;
                File file = new File(string);
                switch (n) {
                    case 8: {
                        SimpleDateFormat simpleDateFormat;
                        String string3 = "dd-MMM-yyyy HH:mm:ss";
                        String string4 = this.getHandler().getApplet().getParameter("WebUtilDateFormat");
                        if (string4 == null || string4.equals("")) {
                            string4 = string3;
                        }
                        Date date = new Date(file.lastModified());
                        try {
                            simpleDateFormat = new SimpleDateFormat(string4);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            simpleDateFormat = new SimpleDateFormat(string3);
                        }
                        string2 = simpleDateFormat.format(date);
                        break;
                    }
                    case 7: {
                        string2 = Long.toString(file.lastModified());
                        break;
                    }
                    case 1: {
                        string2 = this.boolAsString(file.exists());
                        break;
                    }
                    case 2: {
                        string2 = this.boolAsString(Files.isReadable(Paths.get(string, new String[0])));
                        break;
                    }
                    case 3: {
                        string2 = this.boolAsString(Files.isWritable(Paths.get(string, new String[0])));
                        break;
                    }
                    case 4: {
                        string2 = this.boolAsString(file.isDirectory());
                        break;
                    }
                    case 5: {
                        string2 = this.boolAsString(file.isHidden());
                        break;
                    }
                    case 6: {
                        if (file.isDirectory()) {
                            string2 = "";
                            break;
                        }
                        string2 = "" + file.length();
                        break;
                    }
                    default: {
                        string2 = "FALSE";
                    }
                }
            }
            catch (Exception exception) {
                this.unexpectedError("FileFunctions.checkFileAttribute()", exception);
            }
        }
        return string2;
    }

    private String createDir(String string) {
        boolean bl = false;
        try {
            if (string != null) {
                File file = new File(string);
                bl = file.mkdirs();
            }
        }
        catch (Exception exception) {
            this.unexpectedError("FileFunctions.createDir()", exception);
        }
        return bl ? "TRUE" : "FALSE";
    }

    private String renameFile(String string, String string2) {
        boolean bl = false;
        try {
            if (string != null && string2 != null) {
                this.log((byte)1, "FileFunctions.renameFile()", "Renaming " + string + " to " + string2);
                File file = new File(string);
                if (file.exists()) {
                    bl = file.renameTo(new File(string2));
                } else {
                    this.log((byte)1, "FileFunctions.renameFile()", "File " + string + " does not exist - cannot rename");
                }
            } else {
                this.log((byte)1, "FileFunctions.renameFile()", "File name is empty - cannot rename");
            }
        }
        catch (Exception exception) {
            this.unexpectedError("FileFunctions.renameFile()", exception);
        }
        return bl ? "TRUE" : "FALSE";
    }

    private String deleteFile(String string) {
        boolean bl = false;
        try {
            if (string != null) {
                this.log((byte)1, "FileFunctions.deleteFile()", "Deleting " + string);
                File file = new File(string);
                if (file.exists()) {
                    bl = file.delete();
                } else {
                    this.log((byte)1, "FileFunctions.deleteFile()", "File does not exist to delete");
                }
            } else {
                this.log((byte)1, "FileFunctions.deleteFile()", "File name is empty - cannot delete");
            }
        }
        catch (Exception exception) {
            this.unexpectedError("FileFunctions.deleteFile()", exception);
        }
        return bl ? "TRUE" : "FALSE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String copyFile(String string, String string2) {
        boolean bl;
        block23: {
            bl = false;
            try {
                if (string != null && string2 != null) {
                    this.log((byte)1, "FileFunctions.copyFile()", "Copying " + string + " to " + string2);
                    File file = new File(string);
                    FileInputStream fileInputStream = null;
                    try {
                        fileInputStream = new FileInputStream(file);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.error(106, "FileFunctions.copyFile()", this.getTranslatedMessage("ERROR106", string, null, null));
                        return "FALSE";
                    }
                    FileOutputStream fileOutputStream = null;
                    try {
                        try {
                            fileOutputStream = new FileOutputStream(string2, false);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            this.error(105, "FileFunctions.copyFile()", this.getTranslatedMessage("ERROR105", string2, null, null));
                            fileInputStream.close();
                            String string3 = "FALSE";
                            try {
                                fileInputStream.close();
                                return string3;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return string3;
                        }
                        try {
                            int n;
                            while ((n = fileInputStream.read()) != -1) {
                                fileOutputStream.write(n);
                            }
                        }
                        finally {
                            fileOutputStream.close();
                        }
                    }
                    finally {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    File file2 = new File(string2);
                    if (file.length() == file2.length()) {
                        this.log((byte)1, "FileFunctions.copyFile()", "Copy successful");
                        return "TRUE";
                    }
                    this.error(209, "FileFunctions.copyFile()", this.getTranslatedMessage("ERROR209"));
                    break block23;
                }
                this.log((byte)1, "FileFunctions.copyFile()", "File name is empty - cannot copy");
            }
            catch (Exception exception) {
                this.unexpectedError("FileFunctions.copyFile()", exception);
            }
        }
        if (!bl) return "FALSE";
        return "TRUE";
    }

    private String listDir(String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            File[] fileArray = null;
            if (string == null) {
                fileArray = File.listRoots();
            } else {
                File file = new File(string);
                if (string2 == null || string2.equals("")) {
                    fileArray = file.listFiles();
                } else {
                    WebUtilFileListFilter webUtilFileListFilter = new WebUtilFileListFilter(string2);
                    fileArray = file.listFiles(webUtilFileListFilter);
                }
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (!bl && fileArray[i].isDirectory()) continue;
                if (string == null) {
                    stringBuffer.append(fileArray[i].getPath());
                } else {
                    stringBuffer.append(fileArray[i].getName());
                }
                stringBuffer.append('\n');
            }
        }
        catch (Exception exception) {
            this.unexpectedError("FileFunctions.listDir()", exception);
        }
        return stringBuffer.toString();
    }

    private void setFileEncoding(String string) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
        this.m_charSet = Charset.forName(outputStreamWriter.getEncoding());
        if (!string.equalsIgnoreCase("(null)")) {
            String string2 = CharsetMapper.javaFromOracle(string);
            if (string2 != null) {
                string = string2;
            }
            try {
                this.m_charSet = Charset.forName(string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                this.log((byte)0, "FileFunctions.setFileEncoding()", "Given java character set " + string + " is not supported. Using default " + this.m_charSet.name());
            }
        }
    }
}

