/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.file;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import oracle.forms.webutil.file.WebUtilFileFilter;

public class FFileChooser
extends JFileChooser {
    private static final boolean doNotOverride = !System.getProperty("java.version").startsWith("1.") ? true : System.getProperty("java.version").compareTo("1.5") >= 0;

    public FFileChooser(File file) {
        super(file);
        Class[] classArray = new Class[]{Integer.TYPE, Set.class};
        try {
            Method method = this.getClass().getMethod("setFocusTraversalKeys", classArray);
            if (method.getModifiers() == 1) {
                HashSet<Object> hashSet = new HashSet<Object>();
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                Class<?> clazz = classLoader.loadClass("java.awt.KeyboardFocusManager");
                Class[] classArray2 = new Class[]{Integer.TYPE, Integer.TYPE};
                Method method2 = classLoader.loadClass("java.awt.AWTKeyStroke").getMethod("getAWTKeyStroke", classArray2);
                Object[] objectArray = new Object[]{9, 0};
                hashSet.add(method2.invoke(null, objectArray));
                objectArray[1] = 2;
                hashSet.add(method2.invoke(null, objectArray));
                Object[] objectArray2 = new Object[]{clazz.getField("FORWARD_TRAVERSAL_KEYS").getInt(null), hashSet};
                method.invoke((Object)this, objectArray2);
                hashSet.clear();
                objectArray[1] = 1;
                hashSet.add(method2.invoke(null, objectArray));
                objectArray[1] = 3;
                hashSet.add(method2.invoke(null, objectArray));
                objectArray2[0] = clazz.getField("BACKWARD_TRAVERSAL_KEYS").getInt(null);
                method.invoke((Object)this, objectArray2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setSelectedFile(final File file) {
        if (doNotOverride) {
            super.setSelectedFile(file);
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FFileChooser.this.setSelectedFileInternal(file);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void setSelectedFileInternal(File file) {
        if (file != null && (file.isDirectory() && this.getFileSelectionMode() == 0 || file.getName() == null)) {
            return;
        }
        super.setSelectedFile(file);
    }

    @Override
    public void approveSelection() {
        if (doNotOverride) {
            super.approveSelection();
            return;
        }
        File file = this.getSelectedFile();
        if (file == null || file.getName().equalsIgnoreCase("") && this.getFileSelectionMode() == 0) {
            return;
        }
        String string = file.getName();
        if (string.indexOf(42) != -1 || string.indexOf(63) != -1) {
            FileFilter fileFilter;
            FileFilter[] fileFilterArray = this.getChoosableFileFilters();
            int n = 0;
            for (n = 0; n < fileFilterArray.length; ++n) {
                fileFilter = fileFilterArray[n];
                if (!(fileFilter instanceof WebUtilFileFilter) || !string.equalsIgnoreCase(((WebUtilFileFilter)fileFilter).getMask())) continue;
                this.setCurrentDirectory(file.getParentFile());
                this.setFileFilter(fileFilter);
                return;
            }
            fileFilter = new WebUtilFileFilter(string, string);
            this.setCurrentDirectory(file.getParentFile());
            this.addChoosableFileFilter(fileFilter);
        } else {
            super.approveSelection();
        }
    }

    @Override
    public void setCurrentDirectory(File file) {
        if (doNotOverride) {
            super.setCurrentDirectory(file);
            return;
        }
        if (file != null && file.getParentFile() == null) {
            this.setSelectedFile(file);
        } else if (file != null && file.equals(this.getSelectedFile())) {
            this.setSelectedFile(null);
        }
        super.setCurrentDirectory(file);
    }
}

