/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.common;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import oracle.forms.engine.Main;
import oracle.forms.engine.Runform;
import oracle.forms.engine.Version;
import oracle.forms.handler.IHandler;
import oracle.forms.handler.UICommon;
import oracle.forms.properties.ID;
import oracle.forms.registry.MessageManager;
import oracle.forms.ui.CustomEvent;
import oracle.forms.ui.VBean;
import oracle.forms.webutil.common.Alert;
import oracle.forms.webutil.common.LoggingEngine;
import oracle.forms.webutil.common.ProgressDialog;
import oracle.forms.webutil.common.URLDownload;
import oracle.forms.webutil.common.VarsStub;
import oracle.forms.webutil.fileTransfer.FileTransfer;
import oracle.forms.webutil.fileTransfer.TransferAgent;
import org.apache.regexp.RE;

public class VBeanCommon
extends VBean {
    public static final ID WUC_LOGMODE = ID.registerProperty("WUC_LOGMODE");
    public static final ID WUC_LOGMODE_LEVEL = ID.registerProperty("WUC_LOGMODE_LEVEL");
    public static final ID WUC_ERRORMODE = ID.registerProperty("WUC_ERRORMODE");
    public static final ID WUC_ERROR_MSG = ID.registerProperty("WUC_ERROR_MSG");
    public static final ID WUC_TRANS_MSG = ID.registerProperty("WUC_TRANS_MSG");
    public static final ID WUC_SRV_LOGGING = ID.registerProperty("WUC_SRV_LOGGING");
    public static final ID WUC_BEAN_VERSION = ID.registerProperty("WUC_BEAN_VERSION");
    public static final ID WUC_CHECK_ERROR = ID.registerProperty("WUC_CHECK_ERROR");
    public static final ID WUC_URL_DOWNLOAD = ID.registerProperty("WUC_URL_DOWNLOAD");
    public static final ID WUC_SET_LOCAL_PROPERTY = ID.registerProperty("WUC_SET_LOCAL_PROPERTY");
    public static final ID WUC_GET_LOCAL_PROPERTY = ID.registerProperty("WUC_GET_LOCAL_PROPERTY");
    public static final ID WUC_SYSLIB_DIR = ID.registerProperty("WUC_SYSLIB_DIR");
    public static final ID WUC_GLOBAL_REFERENCE = ID.registerProperty("WUC_GLOBAL_REFERENCE");
    public static final ID WUC_BLOCK_ALLOW_HEART_BEAT = ID.registerProperty("WUC_BLOCK_ALLOW_HEART_BEAT");
    public static final ID WUC_LOG_EVENT = ID.registerProperty("WUC_LOG_EVENT");
    public static final ID WUC_ERROR_EVENT = ID.registerProperty("WUC_ERROR_EVENT");
    public static final ID WUC_ERROR_NUMBER = ID.registerProperty("WUC_ERROR_NUMBER");
    public static final ID WUC_DATA = ID.registerProperty("WUC_DATA");
    public static final ID WUC_DATA_MULTIPART = ID.registerProperty("WUC_DATA_MULTIPART");
    public static final ID WUC_REGISTER = ID.registerProperty("WUC_REGISTER");
    public static int MAX_MESSAGE_LENGTH_CHARS = Short.MAX_VALUE;
    public static int MAX_MESSAGE_LENGTH_BYTES = 2500;
    public static final String FILE_SEP = System.getProperty("file.separator");
    public static String JRE_HOME_ROOT = System.getProperty("java.home") + FILE_SEP;
    public static final String USER_HOME = System.getProperty("user.home") + FILE_SEP;
    public static String OS_ARCH = "32";
    public static String WEBUTIL_PROPERTIES;
    private static String SYSLIB_PATH;
    private String m_beanName = null;
    private String m_beanShortName = null;
    private InetAddress m_localhost = null;
    private LoggingEngine m_logger = null;
    private static MessageManager s_msgMgr;
    private static String msgKey;
    private JLabel m_beanLabel = null;
    private Frame m_frame = null;
    private boolean m_isDispatchAllowed = false;
    public boolean m_destroyed = false;
    public int m_lastError = 0;
    private static Vector s_objectCache;
    private static int s_cacheIndex;
    private static Vector s_objectOwners;
    private static int s_global;
    private int m_objCount;
    private static Properties m_settings;
    private String m_propertyValue = null;
    private String m_downloadInfo = null;
    private boolean m_trustInternal = true;
    private boolean m_nextGenHost = true;
    private static boolean m_blockAllowHeatBeat;
    private static ArrayList m_sessionSyslibs;
    private String m_jacobdir = null;

    public VBeanCommon() {
        this.setBeanInfo();
        this.m_logger = new LoggingEngine(this.m_beanShortName, this);
        this.m_logger.setLogDetail((byte)0);
        this.m_logger.setLogMode((byte)0);
    }

    public void setBeanInfo() {
        this.setBeanName("WebUtil Common Superclass");
        this.setBeanShortName("WUC");
    }

    @Override
    public void init(IHandler iHandler) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        this.m_beanLabel = new JLabel(this.m_beanName + " - " + Version.getString());
        this.add(this.m_beanLabel);
        String string7 = iHandler.getApplet().getParameter("WebUtilLogging");
        if (string7 != null && !string7.equals("")) {
            this.getLogger().setLogMode(string7);
        }
        if ((string6 = iHandler.getApplet().getParameter("WebUtilLoggingDetail")) != null && !string6.equals("")) {
            this.getLogger().setLogDetail(string6);
        }
        if ((string5 = iHandler.getApplet().getParameter("WebUtilErrorMode")) != null && !string5.equals("")) {
            this.getLogger().setErrorMode(string5);
        }
        if ((string4 = iHandler.getApplet().getParameter("lookAndFeel")) == null || !string4.equals("")) {
            // empty if block
        }
        if ((string3 = iHandler.getApplet().getParameter("WebUtilDebugJRE")) != null && !string3.equals("")) {
            JRE_HOME_ROOT = string3 + FILE_SEP;
        }
        if (!((string2 = iHandler.getApplet().getParameter("WebUtilTrustInternal")) == null || string2.equalsIgnoreCase("") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes"))) {
            this.m_trustInternal = false;
        }
        if ((string = iHandler.getApplet().getParameter("WebUtilNextGenHost")) != null && (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no"))) {
            this.m_nextGenHost = false;
        }
        this.findLocalHost();
        super.init(iHandler);
        if (!this.isDomainTrusted(iHandler)) {
            String string8 = "WUC-27: " + this.getTranslatedMessage("ERROR027", iHandler.getApplet().getDocumentBase().getHost(), null, null);
            SecurityException securityException = new SecurityException(string8);
            Runform runform = ((UICommon)iHandler).getDispatcher();
            runform.showAlert(string8, Runform.exceptionToString(securityException), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDomainTrusted(IHandler iHandler) {
        String string = iHandler.getApplet().getDocumentBase().getHost();
        if (string.equalsIgnoreCase("")) return true;
        if (string.equalsIgnoreCase("localhost")) {
            return true;
        }
        if (this.m_trustInternal && string.indexOf(46) == -1) {
            return true;
        }
        String string2 = null;
        String string3 = null;
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
            string3 = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string2 = string;
            string3 = string;
        }
        URL uRL = VBeanCommon.class.getResource("TrustedDomains.txt");
        InputStream inputStream = VBeanCommon.class.getResourceAsStream("TrustedDomains.txt");
        if (inputStream == null) {
            return true;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string4 = null;
        try {
            block26: {
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (string4.equalsIgnoreCase("") || string4.charAt(0) == '/') continue;
                    RE rE = new RE(VBeanCommon.populateStarForRE(string4), 1);
                    if (rE.match(string3)) {
                        bufferedReader.close();
                        boolean bl = true;
                        return bl;
                    }
                    if (string2 == null) {
                        string2 = inetAddress.getHostName();
                    }
                    if (!rE.match(string2)) {
                        continue;
                    }
                    break block26;
                }
                return false;
            }
            bufferedReader.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            this.error(28, "VBeanCommon.isDomainTrusted()", this.getTranslatedMessage("ERROR028"));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String populateStarForRE(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (string == null || string.equals("")) {
            return string;
        }
        String string2 = string.toLowerCase();
        char c = string2.charAt(0);
        char c2 = string2.charAt(string2.length() - 1);
        block4: for (int i = 0; i < string2.length(); ++i) {
            char c3 = string2.charAt(i);
            switch (c3) {
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    stringBuffer.append("\\");
                    stringBuffer.append(c3);
                    continue block4;
                }
                case '*': {
                    stringBuffer.append('.');
                    stringBuffer.append('*');
                    continue block4;
                }
                default: {
                    stringBuffer.append(c3);
                }
            }
        }
        if (c != '*') {
            stringBuffer.insert(0, '^');
        }
        if (c2 != '*') {
            stringBuffer.append('$');
        }
        return stringBuffer.toString();
    }

    @Override
    public void destroy() {
        if (!this.m_destroyed) {
            this.m_isDispatchAllowed = false;
            this.log((byte)0, "VBeanCommon.destroy()", this.m_beanName + " being removed..");
            if (s_objectCache != null) {
                int n = 0;
                int n2 = this.m_objCount;
                int n3 = s_objectOwners.lastIndexOf(this);
                while (n3 >= 0) {
                    this.eraseFromObjectCache(n3 + 1);
                    ++n;
                    n3 = s_objectOwners.lastIndexOf(this);
                }
                this.log((byte)0, "VBeanCommon.destroy()", n + " out of " + n2 + " object references removed, " + s_global + " (total) global references outstanding");
            }
            this.m_destroyed = true;
        }
        super.destroy();
    }

    public boolean isBlockAllowHeatBeat() {
        return m_blockAllowHeatBeat;
    }

    public boolean isNextGenHost() {
        return this.m_nextGenHost;
    }

    @Override
    public Object getProperty(ID iD) {
        Object object = null;
        if (iD != WUC_CHECK_ERROR) {
            this.setErrorCondition(0);
        }
        String string = iD.getName();
        if (iD == WUC_CHECK_ERROR) {
            if (this.m_lastError == 0) {
                object = "0,";
            } else {
                String string2 = this.m_lastError < 10 ? "ERROR00" + this.m_lastError : (this.m_lastError < 100 ? "ERROR0" + this.m_lastError : "ERROR" + this.m_lastError);
                object = "" + this.m_lastError + "," + this.getTranslatedMessage(string2);
            }
            this.m_lastError = 0;
        } else if (iD == WUC_TRANS_MSG) {
            this.getPropertyLogBefore(string);
            if (msgKey != null) {
                object = this.getTranslatedMessage(msgKey);
            }
            msgKey = null;
        } else if (iD == WUC_BEAN_VERSION) {
            this.getPropertyLogBefore(string);
            object = Version.getString();
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUC_GET_LOCAL_PROPERTY) {
            this.getPropertyLogBefore(string);
            object = this.getWebutilProperty(this.m_propertyValue);
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUC_URL_DOWNLOAD) {
            this.getPropertyLogBefore(string);
            object = this.downloadFromURL(this.m_downloadInfo);
            this.getPropertyLogAfter(string, object);
        } else {
            object = super.getProperty(iD);
        }
        return object;
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        boolean bl = true;
        this.setErrorCondition(0);
        String string = iD.getName();
        if (iD == ID.FOREGROUND) {
            this.m_beanLabel.setForeground((Color)object);
        } else if (iD == ID.FONT) {
            this.m_beanLabel.setFont((Font)object);
        } else if (iD == WUC_LOGMODE) {
            this.setPropertyLogBefore(string, this.safePrint(object));
            if (object != null) {
                this.getLogger().setLogMode((String)object);
            }
        } else if (iD == WUC_LOGMODE_LEVEL) {
            this.setPropertyLogBefore(string, this.safePrint(object));
            this.getLogger().setLogDetail((String)object);
        } else if (iD == WUC_ERRORMODE) {
            this.setPropertyLogBefore(string, this.safePrint(object));
            this.getLogger().setErrorMode((String)object);
        } else if (iD == WUC_ERROR_MSG) {
            this.setPropertyLogBefore(string, this.safePrint(object));
            this.errorMsg((String)object);
        } else if (iD == WUC_TRANS_MSG) {
            this.setPropertyLogBefore(string, this.safePrint(object));
            msgKey = (String)object;
        } else if (iD == WUC_SRV_LOGGING) {
            this.getLogger().setSrvLoggingOptions(Integer.parseInt((String)object));
            this.setPropertyLogBefore(string, this.safePrint(object));
        } else if (iD == WUC_SET_LOCAL_PROPERTY) {
            this.setPropertyLogBefore(string, this.safePrint(object));
            this.setWebutilProperty(this.defaultNullPropertyValue(object, null));
        } else if (iD == WUC_SYSLIB_DIR) {
            int n;
            this.setPropertyLogBefore(string, this.safePrint(object));
            if (m_settings != null) {
                m_settings.clear();
                m_settings = null;
            }
            int n2 = ((String)object).indexOf(58);
            String string2 = null;
            SYSLIB_PATH = null;
            String string3 = null;
            WEBUTIL_PROPERTIES = "webutil." + OS_ARCH + ".properties";
            if (n2 == 1 && ((String)object).length() >= 3 && FILE_SEP.equals("\\") && (n = Character.toUpperCase(((String)object).charAt(0))) >= 65 && n <= 90 && ((String)object).charAt(2) == '\\') {
                n2 = ((String)object).indexOf(58, n2 + 1);
            }
            if (n2 == -1) {
                string2 = (String)object;
            } else {
                string2 = ((String)object).substring(0, n2);
                n = ((String)object).indexOf(58, n2 + 1);
                string3 = n == -1 ? ((String)object).substring(n2 + 1).trim() : ((String)object).substring(n2 + 1, n).trim();
                WEBUTIL_PROPERTIES = string3.equalsIgnoreCase("") ? "webutil." + OS_ARCH + ".properties" : "webutil." + string3 + "." + OS_ARCH + ".properties";
            }
            if (string2 == null || string2.equalsIgnoreCase("")) {
                WEBUTIL_PROPERTIES = JRE_HOME_ROOT + WEBUTIL_PROPERTIES;
            } else {
                WEBUTIL_PROPERTIES = USER_HOME + WEBUTIL_PROPERTIES;
                File file = new File(string2);
                SYSLIB_PATH = file.isAbsolute() ? file.getPath() : new File(USER_HOME, string2).getPath();
                VarsStub.setSyslibPath(SYSLIB_PATH);
            }
        } else if (iD == WUC_BLOCK_ALLOW_HEART_BEAT) {
            this.setPropertyLogBefore(string, this.safePrint(object));
            String string4 = this.defaultNullPropertyValue(object, null);
            if (string4 != null && "1".equals(string4)) {
                m_blockAllowHeatBeat = true;
            }
        } else if (iD == WUC_GET_LOCAL_PROPERTY) {
            this.setPropertyLogBefore(string, this.safePrint(object));
            this.m_propertyValue = this.defaultNullPropertyValue(object, null);
        } else if (iD == WUC_URL_DOWNLOAD) {
            this.setPropertyLogBefore(string, this.safePrint(object));
            this.m_downloadInfo = this.defaultNullPropertyValue(object, null);
        } else if (iD == WUC_GLOBAL_REFERENCE) {
            this.setPropertyLogBefore(string, this.safePrint(object));
            this.handleGlobalRef(this.defaultNullPropertyValue(object, null));
        } else if (iD == ID.VISIBLE) {
            this.m_isDispatchAllowed = true;
            bl = super.setProperty(iD, object);
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.m_beanShortName);
                stringBuffer.append("|");
                stringBuffer.append(this.getIPAddress());
                stringBuffer.append("|");
                stringBuffer.append(System.getProperty("os.name"));
                stringBuffer.append("|");
                stringBuffer.append(System.getProperty("os.arch"));
                stringBuffer.append("|");
                stringBuffer.append(System.getProperty("user.name"));
                stringBuffer.append("|");
                stringBuffer.append(System.getProperty("path.separator"));
                stringBuffer.append("|");
                stringBuffer.append(FILE_SEP);
                stringBuffer.append("|");
                stringBuffer.append(System.getProperty("user.language"));
                this.dispatchMessage(WUC_REGISTER, stringBuffer.toString());
            }
            catch (AccessControlException accessControlException) {
                this.error(11, "Registering", this.getTranslatedMessage("ERROR011"));
            }
        } else {
            bl = super.setProperty(iD, object);
        }
        return bl;
    }

    public static String getSyslibPath() {
        String string = SYSLIB_PATH;
        if (string == null) {
            string = FILE_SEP.equalsIgnoreCase("\\") ? JRE_HOME_ROOT + "bin" : JRE_HOME_ROOT + "lib";
        }
        return string;
    }

    public LoggingEngine getLogger() {
        return this.m_logger;
    }

    public final MessageManager getMessageManager() {
        return s_msgMgr;
    }

    public String getTranslatedMessage(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string5 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        return this.getTranslatedMessage(string5, string2, string3, string4);
    }

    public String getTranslatedMessage(String string, Object object, Object object2, Object object3) {
        return s_msgMgr.getMessage(string, ((UICommon)this.getHandler()).getDispatcher().getLocale(), object, object2, object3);
    }

    public void setBeanName(String string) {
        this.m_beanName = string;
    }

    public String getBeanName() {
        return this.m_beanName;
    }

    public void setBeanShortName(String string) {
        this.m_beanShortName = string;
    }

    public String getBeanShortName() {
        return this.m_beanShortName;
    }

    public void setErrorCondition(int n) {
        this.m_lastError = n;
    }

    private void findLocalHost() {
        if (this.m_localhost == null) {
            try {
                this.log((byte)0, "VBeanCommon.findLocalHost()", "obtaining LocalHost info from InetAddress");
                this.m_localhost = InetAddress.getLocalHost();
            }
            catch (Exception exception) {
                this.error(9, "VBeanCommon.findLocalHost()", this.getTranslatedMessage("ERROR009", exception.toString(), null, null));
            }
        }
    }

    public InetAddress getLocalHost() {
        return this.m_localhost;
    }

    public String getIPAddress() {
        String string = null;
        try {
            this.findLocalHost();
            if (this.m_localhost != null) {
                string = this.m_localhost.getHostAddress();
                this.log((byte)1, "VBeanCommon.getIPAddress()", string);
            } else {
                this.error(10, "VBeanCommon.getIPAddress()", this.getTranslatedMessage("ERROR010"));
                string = new String("");
            }
        }
        catch (Exception exception) {
            this.unexpectedError("VBeanCommon.getIPAddress()", exception);
        }
        return string;
    }

    public void message(String string) {
        if (this.isLogging()) {
            this.log((byte)1, "VBeanCommon.message()", "msg ==>" + string);
        }
        this.getHandler().getApplet().showStatus(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alert(String string, String string2) {
        this.getHandler().getApplet().exitSplashscreen();
        TransferAgent transferAgent = FileTransfer.getAgent();
        if (transferAgent != null) {
            TransferAgent transferAgent2 = transferAgent;
            synchronized (transferAgent2) {
                Alert alert = new Alert(this.getFrame(), string, this.getTranslatedMessage("OK"), string2);
                transferAgent.notify();
            }
        } else {
            Alert alert = new Alert(this.getFrame(), string, this.getTranslatedMessage("OK"), string2);
        }
    }

    public Frame getFrame() {
        if (this.m_frame == null) {
            Main main2 = this.getHandler().getApplet();
            this.m_frame = main2.getFrame();
            if (this.m_frame == null) {
                this.error(1, "VBeanCommon.getFrame()", this.getTranslatedMessage("ERROR001"));
            }
        }
        return this.m_frame;
    }

    public void dispatchLogMessage(String string) {
        this.dispatchMessage(WUC_LOG_EVENT, string);
    }

    public void dispatchErrorMessage(String string, int n) {
        try {
            CustomEvent customEvent = new CustomEvent((Object)this.getHandler(), WUC_ERROR_EVENT);
            this.getHandler().setProperty(WUC_DATA, string);
            this.getHandler().setProperty(WUC_ERROR_NUMBER, new String("" + n));
            this.getHandler().setProperty(WUC_DATA_MULTIPART, "1/1");
            super.dispatchCustomEvent(customEvent);
        }
        catch (Exception exception) {
            this.unexpectedError("VBeanCommon.lastResort()", exception);
        }
    }

    public void dispatchMessage(ID iD, String string) {
        this.coreMessageDispatcher(iD, string, 0, null, null, null);
    }

    public void dispatchMessageWithProgress(ID iD, String string, int n, String string2, String string3, String string4) {
        new ProgressThread(this, iD, string, n, string2, string3, string4).start();
    }

    private void coreMessageDispatcher(ID iD, String string, int n, String string2, String string3, String string4) {
        if (this.m_isDispatchAllowed) {
            String string5 = null;
            boolean bl = false;
            ProgressDialog progressDialog = null;
            boolean bl2 = true;
            int n2 = string.length();
            int n3 = n2 / MAX_MESSAGE_LENGTH_CHARS;
            if (n2 % MAX_MESSAGE_LENGTH_CHARS > 0) {
                ++n3;
            }
            if (n > 0 && n3 >= n) {
                bl = true;
                this.log((byte)0, "dispatchLongMessage()", "Using Progress Dialog");
                progressDialog = new ProgressDialog(this.getFrame(), string2, string3, string4, n3);
                progressDialog.setVisible(true);
            }
            try {
                for (int i = 0; i < n3; ++i) {
                    if (bl) {
                        progressDialog.setValue(i);
                        Thread.sleep(1000L);
                    }
                    string5 = i + 1 == n3 ? string.substring(i * MAX_MESSAGE_LENGTH_CHARS) : string.substring(i * MAX_MESSAGE_LENGTH_CHARS, (i + 1) * MAX_MESSAGE_LENGTH_CHARS);
                    CustomEvent customEvent = new CustomEvent((Object)this.getHandler(), iD);
                    this.getHandler().setProperty(WUC_DATA, string5);
                    this.getHandler().setProperty(WUC_DATA_MULTIPART, "" + (i + 1) + "/" + n3);
                    super.dispatchCustomEvent(customEvent);
                }
                if (bl) {
                    progressDialog.setVisible(false);
                }
            }
            catch (Exception exception) {
                this.unexpectedError("VBeanCommon.coreMessageDispatcher()", exception);
            }
        }
    }

    public boolean isLogging() {
        return this.getLogger().isLogging();
    }

    public void log(byte by, String string, String string2) {
        this.getLogger().log(by, string, string2);
    }

    public void getPropertyLogBefore(String string) {
        if (this.isLogging()) {
            this.getLogger().log((byte)0, "getProperty()", "Getting property " + string);
        }
    }

    public void getPropertyLogAfter(String string, Object object) {
        if (this.isLogging()) {
            this.getLogger().log((byte)1, "getProperty()", "Value of " + string + "=" + this.safePrint(object));
        }
    }

    public void setPropertyLogBefore(String string, Object object) {
        if (this.isLogging()) {
            this.getLogger().log((byte)0, "setProperty()", "Setting property " + string + " to " + this.safePrint(object));
        }
    }

    public void errorMsg(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string5 = stringTokenizer.nextToken();
        int n = Integer.parseInt(string5.substring(5, 8));
        String string6 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        this.error(n, string6, this.getTranslatedMessage(string5, string2, string3, string4));
    }

    public void error(int n, String string, String string2) {
        this.getLogger().error(n, string, string2);
    }

    public String safePrint(Object object) {
        String string = null;
        try {
            string = object.toString();
        }
        catch (NullPointerException nullPointerException) {
            string = "{NULL}";
        }
        return string;
    }

    public String boolAsString(boolean bl) {
        return bl ? "TRUE" : "FALSE";
    }

    public boolean checkPLSQLString(Object object) {
        boolean bl = false;
        if (object instanceof String && !((String)object).equals("") && object != null) {
            bl = true;
        }
        return bl;
    }

    public boolean checkPLSQLBoolean(Object object) {
        boolean bl = false;
        if (object != null) {
            if (object instanceof String) {
                bl = ((String)object).equalsIgnoreCase("true");
            } else if (object instanceof Boolean) {
                bl = (Boolean)object;
            }
        }
        return bl;
    }

    public int storeInObjectCache(Object object) {
        if (s_objectCache == null) {
            s_objectCache = new Vector(10, 5);
            s_objectOwners = new Vector(10, 5);
            s_cacheIndex = 0;
        }
        s_objectCache.add(object);
        s_objectOwners.add(this);
        ++this.m_objCount;
        return ++s_cacheIndex;
    }

    public Object getFromObjectCache(int n) {
        Object var2_2 = null;
        if (s_objectCache != null) {
            try {
                var2_2 = s_objectCache.get(n - 1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.error(14, "getFromObjectCache", this.getTranslatedMessage("ERROR014", "" + n, null, null));
            }
        } else {
            this.error(13, "getFromObjectCache", this.getTranslatedMessage("ERROR013"));
        }
        if (var2_2 == null) {
            this.error(14, "getFromObjectCache", this.getTranslatedMessage("ERROR014", "" + n, null, null));
        }
        return var2_2;
    }

    public void eraseFromObjectCache(int n) {
        if (s_objectCache != null) {
            try {
                s_objectCache.setElementAt(null, n - 1);
                if (s_objectOwners.elementAt(n - 1) == this) {
                    --this.m_objCount;
                }
                if (s_objectOwners.elementAt(n - 1) == null) {
                    --s_global;
                } else {
                    s_objectOwners.setElementAt(null, n - 1);
                }
                this.log((byte)1, "VBeanCommon.eraseFromObjectCache()", "Removed cache reference to Object " + n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.error(14, "eraseFromObjectCache", this.getTranslatedMessage("ERROR014", "" + n, null, null));
            }
        }
    }

    public String defaultNullPropertyValue(Object object, String string) {
        if (object instanceof String && object != null) {
            return (String)object;
        }
        return string;
    }

    public void unexpectedError(String string, Exception exception) {
        exception.printStackTrace();
        this.error(15, string, this.getTranslatedMessage("ERROR015", exception.toString(), null, null));
    }

    private void setWebutilProperty(String string) {
        if (string != null) {
            this.loadSettings();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (string3.trim().equalsIgnoreCase("")) {
                m_settings.remove(string2);
            } else {
                m_settings.setProperty(string2, string3);
            }
            this.saveSettings();
        } else {
            this.error(16, "VBeanCommon.setWebutilProperty()", this.getTranslatedMessage("ERROR016", null, null, null));
        }
    }

    private String getWebutilProperty(String string) {
        this.loadSettings();
        String string2 = m_settings.getProperty(string);
        if (this.m_jacobdir == null && string.startsWith("syslib.")) {
            int n = -1;
            n = string.toLowerCase().indexOf("jacob");
            if (n != -1) {
                this.m_jacobdir = VBeanCommon.getSyslibPath() + FILE_SEP + string.substring(n);
                System.setProperty("jacob.dll.path", this.m_jacobdir);
            }
        }
        return string2 == null ? "" : string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettings() {
        if (m_settings == null) {
            m_settings = new Properties();
            try {
                String string = WEBUTIL_PROPERTIES;
                FileInputStream fileInputStream = new FileInputStream(string);
                try {
                    m_settings.load(fileInputStream);
                }
                finally {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                this.getLogger().log((byte)0, "loadSettings()", "Local properties file loaded");
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.getLogger().log((byte)0, "loadSettings()", "No local properties file to load");
            }
            catch (Exception exception) {
                this.unexpectedError("VBeanCommon.loadSettings()", exception);
            }
        }
    }

    private void saveSettings() {
        try {
            String string = WEBUTIL_PROPERTIES;
            try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
                m_settings.store(fileOutputStream, "WebUtil Properties File");
            }
            this.getLogger().log((byte)0, "saveSettings()", "Local properties file saved");
        }
        catch (Exception exception) {
            this.unexpectedError("VBeanCommon.saveSettings()", exception);
        }
    }

    private String downloadFromURL(String string) {
        URL uRL;
        String string2;
        Object object;
        boolean bl = false;
        if (string == null || string.equalsIgnoreCase("")) {
            this.error(17, "VBeanCommon.downloadFromURL()", this.getTranslatedMessage("ERROR017", "(null)", null, null));
            return "FALSE";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.countTokens() < 5) {
            this.error(17, "VBeanCommon.downloadFromURL()", this.getTranslatedMessage("ERROR017", string, null, null));
            return "FALSE";
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        boolean bl2 = stringTokenizer.nextToken().equals("Y");
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        if (string3 == null || string3.equalsIgnoreCase("")) {
            this.error(25, "URLDownload.pullFile()", this.getTranslatedMessage("ERROR025"));
            return "FALSE";
        }
        if (string4 == null || string4.equalsIgnoreCase("")) {
            this.error(130, "URLDownload.pullFile()", this.getTranslatedMessage("ERROR130"));
            return "FALSE";
        }
        String string5 = string4;
        if (n == 1) {
            for (int i = 0; i < m_sessionSyslibs.size(); ++i) {
                object = (String)m_sessionSyslibs.get(i);
                if (!((String)object).equalsIgnoreCase(string3)) continue;
                this.error(31, "URLDownload.pullFile()", this.getTranslatedMessage("ERROR031"));
                return "FALSE";
            }
            m_sessionSyslibs.add(string3);
            if (SYSLIB_PATH == null) {
                string5 = FILE_SEP.equalsIgnoreCase("\\") ? JRE_HOME_ROOT + "bin" + FILE_SEP + string4 : JRE_HOME_ROOT + "lib" + FILE_SEP + string4;
            } else {
                File file = new File(SYSLIB_PATH);
                if (!file.exists()) {
                    file.mkdirs();
                }
                string5 = new File(file, string4).getPath();
                if (this.m_jacobdir == null && string5.toLowerCase().indexOf("jacob") != -1) {
                    System.setProperty("jacob.dll.path", string5);
                    this.m_jacobdir = string5;
                }
            }
        }
        if (string3.startsWith("/")) {
            string3 = string3.substring(1);
        }
        try {
            object = this.getHandler().getDocumentBase();
            if (this.getHandler().getApplet().isWebstartRequest()) {
                string2 = ((URL)object).toString();
                string2 = string2.concat("../");
                uRL = new URL(string2);
                uRL = new URL(uRL, string3);
            } else {
                uRL = new URL((URL)object, string3);
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.error(18, "URLDownload.pullFile()", this.getTranslatedMessage("ERROR018", string3, null, null));
            return "FALSE";
        }
        string3 = uRL.toString();
        this.log((byte)1, "downloadFromURL()", "Source is " + string3);
        object = this.getHandler().getApplet().isStandAloneAppRequest() ? new URLDownload(string3, string5, n2, this.m_logger, this) : new URLDownload(string3, string5, n2, this.m_logger);
        if (bl2) {
            string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "Dowloading URL " + string3;
            String string6 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "Downloading URL " + string3 + " in progress...";
            String string7 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "URL download in progress...";
            ((URLDownload)object).setProgressEnabled(this.getFrame(), string2, string6, string7);
        }
        bl = ((URLDownload)object).pullFile(n > 0);
        return bl ? "TRUE" : "FALSE";
    }

    private void handleGlobalRef(String string) {
        block5: {
            try {
                if (string != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                    int n = Integer.parseInt(stringTokenizer.nextToken());
                    if (stringTokenizer.nextToken().equalsIgnoreCase("Y")) {
                        this.persistRef(n);
                    } else {
                        this.freeRef(n);
                    }
                    break block5;
                }
                throw new Exception();
            }
            catch (Exception exception) {
                this.error(22, "VBeanCommon.handleGlobalRef()", this.getTranslatedMessage("ERROR022", string, null, null));
            }
        }
    }

    private void persistRef(int n) {
        s_objectOwners.setElementAt(null, n - 1);
        ++s_global;
        this.log((byte)1, "VBeanCommon.persistRef()", "Object Reference " + n + " persisted");
    }

    private void freeRef(int n) {
        this.eraseFromObjectCache(n - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJvmSysPath() {
        Class<ClassLoader> clazz = ClassLoader.class;
        try {
            Field field = clazz.getDeclaredField("sys_paths");
            boolean bl = field.isAccessible();
            if (!bl) {
                field.setAccessible(true);
            }
            try {
                field.set(clazz, null);
                String string = System.getProperty("java.library.path");
                String string2 = SYSLIB_PATH + System.getProperty("path.separator") + string;
                System.setProperty("java.library.path", string2);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.error(29, "VBeanCommon.downloadFromURL()", this.getTranslatedMessage("ERROR029"));
            }
            finally {
                field.setAccessible(bl);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.error(30, "VBeanCommon.downloadFromURL()", this.getTranslatedMessage("ERROR030"));
        }
    }

    static {
        String string = System.getProperty("os.arch");
        if (string != null && string.indexOf("64") > -1) {
            OS_ARCH = "64";
        }
        WEBUTIL_PROPERTIES = JRE_HOME_ROOT + "webutil." + OS_ARCH + ".properties";
        s_msgMgr = new MessageManager("oracle.forms.webutil.common.WebUtilBundle");
        msgKey = null;
        s_global = 0;
        m_settings = null;
        m_blockAllowHeatBeat = false;
        m_sessionSyslibs = new ArrayList();
    }

    class ProgressThread
    extends Thread {
        VBeanCommon m_dispatcher = null;
        ID m_messageType = null;
        String m_messageData = null;
        int m_threshold = 0;
        String m_dialogTitle = null;
        String m_dialogSubTitle = null;
        String m_dialogMessage = null;

        private ProgressThread(VBeanCommon vBeanCommon2, ID iD, String string, int n, String string2, String string3, String string4) {
            this.m_dispatcher = vBeanCommon2;
            this.m_messageType = iD;
            this.m_messageData = string;
            this.m_threshold = n;
            this.m_dialogTitle = string2;
            this.m_dialogSubTitle = string3;
            this.m_dialogMessage = string4;
        }

        @Override
        public void run() {
            this.m_dispatcher.coreMessageDispatcher(this.m_messageType, this.m_messageData, this.m_threshold, this.m_dialogTitle, this.m_dialogSubTitle, this.m_dialogMessage);
        }
    }
}

