/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressDialog
extends JDialog {
    private DefaultBoundedRangeModel m_model = null;
    private JLabel m_message = null;
    private JProgressBar m_progressBar = null;
    private JPanel m_titlePanel = null;
    private JPanel m_msgPanel = null;
    private static final int WIDTH = 400;
    private static final int HEIGHT = 100;
    private static final Color DIALOG_COLOR = Color.decode("#002288");

    public ProgressDialog(Frame frame, String string, String string2, String string3, int n) {
        super(frame);
        this.setResizable(false);
        this.setTitle(string);
        this.setSize(400, 100);
        this.setModal(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.m_model = new DefaultBoundedRangeModel(0, 1, 0, n);
        this.m_progressBar = new JProgressBar(this.m_model);
        this.m_progressBar.setStringPainted(true);
        this.m_titlePanel = new JPanel();
        this.m_titlePanel.setLayout(new GridLayout());
        JLabel jLabel = new JLabel(string2);
        jLabel.setFont(new Font("Dialog", 1, 12));
        jLabel.setForeground(DIALOG_COLOR);
        this.m_titlePanel.add(jLabel);
        this.m_msgPanel = new JPanel();
        this.m_message = new JLabel(string3);
        this.m_message.setFont(new Font("Dialog", 1, 12));
        this.m_message.setForeground(DIALOG_COLOR);
        this.m_msgPanel.add(this.m_message);
        this.getContentPane().add((Component)this.m_titlePanel, "North");
        this.getContentPane().add((Component)this.m_msgPanel, "South");
        this.getContentPane().add((Component)this.m_progressBar, "Center");
        this.setLocation(this.getCenteredLocation(frame));
    }

    public void setValue(int n) {
        this.m_model.setValue(n);
        this.m_progressBar.paintImmediately(this.m_progressBar.getVisibleRect());
        this.m_titlePanel.paintImmediately(this.m_titlePanel.getVisibleRect());
        this.m_msgPanel.paintImmediately(this.m_msgPanel.getVisibleRect());
    }

    public int getValue() {
        return this.m_model.getValue();
    }

    public void setValue(int n, String string) {
        this.m_message.setText(string);
        this.m_model.setValue(n);
    }

    public void increment() {
        this.m_model.setValue(this.m_model.getValue() + 1);
    }

    public Point getCenteredLocation(Frame frame) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = frame.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        int n = (dimension.width - dimension2.width) / 3;
        int n2 = (dimension.height - dimension2.height) / 3;
        return new Point(n, n2);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Test ProgressBar");
        ProgressDialog progressDialog = new ProgressDialog(frame, "A Title", "My Subtitle", "A Message", 20);
        progressDialog.setVisible(true);
        for (int i = 0; i <= 20; ++i) {
            try {
                progressDialog.setValue(i, "New Value = " + i);
                Thread.sleep(250L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        progressDialog.setVisible(false);
        System.exit(0);
    }
}

