/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.common;

import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.forms.webutil.common.VBeanCommon;

public class LoggingEngine {
    public static final byte LOGMODE_NONE = 0;
    public static final byte LOGMODE_CONSOLE = 1;
    public static final byte LOGMODE_SERVER = 2;
    public static final byte LOGDETAIL_NORMAL = 0;
    public static final byte LOGDETAIL_DETAILED = 1;
    public static final byte ERRORMODE_CONSOLE = 0;
    public static final byte ERRORMODE_ALERT = 1;
    public static final byte ERRORMODE_SERVER = 2;
    private int m_logSettings = 0;
    public int srv_logging = 2;
    private static final int ERRORMODE_MASK = 768;
    private static final int ERRORMODE_RESTRICTED_MASK = 256;
    private static final int LOGDETAIL_MASK = 48;
    private static final int LOGMODE_MASK = 3;
    boolean m_logging = false;
    VBeanCommon m_bean = null;
    String m_source = null;
    SimpleDateFormat m_dateFormat = new SimpleDateFormat("yyyy-MMM-dd  HH:mm:ss.SS");

    public LoggingEngine(String string, VBeanCommon vBeanCommon) {
        this.m_bean = vBeanCommon;
        this.m_source = string;
    }

    public void setSource(String string) {
        this.m_source = string;
    }

    public void setLogMode(byte by) {
        if (by >= 0 && by <= 3) {
            this.m_logSettings = this.m_logSettings & 0xFFFFFFFC | by;
            this.m_logging = by > 0;
        }
    }

    public void setLogMode(String string) {
        int n = -1;
        if (string != null) {
            n = string.equalsIgnoreCase("console") || string.equalsIgnoreCase("on") ? 1 : (string.equalsIgnoreCase("server") ? 2 : (string.equalsIgnoreCase("all") ? 3 : 0));
            this.setLogMode((byte)n);
        }
    }

    public void setLogDetail(byte by) {
        if (by >= 0 && by <= 1) {
            this.m_logSettings = this.m_logSettings & 0xFFFFFFCF | by << 4;
        }
    }

    public void setLogDetail(String string) {
        byte by = -1;
        if (string != null) {
            by = string.equalsIgnoreCase("DETAILED") ? (byte)1 : 0;
            this.setLogDetail(by);
        }
    }

    public byte getLogDetail() {
        return (byte)((this.m_logSettings & 0x30) >> 4);
    }

    public boolean isLogging() {
        return this.m_logging;
    }

    public void setErrorMode(byte by) {
        if (by >= 0 && by <= 3) {
            this.m_logSettings = this.m_logSettings & 0xFFFFFCFF | by << 8;
        }
    }

    public void setErrorMode(String string) {
        int n = -1;
        if (string != null) {
            n = string.equalsIgnoreCase("server") ? 2 : (string.equalsIgnoreCase("alert") ? 1 : (string.equalsIgnoreCase("all") ? 3 : 0));
            this.setErrorMode((byte)n);
        }
    }

    public void setErrorAlertMode(boolean bl) {
        this.m_logSettings = bl ? this.m_logSettings & 0xFFFFFEFF | 0x100 : (this.m_logSettings &= 0xFFFFFEFF);
    }

    public void log(byte by, String string, String string2) {
        if (this.m_logging) {
            String string3 = this.m_dateFormat.format(new Date());
            if ((this.m_logSettings & 0x10) == 16 || by == 0) {
                if ((this.m_logSettings & 1) == 1) {
                    System.out.println(string3 + " " + this.m_source + "[" + string + "] " + string2);
                }
                if ((this.m_logSettings & 2) == 2 && this.srv_logging == 2) {
                    this.m_bean.dispatchLogMessage(string3 + " " + this.m_source + "[" + string + "] " + string2);
                }
            }
        }
    }

    public void error(int n, String string, String string2) {
        String string3 = new String(LoggingEngine.createErrorIdent(this.m_source, n) + " [" + string + "] " + string2);
        String string4 = this.m_dateFormat.format(new Date());
        System.out.println(string4 + " ERROR>" + string3);
        this.m_bean.setErrorCondition(n);
        if ((this.m_logSettings & 0x100) == 256) {
            this.m_bean.alert("Forms", LoggingEngine.createErrorIdent(this.m_source, n) + ": " + string2);
        }
        if ((this.m_logSettings & 0x200) == 512 && this.srv_logging > 0) {
            this.m_bean.dispatchErrorMessage(string4 + " " + string3, n);
        }
    }

    public String getTranslatedMessage(String string) {
        return this.m_bean.getMessageManager().getMessage(string, this.m_bean.getLocale());
    }

    public String getTranslatedMessage(String string, Object object, Object object2, Object object3) {
        return this.m_bean.getMessageManager().getMessage(string, this.m_bean.getLocale(), object, object2, object3);
    }

    public void setSrvLoggingOptions(int n) {
        this.srv_logging = n;
    }

    private static String createErrorIdent(String string, int n) {
        if (n < 100) {
            return "WUC-" + n;
        }
        return string + "-" + n;
    }
}

